/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.execution;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import io.reactivex.Observable;
import io.reactivex.observables.ConnectableObservable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.util.AccumulatorV2;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.engine.api.model.Hop;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.reporting.Status;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.execution.DriverTask;
import org.pentaho.di.engine.spark.impl.execution.OperationDependency;
import org.pentaho.di.engine.spark.impl.execution.TaskObservable;
import org.pentaho.di.engine.spark.impl.listeners.LoggingToAccumAdapter;
import org.pentaho.di.i18n.BaseMessages;

public class ExecutionPlan {
    private final ImmutableMap<String, TaskObservable> sparkOperations;
    private final ImmutableTable<SparkOperation, SparkOperation, OperationDependency> dependencyTable;
    private final ConnectableObservable<DriverTask> driverTasks;

    ExecutionPlan(Map<String, TaskObservable> sparkOperations, ImmutableTable<SparkOperation, SparkOperation, OperationDependency> dependencyTable) {
        this.sparkOperations = ImmutableMap.copyOf(sparkOperations);
        this.dependencyTable = ImmutableTable.copyOf(dependencyTable);
        this.driverTasks = Observable.merge(sparkOperations.values()).publish();
    }

    public ImmutableMap<String, TaskObservable> getMaterializedOperations() {
        return this.sparkOperations;
    }

    public ImmutableTable<SparkOperation, SparkOperation, OperationDependency> getDependencyTable() {
        return this.dependencyTable;
    }

    public ConnectableObservable<DriverTask> getDriverTasks() {
        return this.driverTasks;
    }

    public Observable<Status> getStatus() {
        return this.driverTasks.materialize().map(notification -> {
            if (notification.isOnComplete()) {
                return Status.FINISHED;
            }
            if (notification.isOnError()) {
                return Status.FAILED;
            }
            return Status.RUNNING;
        }).distinctUntilChanged().takeUntil(Status::isFinal);
    }

    public static class Builder {
        private static Class<?> PKG = ExecutionPlan.class;
        private static LogChannelInterface logChannel = KettleLogStore.getLogChannelInterfaceFactory().create(ExecutionPlan.class);
        private static final String DUPLICATED_SPARK_OPERATION = "ExecutionPlan.DuplicatedSparkOperation";
        private static final String CREATING_RUN_PLAN = "ExecutionPlan.CreatingRunPlan";
        private static final String OPERATIONS_REFERENCED_BUT_NOT_DEFINED = "ExecutionPlan.OperationsReferencedButNotDefined";
        private JavaSparkContext sparkContext;
        private final Map<String, SparkOperation> sparkOperations = Maps.newHashMap();
        private final Table<String, String, String> depGraph = HashBasedTable.create();
        private LoggingToAccumAdapter loggingToAccumAdapter;
        private final Map<String, AccumulatorV2<?, ?>> accumulators = Maps.newHashMap();
        private Map<String, MetricsAccumulator> metricAccumulators;

        public Builder(JavaSparkContext javaSparkContext) {
            this.sparkContext = javaSparkContext;
        }

        public Builder add(Collection<? extends Operation> operations, Function<? super Operation, ? extends SparkOperation> compiler) {
            operations.forEach(operation -> this.add((Operation)operation, compiler));
            return this;
        }

        public Builder add(Operation operation, Function<? super Operation, ? extends SparkOperation> compiler) {
            this.add(compiler.apply((Operation)operation));
            Stream.of(operation.getHopsIn(), operation.getHopsOut()).flatMap(Collection::stream).forEach(this::addDependency);
            return this;
        }

        public Builder add(SparkOperation sparkOperation) {
            String id = Objects.requireNonNull(sparkOperation.getId());
            Preconditions.checkState((!this.sparkOperations.containsKey(id) ? 1 : 0) != 0, (String)BaseMessages.getString(PKG, (String)DUPLICATED_SPARK_OPERATION, (String[])new String[0]), (Object[])new Object[]{id});
            this.sparkOperations.put(id, sparkOperation);
            return this;
        }

        public Builder addDependency(String from, String to, String type) {
            this.depGraph.put((Object)from, (Object)to, (Object)type);
            return this;
        }

        public Builder addDependency(Hop hop) {
            return this.addDependency(hop.getFrom().getId(), hop.getTo().getId(), hop.getType());
        }

        public Builder addKettleLogListener(LoggingToAccumAdapter loggingToAccumAdapter) {
            this.loggingToAccumAdapter = loggingToAccumAdapter;
            return this;
        }

        public Builder addAccumulator(String key, AccumulatorV2<?, ?> accumulator) {
            this.accumulators.put(key, accumulator);
            return this;
        }

        public Builder metricAccumulators(Map<String, MetricsAccumulator> metricAccumulators) {
            this.metricAccumulators = metricAccumulators;
            return this;
        }

        public ExecutionPlan build(JavaSparkContext sparkContext) {
            logChannel.logDebug(BaseMessages.getString(PKG, (String)CREATING_RUN_PLAN, (String[])new String[0]));
            Set undefined = Stream.of(this.depGraph.columnKeySet(), this.depGraph.rowKeySet()).flatMap(Collection::stream).filter(id -> !this.sparkOperations.containsKey(id)).collect(Collectors.toSet());
            Preconditions.checkState((boolean)undefined.isEmpty(), (String)BaseMessages.getString(PKG, (String)OPERATIONS_REFERENCED_BUT_NOT_DEFINED, (String[])new String[0]), (Object[])new Object[]{undefined});
            ImmutableTable dependencyTable = this.depGraph.cellSet().stream().map(cell -> {
                SparkOperation from = this.sparkOperations.get(cell.getRowKey());
                SparkOperation to = this.sparkOperations.get(cell.getColumnKey());
                OperationDependency operationDependency = new OperationDependency(from, to, (String)cell.getValue());
                return ImmutableTable.of((Object)from, (Object)to, (Object)operationDependency);
            }).collect(ImmutableTable::builder, ImmutableTable.Builder::putAll, (left, right) -> left.putAll((Table)right.build())).build();
            Map<String, TaskObservable> taskObservables = this.sparkOperations.keySet().stream().collect(Collectors.toMap(id -> id, id -> TaskObservable.create(sparkContext, this.sparkOperations.get(id), (Table<SparkOperation, SparkOperation, OperationDependency>)dependencyTable, this.loggingToAccumAdapter, this.accumulators, this.getMetricAccumulator(sparkContext, (String)id))));
            return new ExecutionPlan(taskObservables, (ImmutableTable<SparkOperation, SparkOperation, OperationDependency>)dependencyTable);
        }

        private MetricsAccumulator getMetricAccumulator(JavaSparkContext sparkContext, String id) {
            if (!this.metricAccumulators.containsKey(id)) {
                this.metricAccumulators.put(id, new MetricsAccumulator(sparkContext, id));
            }
            return this.metricAccumulators.get(id);
        }
    }
}

