/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.execution;

import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import java.util.concurrent.FutureTask;
import org.apache.spark.api.java.JavaSparkContext;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.execution.DriverTask;

public class JobGroupDriverTask
extends FutureTask<Void>
implements CompletableSource {
    private DriverTask driverTask;

    public static JobGroupDriverTask create(JavaSparkContext sparkContext, String jobGroupID, String jobGroupDescription, boolean interruptOnCancel, DriverTask driverTask) {
        return new JobGroupDriverTask(sparkContext, jobGroupID, jobGroupDescription, interruptOnCancel, driverTask);
    }

    private JobGroupDriverTask(JavaSparkContext sparkContext, String jobGroupID, String jobGroupDescription, boolean interruptOnCancel, DriverTask driverTask) {
        super(() -> {
            sparkContext.setJobGroup(jobGroupID, jobGroupDescription, interruptOnCancel);
            driverTask.run();
        }, null);
        this.driverTask = driverTask;
    }

    public SparkOperation getSparkOperation() {
        return this.driverTask.getSparkOperation();
    }

    @Override
    protected void set(Void nothing) {
        super.set(nothing);
        this.driverTask.getSubject().onComplete();
    }

    @Override
    protected void setException(Throwable t) {
        super.setException(t);
        this.driverTask.getSubject().onError(t);
    }

    public void subscribe(CompletableObserver cs) {
        this.driverTask.getSubject().ignoreElements().subscribe(cs);
    }
}

