/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions.sql.functions;

import java.util.ArrayList;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.MutableAggregationBuffer;
import org.apache.spark.sql.expressions.UserDefinedAggregateFunction;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class ConcatStringUDAggregateFunction
extends UserDefinedAggregateFunction {
    private static final String DEFAULT_CONCAT_DELIMETER = ", ";
    private StructType inputSchema;
    private StructType bufferSchema;
    private DataType returnValueDataType;

    public ConcatStringUDAggregateFunction() {
        ArrayList<StructField> inputFields = new ArrayList<StructField>();
        inputFields.add(DataTypes.createStructField((String)"inputColumn", (DataType)DataTypes.StringType, (boolean)false));
        inputFields.add(DataTypes.createStructField((String)"delimeter", (DataType)DataTypes.StringType, (boolean)true));
        this.inputSchema = DataTypes.createStructType(inputFields);
        ArrayList<StructField> bufferFields = new ArrayList<StructField>();
        bufferFields.add(DataTypes.createStructField((String)"concatString", (DataType)DataTypes.StringType, (boolean)true));
        bufferFields.add(DataTypes.createStructField((String)"concatDelimeter", (DataType)DataTypes.StringType, (boolean)true));
        bufferFields.add(DataTypes.createStructField((String)"counter", (DataType)DataTypes.IntegerType, (boolean)true));
        this.bufferSchema = DataTypes.createStructType(bufferFields);
        this.returnValueDataType = DataTypes.StringType;
    }

    public StructType inputSchema() {
        return this.inputSchema;
    }

    public StructType bufferSchema() {
        return this.bufferSchema;
    }

    public DataType dataType() {
        return this.returnValueDataType;
    }

    public boolean deterministic() {
        return true;
    }

    public void initialize(MutableAggregationBuffer buffer) {
        buffer.update(0, (Object)"");
        buffer.update(1, (Object)"");
        buffer.update(2, (Object)0);
    }

    public void update(MutableAggregationBuffer buffer, Row input) {
        String newRowValue = input.getString(0);
        String newRowDelimeter = input.getString(1);
        String existingBufferValue = buffer.getString(0);
        int counter = buffer.getInt(2);
        StringBuffer newBufferValue = new StringBuffer();
        String delimeter = this.getDelimeter(input);
        if (newRowValue == null) {
            return;
        }
        if (existingBufferValue == null || existingBufferValue.trim().isEmpty()) {
            newBufferValue.append(newRowValue);
        } else {
            newBufferValue.append(existingBufferValue).append(delimeter).append(newRowValue);
        }
        buffer.update(0, (Object)newBufferValue.toString());
        buffer.update(1, (Object)delimeter);
        buffer.update(2, (Object)counter++);
    }

    protected String getDelimeter() {
        return this.getDelimeter((MutableAggregationBuffer)null);
    }

    protected String getDelimeter(Row input) {
        String delimeter;
        if (input == null) {
            return DEFAULT_CONCAT_DELIMETER;
        }
        try {
            delimeter = input.getString(1);
        }
        catch (Exception e) {
            return DEFAULT_CONCAT_DELIMETER;
        }
        if (delimeter == null || delimeter.isEmpty()) {
            return DEFAULT_CONCAT_DELIMETER;
        }
        return delimeter;
    }

    protected String getDelimeter(MutableAggregationBuffer buffer) {
        String delimeter;
        if (buffer == null) {
            return null;
        }
        try {
            delimeter = buffer.getString(1);
        }
        catch (Exception e) {
            return null;
        }
        if (delimeter == null || delimeter.isEmpty()) {
            return null;
        }
        return delimeter;
    }

    public void merge(MutableAggregationBuffer buffer1, Row buffer2) {
        StringBuffer newBufferValue = new StringBuffer();
        String buffer1Value = buffer1.getString(0);
        String buffer2Value = buffer2.getString(0);
        String buffer1Delim = buffer1.getString(1);
        String buffer2Delim = buffer2.getString(1);
        String buffer1Delimeter = this.getDelimeter(buffer1);
        String buffer2Delimeter = this.getDelimeter(buffer2);
        int counter1 = buffer1.getInt(2);
        int counter2 = buffer2.getInt(2);
        String delimeter = buffer1Delimeter != null ? buffer1Delimeter : buffer2Delimeter;
        newBufferValue.append(buffer1Value != null ? buffer1Value : "").append(buffer1Value != null && !buffer1Value.trim().isEmpty() ? delimeter : "").append(buffer2Value);
        buffer1.update(0, (Object)newBufferValue.toString());
    }

    public String evaluate(Row buffer) {
        return buffer.getString(0);
    }
}

