/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions.sql.functions;

import java.util.ArrayList;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.MutableAggregationBuffer;
import org.apache.spark.sql.expressions.UserDefinedAggregateFunction;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class FirstUDAggregateFunction
extends UserDefinedAggregateFunction {
    private String NULL_VALUE = "null";
    private Boolean DEFAULT_VALUE_IGNORE_NULLS = Boolean.TRUE;
    private StructType inputSchema;
    private StructType bufferSchema;
    private DataType returnValueDataType;

    public FirstUDAggregateFunction() {
        ArrayList<StructField> inputFields = new ArrayList<StructField>();
        inputFields.add(DataTypes.createStructField((String)"inputColumn", (DataType)DataTypes.StringType, (boolean)false));
        inputFields.add(DataTypes.createStructField((String)"ignoreNulls", (DataType)DataTypes.StringType, (boolean)true));
        this.inputSchema = DataTypes.createStructType(inputFields);
        ArrayList<StructField> bufferFields = new ArrayList<StructField>();
        bufferFields.add(DataTypes.createStructField((String)"firstValue", (DataType)DataTypes.StringType, (boolean)true));
        this.bufferSchema = DataTypes.createStructType(bufferFields);
        this.returnValueDataType = DataTypes.StringType;
    }

    public StructType inputSchema() {
        return this.inputSchema;
    }

    public StructType bufferSchema() {
        return this.bufferSchema;
    }

    public DataType dataType() {
        return this.returnValueDataType;
    }

    public boolean deterministic() {
        return true;
    }

    public void initialize(MutableAggregationBuffer buffer) {
        buffer.update(0, (Object)"");
    }

    public void update(MutableAggregationBuffer buffer, Row input) {
        String newValue = input.getString(0);
        Boolean ignoreNulls = input.getString(1) == null ? this.DEFAULT_VALUE_IGNORE_NULLS : Boolean.valueOf(input.getString(1));
        String bufferValue = buffer.getString(0);
        if (bufferValue != null && !bufferValue.isEmpty()) {
            return;
        }
        if (newValue != null && !newValue.isEmpty()) {
            buffer.update(0, (Object)newValue);
            return;
        }
        if (!ignoreNulls.booleanValue()) {
            buffer.update(0, (Object)this.NULL_VALUE);
            return;
        }
    }

    public void merge(MutableAggregationBuffer buffer1, Row buffer2) {
        StringBuffer newBufferValue = new StringBuffer();
        String buffer1Value = buffer1.getString(0);
        String buffer2Value = buffer2.getString(0);
        if (buffer1Value != null && !buffer1Value.isEmpty()) {
            return;
        }
        buffer1.update(0, (Object)buffer2Value);
    }

    public String evaluate(Row buffer) {
        String bufferValue = buffer.getString(0);
        bufferValue = this.NULL_VALUE.equals(bufferValue) ? null : bufferValue;
        return bufferValue;
    }
}

