/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.util;

import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.pentaho.di.core.exception.KettleMissingPluginsException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.spark.api.SparkEngineException;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MetaHelper {
    public static TransMeta getTransMeta(Transformation transformation) {
        String transMetaXml = (String)transformation.getConfig().get("TransMeta");
        try {
            return new TransMeta(MetaHelper.getNode(transMetaXml, "transformation"), null);
        }
        catch (KettleMissingPluginsException | KettleXMLException e) {
            throw new RuntimeException(e);
        }
    }

    public static Node getNode(String xml, String id) {
        try {
            Document doc = XMLHandler.loadXMLString((String)xml);
            return XMLHandler.getSubNode((Node)doc, (String)id);
        }
        catch (KettleXMLException e) {
            throw new RuntimeException(e);
        }
    }

    public static StepMeta getStepMeta(String id, TransMeta transMeta) {
        return transMeta.getSteps().stream().filter(stepMeta -> stepMeta.getName().equals(id)).findFirst().orElseThrow(() -> new RuntimeException("Couldn't find corresponding input step " + id));
    }

    public static RowMetaInterface getRowMeta(TransMeta transMeta, String stepName) {
        try {
            return transMeta.getStepFields(stepName);
        }
        catch (KettleStepException e) {
            throw new RuntimeException(e);
        }
    }

    public static RowMetaInterface getRowMeta(StepMeta stepMeta) {
        try {
            return stepMeta.getParentTransMeta().getStepFields(stepMeta);
        }
        catch (KettleStepException e) {
            throw new SparkEngineException("Failed to get step fields for " + stepMeta.getName());
        }
    }

    public static RowMetaInterface getPrevStepFields(TransMeta transMeta, String stepName) {
        try {
            return transMeta.getPrevStepFields(stepName);
        }
        catch (KettleStepException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends StepMetaInterface> T getTypedStepMeta(StepMeta stepMeta, Class<T> clazz) {
        return (T)Optional.ofNullable(stepMeta).map(StepMeta::getStepMetaInterface).filter(clazz::isInstance).map(clazz::cast).orElseThrow(() -> new IllegalArgumentException(MessageFormat.format("Couldn''t find corresponding input step {0} [{1}]", stepMeta.getName(), stepMeta.getTypeId())));
    }

    @Deprecated
    public static <T> T getFromMeta(StepMetaInterface meta, String metaInjectPropName) {
        return Stream.concat(Arrays.stream(meta.getClass().getDeclaredFields()), Arrays.stream(meta.getClass().getSuperclass().getDeclaredFields())).filter(field -> metaInjectPropName.equals(field.getName())).map(field -> MetaHelper.fieldVal(meta, field)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static <T> T fieldVal(Object o, Field field) {
        try {
            field.setAccessible(true);
            return (T)field.get(o);
        }
        catch (IllegalAccessException e) {
            throw new SparkEngineException(e);
        }
    }
}

