/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.engine.spark.api.Field;
import org.pentaho.di.engine.spark.api.SparkEngineException;
import org.pentaho.di.engine.spark.api.TypeMapper;
import org.pentaho.di.i18n.BaseMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructTypeMapper
implements TypeMapper<StructType> {
    static final long serialVersionUID = -687001492234005033L;
    private static final Map<Integer, DataType> kettleSparkTypeMap;
    private static final Map<Integer, DataType> readSparkTypeMap;
    static final DataType DEFAULT_DECIMAL_TYPE;
    protected List<Field> inputFields;
    protected List<Field> outputFields;
    private static final Logger LOG;
    private static final ImmutableMap<Integer, MapForSpark> KETTLE_TO_STRUCT_TYPE_CONVERSION;

    public StructTypeMapper() {
    }

    public StructTypeMapper(RowMetaInterface outputMeta) {
        this.outputFields = StructTypeMapper.from(outputMeta);
        this.inputFields = this.outputFields;
    }

    public StructTypeMapper(RowMetaInterface inputMeta, RowMetaInterface outputMeta) {
        this.outputFields = StructTypeMapper.from(outputMeta);
        this.inputFields = StructTypeMapper.from(inputMeta);
    }

    @Override
    public Object[] mapValuesTo(Object[] vals) {
        this.preconditions(vals);
        Object[] objects = new Object[this.outputFields.size()];
        for (int i = 0; i < this.outputFields.size(); ++i) {
            objects[i] = this.typeToSparkCompatible(vals[this.inputIndex(i)], this.outputFields.get(i));
        }
        return objects;
    }

    private int inputIndex(int i) {
        return this.inputFields.indexOf(this.correspondingInput(this.outputFields.get(i).getName()));
    }

    protected Field correspondingInput(String outputFieldName) {
        return this.inputFields.stream().filter(f -> f.getName().equals(outputFieldName)).findFirst().orElseThrow(() -> new SparkEngineException(StructTypeMapper.msg("ERROR.No_Matching_Input", outputFieldName)));
    }

    @Override
    public Object[] mapValuesFrom(StructType schema, Object[] vals) {
        this.preconditions(vals);
        Preconditions.checkArgument((vals.length == schema.fields().length ? 1 : 0) != 0);
        StructField[] structFields = schema.fields();
        return IntStream.range(0, structFields.length).mapToObj(index -> this.typeToKettleCompatible(vals[index], structFields[index].dataType(), this.outputFields.get(index))).collect(Collectors.toList()).toArray();
    }

    @Override
    public StructType schema() {
        StructType structType = this.getStructType(this.getSparkTypeMap());
        LOG.debug("Schema:  " + structType);
        return structType;
    }

    @Override
    public StructType schemaForRead() {
        StructType structType = this.getStructType(this.getSparkTypeMapForRead());
        LOG.debug("Schema:  " + structType);
        return structType;
    }

    private Map<Integer, DataType> getSparkTypeMap() {
        return kettleSparkTypeMap;
    }

    private Map<Integer, DataType> getSparkTypeMapForRead() {
        return readSparkTypeMap;
    }

    protected Object typeToKettleCompatible(Object value, DataType sparkSqlType, Field field) {
        Object toRet = value;
        if (value == null) {
            return null;
        }
        if (this.isDate(field.getType())) {
            toRet = this.handleDate(sparkSqlType, value, field);
        } else if (field.getType() == 10) {
            toRet = this.handleAddress(sparkSqlType, value, field);
        }
        return toRet;
    }

    private Object typeToSparkCompatible(Object object, Field field) {
        Object result = object;
        if (result == null && field.isNullable()) {
            return null;
        }
        if (result == null) {
            result = this.nullValToDefault(field);
        }
        return ((MapForSpark)Optional.ofNullable(KETTLE_TO_STRUCT_TYPE_CONVERSION.get((Object)field.getType())).orElse(o -> o)).apply(result);
    }

    private Object nullValToDefault(Field field) {
        try {
            ValueMetaInterface valueMetaBase = ValueMetaFactory.createValueMeta((String)field.getName(), (int)field.getType(), (int)field.getLength(), (int)field.getPrecision());
            ValueMetaString stringValueMeta = new ValueMetaString();
            if (this.isDate(field.getType())) {
                valueMetaBase.setConversionMask(field.getDateFormat().toPattern());
                stringValueMeta.setConversionMask(field.getDateFormat().toPattern());
            }
            return valueMetaBase.convertDataFromString(field.getIfNull().toString(), (ValueMetaInterface)stringValueMeta, null, null, 3);
        }
        catch (KettlePluginException | KettleValueException e) {
            throw new SparkEngineException(e);
        }
    }

    private void preconditions(Object[] vals) {
        Preconditions.checkNotNull(this.outputFields);
        Preconditions.checkNotNull((Object)vals);
        Preconditions.checkArgument((this.outputFields.size() <= vals.length ? 1 : 0) != 0);
    }

    private Date handleDate(DataType sparkSqlType, Object value, Field field) {
        if (sparkSqlType == DataTypes.TimestampType) {
            return (Timestamp)value;
        }
        if (sparkSqlType == DataTypes.StringType) {
            return this.parseDate((String)value, field);
        }
        throw new RuntimeException(StructTypeMapper.msg("ERROR.Unexpected_Type", sparkSqlType, ValueMetaBase.getTypeDesc((int)field.getType()), field.getName()));
    }

    private InetAddress handleAddress(DataType sparkSqlType, Object value, Field field) {
        try {
            if (sparkSqlType == DataTypes.BinaryType) {
                return value == null ? null : InetAddress.getByAddress((byte[])value);
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e.getMessage());
        }
        throw new RuntimeException(StructTypeMapper.msg("ERROR.Unexpected_Type", sparkSqlType, ValueMetaBase.getTypeDesc((int)field.getType()), field.getName()));
    }

    public boolean isDate(int kettleType) {
        return kettleType == 3 || kettleType == 9;
    }

    private Date parseDate(String value, Field field) {
        try {
            return field.getDateFormat().parse(value);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private StructType getStructType(Map<Integer, DataType> kettleSparkTypeMap) {
        List structFields = this.outputFields.stream().map(field -> DataTypes.createStructField((String)field.getPath(), (DataType)StructTypeMapper.getSparkType(field, kettleSparkTypeMap), (boolean)field.isNullable())).collect(Collectors.toList());
        return DataTypes.createStructType(structFields);
    }

    private static DataType getSparkType(Field field, Map<Integer, DataType> mappingTypes) {
        DataType sparkDataType = mappingTypes.get(field.getType());
        Preconditions.checkNotNull((Object)sparkDataType, (Object)StructTypeMapper.msg("ERROR.Spark_Datatype_Not_Found", field.getName(), field.getType()));
        if (sparkDataType.sameType(DEFAULT_DECIMAL_TYPE)) {
            int length = field.getLength();
            int precision = field.getPrecision();
            if (length > 0) {
                precision = precision > length ? length : precision;
                return DataTypes.createDecimalType((int)length, (int)(precision < 0 ? 0 : precision));
            }
        }
        return sparkDataType;
    }

    public static Field fromField(int fieldIndex, RowMetaInterface rowMeta) {
        ValueMetaInterface valueMeta = rowMeta.getValueMeta(fieldIndex);
        int type = valueMeta.getType();
        Field.FieldBuilder builder = Field.builder().name(rowMeta.getFieldNames()[fieldIndex]).type(type).precision(valueMeta.getPrecision()).length(valueMeta.getLength()).dateFormat(valueMeta.getDateFormat());
        if (type == 3 || type == 9) {
            Preconditions.checkArgument((valueMeta.getFormatMask() != null ? 1 : 0) != 0);
            builder.dateFormat(valueMeta.getDateFormat());
        }
        return builder.build();
    }

    public static Field fromField(String fieldName, RowMetaInterface rowMeta) {
        int fieldIndex = -1;
        String fowMetaFieldName = null;
        for (int i = 0; i < rowMeta.size(); ++i) {
            fowMetaFieldName = rowMeta.getFieldNames()[i];
            if (!fowMetaFieldName.equals(fieldName)) continue;
            fieldIndex = i;
        }
        if (fieldIndex < 0) {
            return null;
        }
        return StructTypeMapper.fromField(fieldIndex, rowMeta);
    }

    public static List<Field> from(RowMetaInterface rowMeta) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (int i = 0; i < rowMeta.size(); ++i) {
            Field field = StructTypeMapper.fromField(i, rowMeta);
            fields.add(field);
        }
        return fields;
    }

    protected static String msg(String key, Object ... args) {
        return BaseMessages.getString(TypeMapper.class, (String)key, (Object[])args);
    }

    static {
        DEFAULT_DECIMAL_TYPE = DataTypes.createDecimalType((int)18, (int)4);
        LOG = LoggerFactory.getLogger(StructTypeMapper.class);
        KETTLE_TO_STRUCT_TYPE_CONVERSION = ImmutableMap.builder().put((Object)10, input -> ((InetAddress)input).getAddress()).put((Object)3, input -> new Timestamp(((Date)input).getTime())).build();
        kettleSparkTypeMap = new HashMap<Integer, DataType>();
        kettleSparkTypeMap.put(1, DataTypes.DoubleType);
        kettleSparkTypeMap.put(2, DataTypes.StringType);
        kettleSparkTypeMap.put(4, DataTypes.BooleanType);
        kettleSparkTypeMap.put(5, DataTypes.LongType);
        kettleSparkTypeMap.put(6, DEFAULT_DECIMAL_TYPE);
        kettleSparkTypeMap.put(8, DataTypes.BinaryType);
        kettleSparkTypeMap.put(7, DataTypes.BinaryType);
        kettleSparkTypeMap.put(10, DataTypes.BinaryType);
        kettleSparkTypeMap.put(3, DataTypes.TimestampType);
        kettleSparkTypeMap.put(9, DataTypes.TimestampType);
        readSparkTypeMap = new HashMap<Integer, DataType>(kettleSparkTypeMap);
        readSparkTypeMap.put(3, DataTypes.StringType);
        readSparkTypeMap.put(9, DataTypes.StringType);
    }

    @FunctionalInterface
    static interface MapForSpark
    extends Function<Object, Object>,
    Serializable {
    }
}

