/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.exec.ListSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapper;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchTask
extends Task<FetchWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int maxRows = 100;
    private FetchOperator fetch;
    private ListSinkOperator sink;
    private int totalRows;
    private static final transient Logger LOG = LoggerFactory.getLogger(FetchTask.class);

    public void setValidTxnList(String txnStr) {
        this.fetch.setValidTxnList(txnStr);
    }

    @Override
    public void initialize(QueryState queryState, QueryPlan queryPlan, DriverContext ctx, CompilationOpContext opContext) {
        super.initialize(queryState, queryPlan, ctx, opContext);
        ((FetchWork)this.work).initializeForFetch(opContext);
        try {
            JobConf job = new JobConf((Configuration)this.conf);
            Operator<?> source = ((FetchWork)this.work).getSource();
            if (source instanceof TableScanOperator) {
                TableScanOperator ts = (TableScanOperator)source;
                ColumnProjectionUtils.appendReadColumns((Configuration)job, ts.getNeededColumnIDs(), ts.getNeededColumns());
                HiveInputFormat.pushFilters(job, ts);
                AcidUtils.setTransactionalTableScan((Configuration)job, ((TableScanDesc)ts.getConf()).isAcidTable());
            }
            this.sink = ((FetchWork)this.work).getSink();
            this.fetch = new FetchOperator((FetchWork)this.work, job, source, this.getVirtualColumns(source));
            source.initialize((Configuration)this.conf, new ObjectInspector[]{this.fetch.getOutputObjectInspector()});
            this.totalRows = 0;
            ExecMapper.setDone(false);
        }
        catch (Exception e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    private List<VirtualColumn> getVirtualColumns(Operator<?> ts) {
        if (ts instanceof TableScanOperator && ts.getConf() != null) {
            return ((TableScanDesc)((TableScanOperator)ts).getConf()).getVirtualCols();
        }
        return null;
    }

    @Override
    public int execute(DriverContext driverContext) {
        assert (false);
        return 0;
    }

    public TableDesc getTblDesc() {
        return ((FetchWork)this.work).getTblDesc();
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public boolean fetch(List res) throws IOException, CommandNeedRetryException {
        this.sink.reset(res);
        int rowsRet = ((FetchWork)this.work).getLeastNumRows();
        if (rowsRet <= 0) {
            rowsRet = ((FetchWork)this.work).getLimit() >= 0 ? Math.min(((FetchWork)this.work).getLimit() - this.totalRows, this.maxRows) : this.maxRows;
        }
        try {
            if (rowsRet <= 0 || ((FetchWork)this.work).getLimit() == this.totalRows) {
                this.fetch.clearFetchContext();
                boolean bl = false;
                return bl;
            }
            boolean fetched = false;
            while (this.sink.getNumRows() < rowsRet) {
                if (!this.fetch.pushRow()) {
                    if (((FetchWork)this.work).getLeastNumRows() > 0) {
                        throw new CommandNeedRetryException();
                    }
                    this.fetch.closeOperator();
                    boolean bl = fetched;
                    return bl;
                }
                fetched = true;
            }
            boolean bl = true;
            return bl;
        }
        catch (CommandNeedRetryException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this.totalRows += this.sink.getNumRows();
        }
    }

    public boolean isFetchFrom(FileSinkDesc fs) {
        return fs.getFinalDirName().equals((Object)((FetchWork)this.work).getTblDir());
    }

    @Override
    public StageType getType() {
        return StageType.FETCH;
    }

    @Override
    public String getName() {
        return "FETCH";
    }

    public void clearFetch() throws HiveException {
        if (this.fetch != null) {
            this.fetch.clearFetchContext();
        }
    }
}

