/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class VectorColumnSetInfo {
    protected int[] longIndices;
    protected int[] doubleIndices;
    protected int[] stringIndices;
    protected int[] decimalIndices;
    protected int[] timestampIndices;
    protected int[] intervalDayTimeIndices;
    protected KeyLookupHelper[] indexLookup;
    private int keyCount;
    private int addIndex;
    protected int longIndicesIndex;
    protected int doubleIndicesIndex;
    protected int stringIndicesIndex;
    protected int decimalIndicesIndex;
    protected int timestampIndicesIndex;
    protected int intervalDayTimeIndicesIndex;

    protected VectorColumnSetInfo(int keyCount) {
        this.keyCount = keyCount;
        this.addIndex = 0;
        this.longIndices = new int[this.keyCount];
        this.longIndicesIndex = 0;
        this.doubleIndices = new int[this.keyCount];
        this.doubleIndicesIndex = 0;
        this.stringIndices = new int[this.keyCount];
        this.stringIndicesIndex = 0;
        this.decimalIndices = new int[this.keyCount];
        this.decimalIndicesIndex = 0;
        this.timestampIndices = new int[this.keyCount];
        this.timestampIndicesIndex = 0;
        this.intervalDayTimeIndices = new int[this.keyCount];
        this.intervalDayTimeIndicesIndex = 0;
        this.indexLookup = new KeyLookupHelper[this.keyCount];
    }

    protected void addKey(String outputType) throws HiveException {
        this.indexLookup[this.addIndex] = new KeyLookupHelper();
        String typeName = VectorizationContext.mapTypeNameSynonyms(outputType);
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)typeName);
        ColumnVector.Type columnVectorType = VectorizationContext.getColumnVectorTypeFromTypeInfo(typeInfo);
        switch (columnVectorType) {
            case LONG: {
                this.longIndices[this.longIndicesIndex] = this.addIndex;
                this.indexLookup[this.addIndex].setLong(this.longIndicesIndex);
                ++this.longIndicesIndex;
                break;
            }
            case DOUBLE: {
                this.doubleIndices[this.doubleIndicesIndex] = this.addIndex;
                this.indexLookup[this.addIndex].setDouble(this.doubleIndicesIndex);
                ++this.doubleIndicesIndex;
                break;
            }
            case BYTES: {
                this.stringIndices[this.stringIndicesIndex] = this.addIndex;
                this.indexLookup[this.addIndex].setString(this.stringIndicesIndex);
                ++this.stringIndicesIndex;
                break;
            }
            case DECIMAL: {
                this.decimalIndices[this.decimalIndicesIndex] = this.addIndex;
                this.indexLookup[this.addIndex].setDecimal(this.decimalIndicesIndex);
                ++this.decimalIndicesIndex;
                break;
            }
            case TIMESTAMP: {
                this.timestampIndices[this.timestampIndicesIndex] = this.addIndex;
                this.indexLookup[this.addIndex].setTimestamp(this.timestampIndicesIndex);
                ++this.timestampIndicesIndex;
                break;
            }
            case INTERVAL_DAY_TIME: {
                this.intervalDayTimeIndices[this.intervalDayTimeIndicesIndex] = this.addIndex;
                this.indexLookup[this.addIndex].setIntervalDayTime(this.intervalDayTimeIndicesIndex);
                ++this.intervalDayTimeIndicesIndex;
                break;
            }
            default: {
                throw new HiveException("Unexpected column vector type " + columnVectorType);
            }
        }
        ++this.addIndex;
    }

    protected void finishAdding() {
        this.longIndices = Arrays.copyOf(this.longIndices, this.longIndicesIndex);
        this.doubleIndices = Arrays.copyOf(this.doubleIndices, this.doubleIndicesIndex);
        this.stringIndices = Arrays.copyOf(this.stringIndices, this.stringIndicesIndex);
        this.decimalIndices = Arrays.copyOf(this.decimalIndices, this.decimalIndicesIndex);
        this.timestampIndices = Arrays.copyOf(this.timestampIndices, this.timestampIndicesIndex);
        this.intervalDayTimeIndices = Arrays.copyOf(this.intervalDayTimeIndices, this.intervalDayTimeIndicesIndex);
    }

    public class KeyLookupHelper {
        public int longIndex;
        public int doubleIndex;
        public int stringIndex;
        public int decimalIndex;
        public int timestampIndex;
        public int intervalDayTimeIndex;
        private static final int INDEX_UNUSED = -1;

        private void resetIndices() {
            this.intervalDayTimeIndex = -1;
            this.timestampIndex = -1;
            this.decimalIndex = -1;
            this.stringIndex = -1;
            this.doubleIndex = -1;
            this.longIndex = -1;
        }

        public void setLong(int index) {
            this.resetIndices();
            this.longIndex = index;
        }

        public void setDouble(int index) {
            this.resetIndices();
            this.doubleIndex = index;
        }

        public void setString(int index) {
            this.resetIndices();
            this.stringIndex = index;
        }

        public void setDecimal(int index) {
            this.resetIndices();
            this.decimalIndex = index;
        }

        public void setTimestamp(int index) {
            this.resetIndices();
            this.timestampIndex = index;
        }

        public void setIntervalDayTime(int index) {
            this.resetIndices();
            this.intervalDayTimeIndex = index;
        }
    }
}

