/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.DecimalUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class DecimalColSubtractDecimalColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum1;
    private int colNum2;
    private int outputColumn;

    public DecimalColSubtractDecimalColumn(int colNum1, int colNum2, int outputColumn) {
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
        this.outputColumn = outputColumn;
        this.outputType = "decimal";
    }

    public DecimalColSubtractDecimalColumn() {
        this.outputType = "decimal";
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        DecimalColumnVector inputColVector1 = (DecimalColumnVector)batch.cols[this.colNum1];
        DecimalColumnVector inputColVector2 = (DecimalColumnVector)batch.cols[this.colNum2];
        DecimalColumnVector outputColVector = (DecimalColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        int n = batch.size;
        HiveDecimalWritable[] vector1 = inputColVector1.vector;
        HiveDecimalWritable[] vector2 = inputColVector2.vector;
        if (n == 0) {
            return;
        }
        boolean bl = outputColVector.isRepeating = inputColVector1.isRepeating && inputColVector2.isRepeating || inputColVector1.isRepeating && !inputColVector1.noNulls && inputColVector1.isNull[0] || inputColVector2.isRepeating && !inputColVector2.noNulls && inputColVector2.isNull[0];
        if (inputColVector1.noNulls && inputColVector2.noNulls) {
            NullUtil.initOutputNullsToFalse((ColumnVector)outputColVector, inputColVector1.isRepeating && inputColVector2.isRepeating, batch.selectedInUse, sel, n);
        }
        NullUtil.propagateNullsColCol((ColumnVector)inputColVector1, (ColumnVector)inputColVector2, (ColumnVector)outputColVector, sel, n, batch.selectedInUse);
        if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            DecimalUtil.subtractChecked(0, vector1[0], vector2[0], outputColVector);
        } else if (inputColVector1.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    DecimalUtil.subtractChecked(i, vector1[0], vector2[i], outputColVector);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    DecimalUtil.subtractChecked(i, vector1[0], vector2[i], outputColVector);
                }
            }
        } else if (inputColVector2.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    DecimalUtil.subtractChecked(i, vector1[i], vector2[0], outputColVector);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    DecimalUtil.subtractChecked(i, vector1[i], vector2[0], outputColVector);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                DecimalUtil.subtractChecked(i, vector1[i], vector2[i], outputColVector);
            }
        } else {
            for (int i = 0; i != n; ++i) {
                DecimalUtil.subtractChecked(i, vector1[i], vector2[i], outputColVector);
            }
        }
        NullUtil.setNullDataEntriesDecimal(outputColVector, batch.selectedInUse, sel, n);
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    public int getColNum1() {
        return this.colNum1;
    }

    public void setColNum1(int colNum1) {
        this.colNum1 = colNum1;
    }

    public int getColNum2() {
        return this.colNum2;
    }

    public void setColNum2(int colNum2) {
        this.colNum2 = colNum2;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("decimal"), VectorExpressionDescriptor.ArgumentType.getType("decimal")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

