/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.sql.Timestamp;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.util.DateTimeMath;
import org.apache.hadoop.hive.serde2.io.DateWritable;

public class TimestampColSubtractDateScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private Timestamp value;
    private int outputColumn;
    private DateTimeMath dtm = new DateTimeMath();

    public TimestampColSubtractDateScalar(int colNum, long value, int outputColumn) {
        this.colNum = colNum;
        this.value = new Timestamp(0L);
        this.value.setTime(DateWritable.daysToMillis((int)((int)value)));
        this.outputColumn = outputColumn;
    }

    public TimestampColSubtractDateScalar() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        TimestampColumnVector inputColVector1 = (TimestampColumnVector)batch.cols[this.colNum];
        IntervalDayTimeColumnVector outputColVector = (IntervalDayTimeColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector1.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.noNulls = inputColVector1.noNulls;
        outputColVector.isRepeating = inputColVector1.isRepeating;
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (inputColVector1.isRepeating) {
            this.dtm.subtract(inputColVector1.asScratchTimestamp(0), this.value, outputColVector.getScratchIntervalDayTime());
            outputColVector.setFromScratchIntervalDayTime(0);
            outputIsNull[0] = inputIsNull[0];
        } else if (inputColVector1.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    this.dtm.subtract(inputColVector1.asScratchTimestamp(i), this.value, outputColVector.getScratchIntervalDayTime());
                    outputColVector.setFromScratchIntervalDayTime(i);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.dtm.subtract(inputColVector1.asScratchTimestamp(i), this.value, outputColVector.getScratchIntervalDayTime());
                    outputColVector.setFromScratchIntervalDayTime(i);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                this.dtm.subtract(inputColVector1.asScratchTimestamp(i), this.value, outputColVector.getScratchIntervalDayTime());
                outputColVector.setFromScratchIntervalDayTime(i);
                outputIsNull[i] = inputIsNull[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                this.dtm.subtract(inputColVector1.asScratchTimestamp(i), this.value, outputColVector.getScratchIntervalDayTime());
                outputColVector.setFromScratchIntervalDayTime(i);
            }
            System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
        }
        NullUtil.setNullOutputEntriesColScalar((ColumnVector)outputColVector, batch.selectedInUse, sel, n);
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "interval_day_time";
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("timestamp"), VectorExpressionDescriptor.ArgumentType.getType("date")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

