/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseNumeric;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;

@Description(name="+", value="a _FUNC_ b - Returns a+b")
public class GenericUDFOPNumericPlus
extends GenericUDFBaseNumeric {
    public GenericUDFOPNumericPlus() {
        this.opDisplayName = "+";
    }

    @Override
    protected ByteWritable evaluate(ByteWritable left, ByteWritable right) {
        this.byteWritable.set((byte)(left.get() + right.get()));
        return this.byteWritable;
    }

    @Override
    protected ShortWritable evaluate(ShortWritable left, ShortWritable right) {
        this.shortWritable.set((short)(left.get() + right.get()));
        return this.shortWritable;
    }

    @Override
    protected IntWritable evaluate(IntWritable left, IntWritable right) {
        this.intWritable.set(left.get() + right.get());
        return this.intWritable;
    }

    @Override
    protected LongWritable evaluate(LongWritable left, LongWritable right) {
        this.longWritable.set(left.get() + right.get());
        return this.longWritable;
    }

    @Override
    protected FloatWritable evaluate(FloatWritable left, FloatWritable right) {
        this.floatWritable.set(left.get() + right.get());
        return this.floatWritable;
    }

    @Override
    protected DoubleWritable evaluate(DoubleWritable left, DoubleWritable right) {
        this.doubleWritable.set(left.get() + right.get());
        return this.doubleWritable;
    }

    @Override
    protected HiveDecimalWritable evaluate(HiveDecimal left, HiveDecimal right) {
        HiveDecimal dec = left.add(right);
        if (dec == null) {
            return null;
        }
        this.decimalWritable.set(dec);
        return this.decimalWritable;
    }

    @Override
    protected DecimalTypeInfo deriveResultDecimalTypeInfo(int prec1, int scale1, int prec2, int scale2) {
        int intPart = Math.max(prec1 - scale1, prec2 - scale2);
        int scale = Math.max(scale1, scale2);
        int prec = intPart + scale + 1;
        return this.adjustPrecScale(prec, scale);
    }
}

