/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.Util;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplitOutput;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.newplan.logical.rules.WholePlanRule;
import org.apache.pig.newplan.optimizer.Transformer;

public class AddForEach
extends WholePlanRule {
    public AddForEach(String n) {
        super(n, false);
    }

    @Override
    public Transformer getNewTransformer() {
        return new AddForEachTransformer();
    }

    public class AddForEachTransformer
    extends Transformer {
        LogicalRelationalOperator opForAdd;

        @Override
        public boolean check(OperatorPlan matched) throws FrontendException {
            Iterator<Operator> iter = matched.getOperators();
            while (iter.hasNext()) {
                LogicalRelationalOperator op = (LogicalRelationalOperator)iter.next();
                if (!(op instanceof LOFilter) && !(op instanceof LOSort) && !(op instanceof LOJoin) && !(op instanceof LOSplitOutput) || !this.shouldAdd(op)) continue;
                this.opForAdd = op;
                return true;
            }
            return false;
        }

        @Override
        public OperatorPlan reportChanges() {
            return AddForEach.this.currentPlan;
        }

        private void addSuccessors(Operator op) throws FrontendException {
            List<Operator> ll = op.getPlan().getSuccessors(op);
            if (ll != null) {
                for (Operator suc : ll) {
                    this.addSuccessors(suc);
                }
            }
        }

        @Override
        public void transform(OperatorPlan matched) throws FrontendException {
            this.addForeach(this.opForAdd);
            this.addSuccessors(this.opForAdd);
        }

        private boolean shouldAdd(LogicalRelationalOperator op) throws FrontendException {
            if (op instanceof LOForEach) {
                return false;
            }
            Set outputUids = (Set)op.getAnnotation("ColumnPrune:OutputUids");
            if (outputUids == null) {
                return false;
            }
            LogicalSchema schema = op.getSchema();
            if (schema == null) {
                return false;
            }
            List<Operator> ll = op.getPlan().getSuccessors(op);
            if (ll != null && ll.get(0) instanceof LOForEach) {
                return false;
            }
            HashSet<Integer> columnsToDrop = new HashSet<Integer>();
            for (int i = 0; i < schema.size(); ++i) {
                if (outputUids.contains(schema.getField((int)i).uid)) continue;
                columnsToDrop.add(i);
            }
            return !columnsToDrop.isEmpty();
        }

        private void addForeach(LogicalRelationalOperator op) throws FrontendException {
            Set outputUids = (Set)op.getAnnotation("ColumnPrune:OutputUids");
            LogicalSchema schema = op.getSchema();
            HashSet<Integer> columnsToDrop = new HashSet<Integer>();
            for (int i = 0; i < schema.size(); ++i) {
                if (outputUids.contains(schema.getField((int)i).uid)) continue;
                columnsToDrop.add(i);
            }
            if (!columnsToDrop.isEmpty()) {
                Util.addForEachAfter((LogicalPlan)op.getPlan(), op, 0, columnsToDrop);
            }
        }
    }
}

