/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.connection;

import org.pentaho.commons.connection.IPentahoMetaData;

public abstract class AbstractPentahoMetaData
implements IPentahoMetaData {
    @Override
    public int getColumnIndex(String value) {
        Object[][] columnHeaders = this.getColumnHeaders();
        if (columnHeaders == null || columnHeaders.length != 1) {
            return -1;
        }
        for (int idx = 0; idx < columnHeaders[0].length; ++idx) {
            if (!columnHeaders[0][idx].toString().equalsIgnoreCase(value)) continue;
            return idx;
        }
        return -1;
    }

    @Override
    public int getColumnIndex(String[] values) {
        Object[][] columnHeaders = this.getColumnHeaders();
        if (columnHeaders == null || columnHeaders.length != values.length) {
            return -1;
        }
        for (int columnIdx = 0; columnIdx < columnHeaders[0].length; ++columnIdx) {
            boolean match = true;
            for (int rowIdx = 0; rowIdx < columnHeaders.length && match; ++rowIdx) {
                match = columnHeaders[rowIdx][columnIdx].toString().equalsIgnoreCase(values[rowIdx]);
            }
            if (!match) continue;
            return columnIdx;
        }
        return -1;
    }

    @Override
    public int getRowIndex(String value) {
        Object[][] rowHeaders = this.getRowHeaders();
        if (rowHeaders == null || rowHeaders[0].length != 1) {
            return -1;
        }
        for (int rowIdx = 0; rowIdx < rowHeaders.length; ++rowIdx) {
            if (!rowHeaders[rowIdx][0].toString().equalsIgnoreCase(value)) continue;
            return rowIdx;
        }
        return -1;
    }

    @Override
    public int getRowIndex(String[] values) {
        Object[][] rowHeaders = this.getRowHeaders();
        if (rowHeaders == null || rowHeaders[0].length != values.length) {
            return -1;
        }
        for (int rowIdx = 0; rowIdx < rowHeaders.length; ++rowIdx) {
            boolean match = true;
            for (int columnIdx = 0; columnIdx < rowHeaders[rowIdx].length && match; ++columnIdx) {
                match = rowHeaders[rowIdx][columnIdx].toString().equalsIgnoreCase(values[columnIdx]);
            }
            if (!match) continue;
            return rowIdx;
        }
        return -1;
    }

    @Override
    public abstract Object[][] getColumnHeaders();

    @Override
    public abstract Object[][] getRowHeaders();

    @Override
    public int getColumnCount() {
        Object[][] columnHeaders = this.getColumnHeaders();
        if (columnHeaders == null || columnHeaders.length <= 0) {
            return 0;
        }
        return columnHeaders[0].length;
    }

    @Override
    public Object getAttribute(int rowNo, int columnNo, String attributeName) {
        throw new UnsupportedOperationException();
    }
}

