/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.openflashchart.factory;

import java.util.ArrayList;
import java.util.List;
import ofc4j.model.Tooltip;
import ofc4j.model.axis.Axis;
import ofc4j.model.elements.BarChart;
import ofc4j.model.elements.Element;
import ofc4j.model.elements.HorizontalBarChart;
import ofc4j.model.elements.SketchBarChart;
import ofc4j.model.elements.StackedBarChart;
import org.dom4j.Node;
import org.pentaho.platform.plugin.action.openflashchart.factory.AbstractChartFactory;

public class BarChartFactory
extends AbstractChartFactory {
    private static final String HEIGHT_3D_NODE_LOC = "height-3d";
    private static final String FUN_FACTOR_NODE_LOC = "fun-factor";
    private static final String IS3D_NODE_LOC = "is-3D";
    private static final String ISGLASS_NODE_LOC = "is-glass";
    private static final String ISSKETCH_NODE_LOC = "is-sketch";
    private static final String ISSTACKED_NODE_LOC = "is-stacked";
    private static final String OUTLINE_COLOR_PALETTE_NODE_LOC = "outline-color-palette";
    private static final BarChart.Style BARCHART_STYLE_DEFAULT = BarChart.Style.NORMAL;
    private static final int SKETCH_FUNFACTOR_DEFAULT = 5;
    private ArrayList<String> outlineColors = new ArrayList();
    private BarChart.Style barchartstyle;
    private boolean issketch;
    private Integer sketchBarFunFactor;
    private Integer threedheight;
    private StackedBarChart sbc;
    protected boolean isstacked;

    @Override
    public AbstractChartFactory.MinMax getRangeMinMax() {
        if (this.isstacked) {
            return new AbstractChartFactory.MinMax(0, this.getStackedMaxRange());
        }
        AbstractChartFactory.MinMax minmax = super.getRangeMinMax();
        if (minmax.min > 0) {
            minmax.min = 0;
        }
        return minmax;
    }

    @Override
    public Axis setupDomain() {
        Axis axis = super.setupDomain();
        axis.setOffset(Boolean.valueOf(true));
        return axis;
    }

    public int getStackedMaxRange() {
        int maxRange = 0;
        for (int i = 0; i < this.sbc.getStackCount(); ++i) {
            int currRange = 0;
            List vals = (List)this.sbc.getValues().get(i);
            for (Object val : vals) {
                currRange += ((StackedBarChart.StackValue)val).getValue().intValue();
            }
            if (currRange <= maxRange) continue;
            maxRange = currRange;
        }
        return maxRange;
    }

    @Override
    public void setupStyles() {
        super.setupStyles();
        this.barchartstyle = BARCHART_STYLE_DEFAULT;
        Node temp = this.chartNode.selectSingleNode(IS3D_NODE_LOC);
        if (BarChartFactory.getValue(temp) != null && "true".equals(BarChartFactory.getValue(temp))) {
            this.barchartstyle = BarChart.Style.THREED;
            temp = this.chartNode.selectSingleNode(HEIGHT_3D_NODE_LOC);
            if (BarChartFactory.getValue(temp) != null) {
                this.threedheight = Integer.parseInt(BarChartFactory.getValue(temp));
            }
        }
        if (BarChartFactory.getValue(temp = this.chartNode.selectSingleNode(ISGLASS_NODE_LOC)) != null && "true".equals(BarChartFactory.getValue(temp))) {
            this.barchartstyle = BarChart.Style.GLASS;
        }
        if (BarChartFactory.getValue(temp = this.chartNode.selectSingleNode(ISSKETCH_NODE_LOC)) != null && "true".equals(BarChartFactory.getValue(temp))) {
            this.issketch = true;
            temp = this.chartNode.selectSingleNode(FUN_FACTOR_NODE_LOC);
            this.sketchBarFunFactor = BarChartFactory.getValue(temp) != null ? Integer.valueOf(Integer.parseInt(BarChartFactory.getValue(temp))) : Integer.valueOf(5);
        } else {
            this.issketch = false;
        }
        temp = this.chartNode.selectSingleNode(ISSTACKED_NODE_LOC);
        if (BarChartFactory.getValue(temp) != null) {
            this.isstacked = "true".equals(BarChartFactory.getValue(temp));
        }
        if ((temp = this.chartNode.selectSingleNode(OUTLINE_COLOR_PALETTE_NODE_LOC)) != null) {
            Object[] colorNodes = temp.selectNodes("color").toArray();
            for (int j = 0; j < colorNodes.length; ++j) {
                this.outlineColors.add(BarChartFactory.getValue((Node)colorNodes[j]));
            }
        } else {
            for (int i = 0; i < COLORS_DEFAULT.length; ++i) {
                this.outlineColors.add(COLORS_DEFAULT[i]);
            }
        }
    }

    @Override
    public void createElements() {
        if ("CategoryDataset".equals(this.datasetType)) {
            int columnCount = this.getColumnCount();
            for (int col = 0; col < columnCount; ++col) {
                Element e = null;
                if ("vertical".equals(this.orientation)) {
                    e = this.getVerticalBarChartFromColumn(col);
                } else if ("horizontal".equals(this.orientation)) {
                    e = this.getHorizontalBarChartFromColumn(col);
                    this.chart.setTooltip(new Tooltip());
                }
                this.elements.add(e);
            }
        }
    }

    public Element getStackedBarChartFromColumn(int col) {
        if (this.sbc == null) {
            this.sbc = new StackedBarChart();
            if (null != this.baseURLTemplate) {
                this.sbc.setOn_click(this.baseURLTemplate);
            }
            if (this.alpha != null) {
                this.sbc.setAlpha(this.alpha);
            }
        }
        StackedBarChart.StackKey key = new StackedBarChart.StackKey();
        String text = this.getColumnHeader(col);
        key.setText(text);
        key.setColour(this.getColor(col));
        this.sbc.addKeys(new StackedBarChart.StackKey[]{key});
        for (int row = 0; row < this.getRowCount(); ++row) {
            StackedBarChart.Stack stack = null;
            stack = this.sbc.getStackCount() > row ? this.sbc.stack(row) : this.sbc.newStack();
            double d = ((Number)this.getValueAt(row, col)).doubleValue();
            stack.addStackValues(new StackedBarChart.StackValue[]{new StackedBarChart.StackValue((Number)d, this.getColor(col))});
        }
        return this.sbc;
    }

    public Element getVerticalBarChartFromColumn(int col) {
        SketchBarChart bc;
        if (this.isstacked) {
            return this.getStackedBarChartFromColumn(col);
        }
        if (this.issketch) {
            bc = new SketchBarChart();
            bc.setFunFactor(this.sketchBarFunFactor);
            bc.setOutlineColour(this.getOutlineColor(col));
        } else {
            bc = new BarChart(this.barchartstyle);
            if (this.barchartstyle == BarChart.Style.THREED && this.threedheight != null) {
                this.chart.getXAxis().set3D(this.threedheight);
            }
        }
        for (int row = 0; row < this.getRowCount(); ++row) {
            double d = ((Number)this.getValueAt(row, col)).doubleValue();
            bc.addBars(new BarChart.Bar[]{new BarChart.Bar((Number)d)});
        }
        bc.setColour(this.getColor(col));
        if (this.tooltipText != null) {
            bc.setTooltip(this.tooltipText);
        }
        bc.setText(this.getColumnHeader(col));
        if (null != this.baseURLTemplate) {
            bc.setOn_click(this.baseURLTemplate);
        }
        if (this.alpha != null) {
            bc.setAlpha(this.alpha);
        }
        return bc;
    }

    public Element getHorizontalBarChartFromColumn(int col) {
        HorizontalBarChart hbc = new HorizontalBarChart();
        for (int row = 0; row < this.getRowCount(); ++row) {
            double d = ((Number)this.getValueAt(row, col)).doubleValue();
            hbc.addBars(new HorizontalBarChart.Bar[]{new HorizontalBarChart.Bar((Number)d)});
        }
        hbc.setColour(this.getColor(col));
        if (this.tooltipText != null) {
            hbc.setTooltip(this.tooltipText);
        }
        hbc.setText(this.getColumnHeader(col));
        if (null != this.baseURLTemplate) {
            hbc.setOn_click(this.baseURLTemplate);
        }
        if (this.alpha != null) {
            hbc.setAlpha(this.alpha);
        }
        return hbc;
    }

    public String getOutlineColor(int i) {
        return this.outlineColors.get(i % this.outlineColors.size());
    }
}

