/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataParam;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.Optional;
import java.util.Properties;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.enunciate.Facet;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.web.http.api.resources.FileResource;
import org.pentaho.platform.web.http.api.resources.services.FileService;
import org.pentaho.platform.web.http.api.resources.services.RepositoryPublishService;
import org.pentaho.platform.web.http.api.resources.utils.FileUtils;

@Path(value="/repo/publish")
public class RepositoryPublishResource {
    private static final Log logger = LogFactory.getLog(FileResource.class);
    protected RepositoryPublishService repositoryPublishService = new RepositoryPublishService();

    @POST
    @Path(value="/publishfile")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully publish the artifact."), @ResponseCode(code=403, condition="Failure to publish the file due to permissions."), @ResponseCode(code=500, condition="Failure to publish the file due to a server error.")})
    @Facet(name="Unsupported")
    public Response writeFile(@FormDataParam(value="importPath") String pathId, @FormDataParam(value="fileUpload") InputStream fileContents, @FormDataParam(value="overwriteFile") Boolean overwriteFile, @FormDataParam(value="fileUpload") FormDataContentDisposition fileInfo) {
        try {
            this.repositoryPublishService.writeFile(pathId, fileContents, overwriteFile);
            return this.buildPlainTextOkResponse("SUCCESS");
        }
        catch (PentahoAccessControlException e) {
            return this.buildStatusResponse(Response.Status.UNAUTHORIZED, 5);
        }
        catch (PlatformImportException e) {
            logger.error((Object)e);
            return this.buildStatusResponse(Response.Status.PRECONDITION_FAILED, e.getErrorStatus());
        }
        catch (Exception e) {
            logger.error((Object)e);
            return this.buildServerErrorResponse(2);
        }
    }

    @POST
    @Path(value="/file")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully publish the file."), @ResponseCode(code=403, condition="Failure to publish the file due to permissions."), @ResponseCode(code=422, condition="Failure to publish the file due to failed validation."), @ResponseCode(code=500, condition="Failure to publish the file due to a server error.")})
    @Facet(name="Unsupported")
    public Response writeFileWithEncodedName(@FormDataParam(value="importPath") String pathId, @FormDataParam(value="fileUpload") InputStream fileContents, @FormDataParam(value="overwriteFile") Boolean overwriteFile, @FormDataParam(value="fileUpload") FormDataContentDisposition fileInfo) {
        Optional<Properties> fileProperties = Optional.of(new Properties());
        fileProperties.get().setProperty("overwriteFile", String.valueOf(overwriteFile));
        return this.writeFile(pathId, fileContents, fileInfo, fileProperties);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/fileWithOptions")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully publish the file."), @ResponseCode(code=403, condition="Failure to publish the file due to permissions."), @ResponseCode(code=422, condition="Failure to publish the file due to failed validation."), @ResponseCode(code=500, condition="Failure to publish the file due to a server error.")})
    @Facet(name="Unsupported")
    public Response writeFileWithEncodedNameWithOptions(@FormDataParam(value="properties") String properties, @FormDataParam(value="importPath") String pathId, @FormDataParam(value="fileUpload") InputStream fileContents, @FormDataParam(value="fileUpload") FormDataContentDisposition fileInfo) {
        try (ByteArrayInputStream bios = new ByteArrayInputStream(properties.getBytes());){
            Optional<Properties> fileProperties = Optional.of(new Properties());
            fileProperties.get().loadFromXML(bios);
            Response response = this.writeFile(pathId, fileContents, fileInfo, fileProperties);
            return response;
        }
        catch (IOException e) {
            logger.error((Object)e);
            return this.buildServerErrorResponse(2);
        }
    }

    private Response writeFile(String pathId, InputStream fileContents, FormDataContentDisposition fileInfo, Optional<Properties> fileProperties) {
        try {
            String decodedPath = URLDecoder.decode(pathId, "UTF-8");
            if (this.invalidPath(decodedPath)) {
                int UNPROCESSABLE_ENTITY = 422;
                return Response.status((int)422).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)("Cannot publish [" + decodedPath + "] because it contains reserved character(s)")).build();
            }
            this.repositoryPublishService.publishFile(decodedPath, fileContents, fileProperties);
        }
        catch (PentahoAccessControlException e) {
            return this.buildStatusResponse(Response.Status.UNAUTHORIZED, 5);
        }
        catch (PlatformImportException e) {
            logger.error((Object)e);
            return this.buildStatusResponse(Response.Status.PRECONDITION_FAILED, e.getErrorStatus());
        }
        catch (Exception e) {
            logger.error((Object)e);
            return this.buildServerErrorResponse(2);
        }
        return this.buildPlainTextOkResponse("SUCCESS");
    }

    boolean invalidPath(String path) {
        char[] chars = new FileService().doGetReservedChars().toString().toCharArray();
        return FileUtils.containsReservedCharacter(path, chars);
    }

    protected Response buildPlainTextOkResponse(String msg) {
        return Response.ok((Object)msg).type(MediaType.TEXT_PLAIN_TYPE).build();
    }

    protected Response buildStatusResponse(Response.Status status, int entity) {
        return Response.status((Response.Status)status).entity((Object)Integer.toString(entity)).build();
    }

    protected Response buildServerErrorResponse(int entity) {
        return Response.serverError().entity((Object)Integer.toString(entity)).build();
    }
}

