/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources.utils;

import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class EscapeUtils {
    public static String escapeJson(String text) throws IOException {
        if (text == null) {
            return null;
        }
        ObjectMapper escapingMapper = new ObjectMapper();
        escapingMapper.getJsonFactory().setCharacterEscapes((CharacterEscapes)new HTMLCharacterEscapes());
        JsonNode parsedJson = new ObjectMapper().readTree(text);
        String result = escapingMapper.writeValueAsString((Object)parsedJson);
        return result;
    }

    public static String escapeRaw(String text) {
        if (text == null) {
            return null;
        }
        ObjectMapper escapingMapper = new ObjectMapper();
        escapingMapper.getJsonFactory().setCharacterEscapes((CharacterEscapes)new HTMLCharacterEscapes());
        String result = null;
        try {
            result = escapingMapper.writeValueAsString((Object)text);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.substring(1, result.length() - 1);
    }

    public static String escapeJsonOrRaw(String text) {
        if (text == null) {
            return null;
        }
        try {
            return EscapeUtils.escapeJson(text);
        }
        catch (Exception e) {
            return EscapeUtils.escapeRaw(text);
        }
    }

    static class HTMLCharacterEscapes
    extends CharacterEscapes {
        private final int[] asciiEscapes;

        public HTMLCharacterEscapes() {
            int[] esc = CharacterEscapes.standardAsciiEscapesForJSON();
            esc[60] = -1;
            esc[62] = -1;
            esc[38] = -1;
            esc[39] = -1;
            esc[34] = -1;
            this.asciiEscapes = esc;
        }

        public int[] getEscapeCodesForAscii() {
            return this.asciiEscapes;
        }

        public SerializableString getEscapeSequence(int ch) {
            return null;
        }
    }
}

