/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.IPluginManagerListener;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;

public class PluginDispatchServlet
implements Servlet {
    private static final Log logger = LogFactory.getLog(PluginDispatchServlet.class);
    private ServletConfig servletConfig;
    private boolean initialized = false;
    private IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class);
    private Map<String, Servlet> pluginServletMap = new HashMap<String, Servlet>();

    public void destroy() {
        for (Map.Entry<String, Servlet> pluginServlet : this.pluginServletMap.entrySet()) {
            pluginServlet.getValue().destroy();
        }
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        if (!this.initialized) {
            this.doInit();
        }
        if (!(req instanceof HttpServletRequest)) {
            throw new IllegalArgumentException(PluginDispatchServlet.class.getSimpleName() + " cannot handle non HTTP requests");
        }
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        Servlet pluginServlet = this.getTargetServlet(request, response);
        if (pluginServlet == null) {
            response.sendError(404);
            return;
        }
        pluginServlet.service(req, res);
    }

    protected Servlet getTargetServlet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String dispatchKey = this.getDispatchKey(request);
        if (StringUtils.isEmpty((String)dispatchKey)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"dispatcher servlet is invoked but there is nothing telling it where to dispatch to");
            }
            return null;
        }
        Servlet targetServlet = null;
        String checkPath = dispatchKey;
        do {
            logger.debug((Object)("checking for servlet registered to service request for \"" + checkPath + "\""));
            targetServlet = this.pluginServletMap.get(checkPath);
            if (targetServlet == null) continue;
            logger.debug((Object)("servlet " + targetServlet.getClass().getName() + " will service request for \"" + dispatchKey + "\""));
            return targetServlet;
        } while ((checkPath = checkPath.contains("/") ? checkPath.substring(0, checkPath.lastIndexOf("/")) : null) != null);
        if (targetServlet == null) {
            logger.debug((Object)("no servlet registered to service request for \"" + dispatchKey + "\""));
        }
        return targetServlet;
    }

    public String getDispatchKey(HttpServletRequest request) {
        String requestPathInfo = request.getPathInfo();
        if (requestPathInfo.startsWith("/")) {
            requestPathInfo = requestPathInfo.substring(1);
        }
        if (requestPathInfo.endsWith("/")) {
            requestPathInfo = requestPathInfo.substring(requestPathInfo.length());
        }
        return requestPathInfo;
    }

    public void init(ServletConfig config) throws ServletException {
        this.servletConfig = config;
        this.pluginManager.addPluginManagerListener(new IPluginManagerListener(){

            public void onReload() {
                try {
                    PluginDispatchServlet.this.initialized = false;
                    PluginDispatchServlet.this.doInit();
                }
                catch (ServletException e) {
                    logger.error((Object)e);
                }
            }
        });
        this.doInit();
    }

    private synchronized void doInit() throws ServletException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PluginDispatchServlet.init");
        }
        if (this.initialized) {
            return;
        }
        this.pluginServletMap.clear();
        Map<String, ListableBeanFactory> pluginBeanFactoryMap = this.getPluginBeanFactories();
        for (Map.Entry<String, ListableBeanFactory> pluginBeanFactoryEntry : pluginBeanFactoryMap.entrySet()) {
            Map beans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)pluginBeanFactoryEntry.getValue(), Servlet.class, (boolean)true, (boolean)true);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("found " + beans.size() + " servlets in " + pluginBeanFactoryEntry.getKey()));
            }
            for (Map.Entry beanEntry : beans.entrySet()) {
                Servlet pluginServlet = (Servlet)beanEntry.getValue();
                String servletId = (String)beanEntry.getKey();
                String pluginId = pluginBeanFactoryEntry.getKey();
                String context = pluginId + "/" + servletId;
                this.pluginServletMap.put(context, pluginServlet);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("calling init on servlet " + pluginServlet.getClass().getName() + " serving context " + context));
                }
                try {
                    pluginServlet.init(this.servletConfig);
                }
                catch (Throwable t) {
                    logger.error((Object)("Could not load servlet '" + context + "'"), t);
                }
            }
        }
        this.initialized = true;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public String getServletInfo() {
        return "A servlet to dispatch requests to Servlets defined in BIServer plugins";
    }

    protected Map<String, ListableBeanFactory> getPluginBeanFactories() {
        List pluginIds = this.pluginManager.getRegisteredPlugins();
        HashMap<String, ListableBeanFactory> pluginBeanFactoryMap = new HashMap<String, ListableBeanFactory>();
        for (String pluginId : pluginIds) {
            ListableBeanFactory beanFactory = this.pluginManager.getBeanFactory(pluginId);
            if (beanFactory == null) continue;
            pluginBeanFactoryMap.put(pluginId, beanFactory);
        }
        return pluginBeanFactoryMap;
    }
}

