/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.avro;

import com.google.common.annotations.VisibleForTesting;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.commons.vfs2.FileExtensionSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.hadoop.shim.api.format.AvroSpec;
import org.pentaho.hadoop.shim.api.format.IAvroInputField;
import org.pentaho.hadoop.shim.api.format.IPentahoAvroInputFormat;
import org.pentaho.hadoop.shim.api.format.IPentahoInputFormat;
import org.pentaho.hadoop.shim.common.format.avro.AvroInputField;
import org.pentaho.hadoop.shim.common.format.avro.PentahoAvroRecordReader;

public class PentahoAvroInputFormat
implements IPentahoAvroInputFormat {
    private String fileName;
    private String schemaFileName;
    private List<? extends IAvroInputField> inputFields;
    private String inputStreamFieldName;
    private boolean useFieldAsInputStream;
    private InputStream inputStream;

    public List<IPentahoInputFormat.IPentahoInputSplit> getSplits() throws Exception {
        return null;
    }

    public IPentahoInputFormat.IPentahoRecordReader createRecordReader(IPentahoInputFormat.IPentahoInputSplit split) throws Exception {
        DataFileStream<GenericRecord> dfs = this.createDataFileStream();
        if (dfs == null) {
            throw new Exception("Unable to read data from file " + this.fileName);
        }
        Schema avroSchema = this.readAvroSchema();
        return new PentahoAvroRecordReader(dfs, avroSchema, this.getFields());
    }

    @VisibleForTesting
    public Schema readAvroSchema() throws Exception {
        if (this.schemaFileName != null && this.schemaFileName.length() > 0) {
            return new Schema.Parser().parse(KettleVFS.getInputStream((String)this.schemaFileName));
        }
        if (this.fileName != null && this.fileName.length() > 0 || this.useFieldAsInputStream && this.inputStream != null) {
            DataFileStream<GenericRecord> dataFileStream = this.createDataFileStream();
            Schema schema = dataFileStream.getSchema();
            dataFileStream.close();
            return schema;
        }
        throw new Exception("The file you provided does not contain a schema.  Please choose a schema file, or another file that contains a schema.");
    }

    public List<? extends IAvroInputField> getFields() throws Exception {
        if (this.inputFields != null) {
            return this.inputFields;
        }
        return this.getDefaultFields();
    }

    public void setInputFields(List<? extends IAvroInputField> fields) throws Exception {
        this.inputFields = fields;
    }

    public void setInputFile(String fileName) throws Exception {
        this.fileName = fileName;
    }

    public void setInputSchemaFile(String schemaFileName) throws Exception {
        this.schemaFileName = schemaFileName;
    }

    public String getInputStreamFieldName() {
        return this.inputStreamFieldName;
    }

    public void setInputStreamFieldName(String inputStreamFieldName) {
        this.inputStreamFieldName = inputStreamFieldName;
        this.useFieldAsInputStream = inputStreamFieldName != null && !inputStreamFieldName.isEmpty();
    }

    public boolean isUseFieldAsInputStream() {
        return this.useFieldAsInputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setSplitSize(long blockSize) throws Exception {
    }

    private DataFileStream<GenericRecord> createDataFileStream() throws Exception {
        GenericDatumReader datumReader;
        if (this.useFieldAsInputStream) {
            GenericDatumReader datumReader2 = new GenericDatumReader();
            this.inputStream.reset();
            return new DataFileStream(this.inputStream, (DatumReader)datumReader2);
        }
        if (this.schemaFileName != null && this.schemaFileName.length() > 0) {
            Schema schema = new Schema.Parser().parse(KettleVFS.getInputStream((String)this.schemaFileName));
            datumReader = new GenericDatumReader(schema);
        } else {
            datumReader = new GenericDatumReader();
        }
        FileObject fileObject = KettleVFS.getFileObject((String)this.fileName);
        if (fileObject.isFile()) {
            this.inputStream = fileObject.getContent().getInputStream();
            return new DataFileStream(this.inputStream, (DatumReader)datumReader);
        }
        Object[] avroFiles = fileObject.findFiles((FileSelector)new FileExtensionSelector(new String[]{"avro"}));
        if (!Utils.isEmpty((Object[])avroFiles)) {
            this.inputStream = avroFiles[0].getContent().getInputStream();
            return new DataFileStream(this.inputStream, (DatumReader)datumReader);
        }
        return null;
    }

    public List<? extends IAvroInputField> getDefaultFields() throws Exception {
        ArrayList<AvroInputField> fields = new ArrayList<AvroInputField>();
        Schema avroSchema = this.readAvroSchema();
        for (Schema.Field f : avroSchema.getFields()) {
            AvroSpec.DataType actualAvroType = this.findActualDataType(f);
            AvroSpec.DataType supportedAvroType = null;
            if (actualAvroType != null && this.isSupported(actualAvroType)) {
                supportedAvroType = actualAvroType;
            }
            if (supportedAvroType == null) continue;
            int pentahoType = 0;
            switch (supportedAvroType) {
                case DATE: {
                    pentahoType = 3;
                    break;
                }
                case DOUBLE: {
                    pentahoType = 1;
                    break;
                }
                case FLOAT: {
                    pentahoType = 1;
                    break;
                }
                case LONG: {
                    pentahoType = 5;
                    break;
                }
                case BOOLEAN: {
                    pentahoType = 4;
                    break;
                }
                case INTEGER: {
                    pentahoType = 5;
                    break;
                }
                case STRING: {
                    pentahoType = 2;
                    break;
                }
                case BYTES: {
                    pentahoType = 8;
                    break;
                }
                case DECIMAL: {
                    pentahoType = 6;
                    break;
                }
                case TIMESTAMP_MILLIS: {
                    pentahoType = 9;
                }
            }
            FieldName fieldName = PentahoAvroInputFormat.parseFieldName(f.name());
            if (fieldName != null) {
                pentahoType = fieldName.type;
            }
            AvroInputField avroInputField = new AvroInputField();
            avroInputField.setFormatFieldName(f.name());
            avroInputField.setPentahoFieldName(avroInputField.getDisplayableAvroFieldName());
            avroInputField.setFormatFieldName(f.name());
            avroInputField.setPentahoType(pentahoType);
            avroInputField.setAvroType(actualAvroType);
            fields.add(avroInputField);
        }
        return fields;
    }

    private AvroSpec.DataType findActualDataType(Schema.Field field) {
        AvroSpec.DataType avroDataType = null;
        LogicalType logicalType = null;
        Schema.Type primitiveAvroType = null;
        if (field.schema().getType().equals((Object)Schema.Type.UNION)) {
            for (Schema typeSchema : field.schema().getTypes()) {
                if (typeSchema.getType().equals((Object)Schema.Type.NULL)) continue;
                logicalType = typeSchema.getLogicalType();
                primitiveAvroType = typeSchema.getType();
                break;
            }
        } else {
            logicalType = field.schema().getLogicalType();
            primitiveAvroType = field.schema().getType();
        }
        if (logicalType != null) {
            for (AvroSpec.DataType tmpType : AvroSpec.DataType.values()) {
                if (tmpType.isPrimitiveType() || !tmpType.getType().equals(logicalType.getName())) continue;
                avroDataType = tmpType;
                break;
            }
        } else {
            switch (primitiveAvroType) {
                case INT: {
                    avroDataType = AvroSpec.DataType.INTEGER;
                    break;
                }
                case LONG: {
                    avroDataType = AvroSpec.DataType.LONG;
                    break;
                }
                case BYTES: {
                    avroDataType = AvroSpec.DataType.BYTES;
                    break;
                }
                case FLOAT: {
                    avroDataType = AvroSpec.DataType.FLOAT;
                    break;
                }
                case DOUBLE: {
                    avroDataType = AvroSpec.DataType.DOUBLE;
                    break;
                }
                case STRING: {
                    avroDataType = AvroSpec.DataType.STRING;
                    break;
                }
                case BOOLEAN: {
                    avroDataType = AvroSpec.DataType.BOOLEAN;
                }
            }
        }
        return avroDataType;
    }

    private boolean isSupported(AvroSpec.DataType actualAvroType) {
        return actualAvroType == AvroSpec.DataType.DATE || actualAvroType == AvroSpec.DataType.DECIMAL || actualAvroType == AvroSpec.DataType.TIMESTAMP_MILLIS || actualAvroType.isPrimitiveType() && actualAvroType != AvroSpec.DataType.NULL;
    }

    public static FieldName parseFieldName(String fieldName) {
        if (fieldName == null || !fieldName.contains("_delimiter_")) {
            return null;
        }
        String[] splits = fieldName.split("_delimiter_");
        if (splits.length == 0 || splits.length > 3) {
            return null;
        }
        return new FieldName(splits[0], Integer.valueOf(splits[1]), Boolean.parseBoolean(splits[2]));
    }

    public static class FieldName {
        public final String name;
        public final int type;
        public final boolean allowNull;
        public static final String FIELDNAME_DELIMITER = "_delimiter_";

        public FieldName(String name, int type, boolean allowNull) {
            this.name = name;
            this.type = type;
            this.allowNull = allowNull;
        }

        public String getLegacyFieldName() {
            return this.name + FIELDNAME_DELIMITER + this.type + FIELDNAME_DELIMITER + this.allowNull;
        }
    }
}

