/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.orc;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.orc.Reader;
import org.pentaho.hadoop.shim.api.format.IOrcInputField;
import org.pentaho.hadoop.shim.api.format.IOrcMetaData;

public class OrcMetaDataReader
implements IOrcMetaData.Reader {
    private static final Logger logger = Logger.getLogger(OrcMetaDataReader.class);
    Reader reader;

    public OrcMetaDataReader(Reader reader) {
        this.reader = reader;
    }

    public void read(List<? extends IOrcInputField> inputFields) {
        inputFields.forEach(field -> {
            try {
                this.readMetaData((IOrcInputField)field);
            }
            catch (Exception e) {
                logger.error((Object)("Field " + field.getFormatFieldName() + ": cannot read Orc Metadata"));
            }
        });
    }

    private void readMetaData(IOrcInputField inputField) {
        inputField.setPentahoType(this.readInt(inputField, IOrcMetaData.propertyType.TYPE));
    }

    private String readValue(IOrcInputField inputField, IOrcMetaData.propertyType metaField) {
        String propertyName = IOrcMetaData.determinePropertyName((String)inputField.getFormatFieldName(), (String)metaField.toString());
        if (this.reader.hasMetadataValue(propertyName)) {
            ByteBuffer b = this.reader.getMetadataValue(propertyName);
            return b == null ? null : this.byteBufferToString(b, Charset.forName("UTF-8"));
        }
        return String.valueOf(inputField.getPentahoType());
    }

    private int readInt(IOrcInputField inputField, IOrcMetaData.propertyType metaField) {
        String s = this.readValue(inputField, metaField);
        if (s != null) {
            return Integer.valueOf(this.readValue(inputField, metaField));
        }
        return 0;
    }

    private boolean readBoolean(IOrcInputField field, IOrcMetaData.propertyType metaField) {
        String s = this.readValue(field, metaField);
        if (s != null) {
            return Boolean.valueOf(this.readValue(field, metaField));
        }
        return false;
    }

    private String byteBufferToString(ByteBuffer buffer, Charset charset) {
        byte[] bytes;
        if (buffer.hasArray()) {
            bytes = buffer.array();
        } else {
            bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
        }
        return new String(bytes, charset);
    }
}

