/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.extensionpoints;

import java.io.IOException;
import org.apache.commons.lang.ObjectUtils;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.version.BuildVersion;
import org.pentaho.metaverse.api.ILineageWriter;
import org.pentaho.metaverse.api.IMetaverseBuilder;
import org.pentaho.metaverse.api.model.IExecutionEngine;
import org.pentaho.metaverse.api.model.IExecutionProfile;
import org.pentaho.metaverse.api.model.LineageHolder;
import org.pentaho.metaverse.impl.model.ExecutionEngine;

public abstract class BaseRuntimeExtensionPoint
implements ExtensionPointInterface {
    public static final String EXECUTION_ENGINE_NAME = "Pentaho Data Integration";
    public static final String EXECUTION_ENGINE_DESCRIPTION = "Pentaho Data Integration (PDI) prepares and blends data to create a complete picture of your business that drives actionable insights.";
    protected ILineageWriter lineageWriter;
    protected boolean runtimeEnabled;

    public void writeLineageInfo(LineageHolder holder) throws IOException {
        String strategy;
        if (this.lineageWriter != null && !"none".equals(strategy = this.lineageWriter.getOutputStrategy())) {
            if ("latest".equals(strategy)) {
                this.lineageWriter.cleanOutput(holder);
            }
            String id = holder.getExecutionProfile().getName();
            this.lineageWriter.outputExecutionProfile(holder);
            this.lineageWriter.outputLineageGraph(holder);
        }
    }

    public static IExecutionEngine getExecutionEngineInfo() {
        ExecutionEngine executionEngine = new ExecutionEngine();
        executionEngine.setName(EXECUTION_ENGINE_NAME);
        executionEngine.setVersion(BuildVersion.getInstance().getVersion());
        executionEngine.setDescription(EXECUTION_ENGINE_DESCRIPTION);
        return executionEngine;
    }

    public void addRuntimeLineageInfo(LineageHolder holder) {
        IMetaverseBuilder builder = holder.getMetaverseBuilder();
        IExecutionProfile profile = holder.getExecutionProfile();
    }

    public ILineageWriter getLineageWriter() {
        return this.lineageWriter;
    }

    public void setLineageWriter(ILineageWriter lineageWriter) {
        this.lineageWriter = lineageWriter;
    }

    public void setRuntimeEnabled(String runtimeEnabled) {
        this.runtimeEnabled = runtimeEnabled != null && runtimeEnabled.equalsIgnoreCase("on");
    }

    public void setRuntimeEnabled(boolean runtimeEnabled) {
        this.runtimeEnabled = runtimeEnabled;
    }

    public boolean isRuntimeEnabled() {
        return this.runtimeEnabled;
    }

    public boolean allowedAsync() {
        KettleClientEnvironment.ClientType client = KettleClientEnvironment.getInstance().getClient();
        return !ObjectUtils.equals((Object)client, (Object)KettleClientEnvironment.ClientType.KITCHEN) && !ObjectUtils.equals((Object)client, (Object)KettleClientEnvironment.ClientType.PAN);
    }
}

