/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.extensionpoints.job;

import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobListener;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.metaverse.analyzer.kettle.extensionpoints.BaseRuntimeExtensionPoint;
import org.pentaho.metaverse.analyzer.kettle.extensionpoints.job.JobLineageHolderMap;
import org.pentaho.metaverse.api.AnalysisContext;
import org.pentaho.metaverse.api.IAnalysisContext;
import org.pentaho.metaverse.api.IDocument;
import org.pentaho.metaverse.api.IDocumentAnalyzer;
import org.pentaho.metaverse.api.IMetaverseBuilder;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.INamespace;
import org.pentaho.metaverse.api.MetaverseException;
import org.pentaho.metaverse.api.Namespace;
import org.pentaho.metaverse.api.analyzer.kettle.KettleAnalyzerUtil;
import org.pentaho.metaverse.api.model.IExecutionData;
import org.pentaho.metaverse.api.model.IExecutionProfile;
import org.pentaho.metaverse.api.model.LineageHolder;
import org.pentaho.metaverse.impl.MetaverseCompletionService;
import org.pentaho.metaverse.impl.model.ExecutionData;
import org.pentaho.metaverse.impl.model.ExecutionProfile;
import org.pentaho.metaverse.impl.model.ParamInfo;
import org.pentaho.metaverse.messages.Messages;
import org.pentaho.metaverse.util.MetaverseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtensionPoint(description="Job Runtime metadata extractor", extensionPointId="JobStart", id="jobRuntimeMetaverse")
public class JobRuntimeExtensionPoint
extends BaseRuntimeExtensionPoint
implements JobListener {
    private IDocumentAnalyzer documentAnalyzer;
    private static final Logger log = LoggerFactory.getLogger(JobRuntimeExtensionPoint.class);

    public void callExtensionPoint(LogChannelInterface logChannelInterface, Object o) throws KettleException {
        if (o instanceof Job) {
            Job job = (Job)o;
            if (!this.isRuntimeEnabled()) {
                return;
            }
            ExecutionProfile executionProfile = new ExecutionProfile();
            this.populateExecutionProfile(executionProfile, job);
            IMetaverseBuilder builder = JobLineageHolderMap.getInstance().getMetaverseBuilder(job);
            job.addJobListener((JobListener)this);
            if (this.documentAnalyzer != null) {
                String normalizedPath;
                String id;
                this.documentAnalyzer.setMetaverseBuilder(builder);
                String clientName = executionProfile.getExecutionEngine().getName();
                Namespace namespace = new Namespace(clientName);
                IMetaverseNode designNode = builder.getMetaverseObjectFactory().createNodeObject(clientName, clientName, "Locator");
                builder.addNode(designNode);
                JobMeta jobMeta = job.getJobMeta();
                jobMeta.copyParametersFrom((NamedParams)job);
                jobMeta.activateParameters();
                job.copyVariablesFrom((VariableSpace)jobMeta);
                if (job.getRep() != null) {
                    jobMeta.setRepository(job.getRep());
                }
                if (!(id = JobRuntimeExtensionPoint.getFilename(jobMeta)).endsWith(jobMeta.getDefaultExtension())) {
                    id = id + "." + jobMeta.getDefaultExtension();
                }
                IDocument metaverseDocument = builder.getMetaverseObjectFactory().createDocumentObject();
                metaverseDocument.setNamespace((INamespace)namespace);
                metaverseDocument.setContent((Object)jobMeta);
                metaverseDocument.setStringID(id);
                metaverseDocument.setName(jobMeta.getName());
                metaverseDocument.setExtension("kjb");
                metaverseDocument.setMimeType(URLConnection.getFileNameMap().getContentTypeFor("job.kjb"));
                metaverseDocument.setContext((IAnalysisContext)new AnalysisContext("runtime"));
                try {
                    normalizedPath = KettleAnalyzerUtil.normalizeFilePath((String)id);
                }
                catch (MetaverseException e) {
                    normalizedPath = id;
                }
                metaverseDocument.setProperty("name", (Object)job.getName());
                metaverseDocument.setProperty("path", (Object)normalizedPath);
                metaverseDocument.setProperty("namespace", (Object)namespace.getNamespaceId());
                Runnable analyzerRunner = MetaverseUtil.getAnalyzerRunner(this.documentAnalyzer, metaverseDocument);
                MetaverseCompletionService.getInstance().submit(analyzerRunner, id);
            }
            LineageHolder holder = JobLineageHolderMap.getInstance().getLineageHolder(job);
            holder.setExecutionProfile((IExecutionProfile)executionProfile);
            holder.setMetaverseBuilder(builder);
        }
    }

    public void jobFinished(Job job) throws KettleException {
        if (job == null) {
            return;
        }
        if (this.allowedAsync()) {
            this.createLineGraphAsync(job);
        } else {
            this.createLineGraph(job);
        }
    }

    protected void createLineGraphAsync(final Job job) {
        Thread lineageWorker = new Thread(new Runnable(){

            @Override
            public void run() {
                JobRuntimeExtensionPoint.this.createLineGraph(job);
            }
        });
        lineageWorker.start();
    }

    protected void createLineGraph(Job job) {
        try {
            IExecutionProfile executionProfile;
            LineageHolder holder = JobLineageHolderMap.getInstance().getLineageHolder(job);
            Future lineageTask = holder.getLineageTask();
            if (lineageTask != null) {
                try {
                    lineageTask.get();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            if ((executionProfile = JobLineageHolderMap.getInstance().getLineageHolder(job).getExecutionProfile()) == null) {
                executionProfile = new ExecutionProfile();
                this.populateExecutionProfile(executionProfile, job);
            }
            ExecutionData executionData = (ExecutionData)executionProfile.getExecutionData();
            Result result = job.getResult();
            if (result != null) {
                executionData.setFailureCount(result.getNrErrors());
            }
            try {
                if (this.lineageWriter != null && !"none".equals(this.lineageWriter.getOutputStrategy())) {
                    if ("latest".equals(this.lineageWriter.getOutputStrategy())) {
                        this.lineageWriter.cleanOutput(holder);
                    }
                    this.lineageWriter.outputExecutionProfile(holder);
                }
            }
            catch (IOException e) {
                log.warn(Messages.getString("ERROR.CouldNotWriteExecutionProfile", job.getName(), e.getMessage()));
                log.debug(Messages.getString("ERROR.ErrorDuringAnalysisStackTrace"), (Throwable)e);
            }
            try {
                Job parentJob = job.getParentJob();
                Trans parentTrans = job.getParentTrans();
                if (parentJob == null && parentTrans == null) {
                    this.addRuntimeLineageInfo(holder);
                    if (this.lineageWriter != null && !"none".equals(this.lineageWriter.getOutputStrategy())) {
                        this.lineageWriter.outputLineageGraph(holder);
                    }
                }
            }
            catch (IOException e) {
                log.warn(Messages.getString("ERROR.CouldNotWriteLineageGraph", job.getName(), Const.NVL((String)e.getLocalizedMessage(), (String)"Unspecified")));
                log.debug(Messages.getString("ERROR.ErrorDuringAnalysisStackTrace"), (Throwable)e);
            }
        }
        catch (Throwable t) {
            log.warn(Messages.getString("ERROR.ErrorDuringAnalysis", job.getName(), Const.NVL((String)t.getLocalizedMessage(), (String)"Unspecified")));
            log.debug(Messages.getString("ERROR.ErrorDuringAnalysisStackTrace"), t);
        }
    }

    protected void populateExecutionProfile(IExecutionProfile executionProfile, Job job) {
        JobMeta jobMeta = job.getJobMeta();
        String filename = JobRuntimeExtensionPoint.getFilename(job);
        String filePath = null;
        if (job.getRep() == null) {
            try {
                filePath = KettleAnalyzerUtil.normalizeFilePath((String)filename);
            }
            catch (Exception e) {
                log.warn("Couldn't normalize file path: " + filename, (Throwable)e);
                filePath = filename;
            }
        } else {
            filePath = filename;
        }
        executionProfile.setPath(filePath);
        executionProfile.setName(jobMeta.getName());
        executionProfile.setType("Job");
        executionProfile.setDescription(jobMeta.getDescription());
        executionProfile.setExecutionEngine(JobRuntimeExtensionPoint.getExecutionEngineInfo());
        IExecutionData executionData = executionProfile.getExecutionData();
        executionData.setStartTime((Date)new Timestamp(new Date().getTime()));
        KettleClientEnvironment.ClientType clientType = KettleClientEnvironment.getInstance().getClient();
        executionData.setClientExecutor(clientType == null ? "DI Server" : clientType.name());
        executionData.setExecutorUser(job.getExecutingUser());
        executionData.setExecutorServer(job.getExecutingServer());
        List vars = jobMeta.getUsedVariables();
        Map variableMap = executionData.getVariables();
        for (String var : vars) {
            String[] value = job.getVariable(var);
            if (value == null) continue;
            variableMap.put(var, value);
        }
        String[] params = job.listParameters();
        List paramList = executionData.getParameters();
        if (params != null) {
            for (String param : params) {
                try {
                    ParamInfo paramInfo = new ParamInfo(param, job.getParameterDescription(param), job.getParameterDefault(param));
                    paramList.add(paramInfo);
                }
                catch (UnknownParamException e) {
                    e.printStackTrace();
                }
            }
        }
        String[] args = job.getArguments();
        List argList = executionData.getArguments();
        if (args != null) {
            argList.addAll(Arrays.asList(args));
        }
    }

    public void jobStarted(Job job) throws KettleException {
    }

    public static String getFilename(Job job) {
        String filename = job.getFilename();
        if (filename == null && job.getJobMeta() != null) {
            filename = JobRuntimeExtensionPoint.getFilename(job.getJobMeta());
        }
        if (filename == null) {
            filename = "";
        }
        return filename;
    }

    public void setDocumentAnalyzer(IDocumentAnalyzer analyzer) {
        this.documentAnalyzer = analyzer;
    }

    public IDocumentAnalyzer getDocumentAnalyzer() {
        return this.documentAnalyzer;
    }

    public static String getFilename(JobMeta jobMeta) {
        String filename = jobMeta.getFilename();
        if (filename == null) {
            if (jobMeta.getRepositoryDirectory() != null) {
                String dir = jobMeta.getRepositoryDirectory().getPath();
                String name = jobMeta.getName();
                File f = new File(dir, name);
                filename = f.getPath();
            } else {
                filename = "";
            }
        }
        return filename;
    }
}

