/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.metaverse.api.IGraphWriter;
import org.pentaho.metaverse.api.ILineageWriter;
import org.pentaho.metaverse.api.model.LineageHolder;
import org.pentaho.metaverse.impl.model.ExecutionProfileUtil;

public class LineageWriter
implements ILineageWriter {
    private OutputStream profileOutputStream;
    private OutputStream graphOutputStream;
    private IGraphWriter graphWriter;
    private String outputStrategy = "none";

    public void outputExecutionProfile(LineageHolder holder) throws IOException {
        ExecutionProfileUtil.outputExecutionProfile(this.getProfileOutputStream(), holder.getExecutionProfile());
    }

    public void outputLineageGraph(LineageHolder holder) throws IOException {
        if (this.graphWriter == null) {
            throw new IOException("No graph output stream associated with this LineageWriter");
        }
        this.graphWriter.outputGraph(holder.getMetaverseBuilder().getGraph(), this.getGraphOutputStream());
    }

    public OutputStream getProfileOutputStream() {
        if (this.profileOutputStream == null) {
            this.profileOutputStream = System.out;
        }
        return this.profileOutputStream;
    }

    public OutputStream getGraphOutputStream() {
        if (this.graphOutputStream == null) {
            return System.out;
        }
        return this.graphOutputStream;
    }

    public void setProfileOutputStream(OutputStream profileOutputStream) {
        this.profileOutputStream = profileOutputStream;
    }

    public void setGraphOutputStream(OutputStream graphOutputStream) {
        this.graphOutputStream = graphOutputStream;
    }

    public IGraphWriter getGraphWriter() {
        return this.graphWriter;
    }

    public void setGraphWriter(IGraphWriter graphWriter) {
        this.graphWriter = graphWriter;
    }

    public String getOutputStrategy() {
        return this.outputStrategy;
    }

    public void setOutputStrategy(String strategy) {
        this.outputStrategy = strategy;
    }

    public void cleanOutput(LineageHolder holder) {
    }
}

