/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.shims;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.DefaultFileAccess;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.ProxyFileSystem;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.TrashPolicy;
import org.apache.hadoop.fs.permission.AccessControlException;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.HadoopShimsSecure;
import org.apache.hadoop.hive.shims.MiniSparkOnYARNCluster;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.hive.shims.ZeroCopyShims;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.MRVersion;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.WebHCatJTShim23;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.util.Progressable;
import org.apache.tez.test.MiniTezCluster;

public class Hadoop23Shims
extends HadoopShimsSecure {
    HadoopShims.MiniDFSShim cluster = null;
    final boolean zeroCopy;
    private volatile HadoopShims.HCatHadoopShims hcatShimInstance;
    protected static final Method accessMethod;
    protected static final Method getPasswordMethod;

    public Hadoop23Shims() {
        boolean zcr = false;
        try {
            Class.forName("org.apache.hadoop.fs.CacheFlag", false, ShimLoader.class.getClassLoader());
            zcr = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.zeroCopy = zcr;
    }

    @Override
    public HadoopShims.CombineFileInputFormatShim getCombineFileInputFormat() {
        return new HadoopShimsSecure.CombineFileInputFormatShim(){

            public RecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
                throw new IOException("CombineFileInputFormat.getRecordReader not needed.");
            }

            protected List<FileStatus> listStatus(org.apache.hadoop.mapreduce.JobContext job) throws IOException {
                List result = super.listStatus(job);
                Iterator it = result.iterator();
                while (it.hasNext()) {
                    FileStatus stat = (FileStatus)it.next();
                    if (stat.isFile()) continue;
                    it.remove();
                }
                return result;
            }
        };
    }

    @Override
    public String getTaskAttemptLogUrl(JobConf conf, String taskTrackerHttpAddress, String taskAttemptId) throws MalformedURLException {
        if (this.isMR2()) {
            LOG.warn((Object)"Can't fetch tasklog: TaskLogServlet is not supported in MR2 mode.");
            return null;
        }
        LOG.warn((Object)"Can't fetch tasklog: TaskLogServlet is not supported in MR1 mode.");
        return null;
    }

    @Override
    public HadoopShims.JobTrackerState getJobTrackerState(ClusterStatus clusterStatus) throws Exception {
        switch (clusterStatus.getJobTrackerStatus()) {
            case INITIALIZING: {
                return HadoopShims.JobTrackerState.INITIALIZING;
            }
            case RUNNING: {
                return HadoopShims.JobTrackerState.RUNNING;
            }
        }
        String errorMsg = "Unrecognized JobTracker state: " + clusterStatus.getJobTrackerStatus();
        throw new Exception(errorMsg);
    }

    @Override
    public TaskAttemptContext newTaskAttemptContext(Configuration conf, final Progressable progressable) {
        TaskAttemptID taskAttemptId = TaskAttemptID.forName((String)conf.get("mapreduce.task.attempt.id"));
        if (taskAttemptId == null) {
            taskAttemptId = new TaskAttemptID();
        }
        return new TaskAttemptContextImpl(conf, taskAttemptId){

            public void progress() {
                progressable.progress();
            }
        };
    }

    @Override
    public TaskAttemptID newTaskAttemptID(JobID jobId, boolean isMap, int taskId, int id) {
        return new TaskAttemptID(jobId.getJtIdentifier(), jobId.getId(), isMap ? TaskType.MAP : TaskType.REDUCE, taskId, id);
    }

    @Override
    public org.apache.hadoop.mapreduce.JobContext newJobContext(Job job) {
        return new JobContextImpl(job.getConfiguration(), job.getJobID());
    }

    @Override
    public boolean isLocalMode(Configuration conf) {
        if (this.isMR2()) {
            return "local".equals(conf.get("mapreduce.framework.name"));
        }
        return "local".equals(conf.get("mapred.job.tracker"));
    }

    @Override
    public String getJobLauncherRpcAddress(Configuration conf) {
        if (this.isMR2()) {
            return conf.get("yarn.resourcemanager.address");
        }
        return conf.get("mapred.job.tracker");
    }

    @Override
    public void setJobLauncherRpcAddress(Configuration conf, String val) {
        if (val.equals("local")) {
            if (this.isMR2()) {
                conf.set("mapreduce.framework.name", val);
                conf.set("mapreduce.jobtracker.address", val);
            } else {
                conf.set("mapred.job.tracker", val);
            }
        } else if (this.isMR2()) {
            conf.set("mapreduce.framework.name", "yarn");
            conf.set("yarn.resourcemanager.address", val);
        } else {
            conf.set("mapred.job.tracker", val);
        }
    }

    @Override
    public String getJobLauncherHttpAddress(Configuration conf) {
        if (this.isMR2()) {
            return conf.get("yarn.resourcemanager.webapp.address");
        }
        return conf.get("mapred.job.tracker.http.address");
    }

    protected boolean isExtendedAclEnabled(Configuration conf) {
        return Objects.equal(conf.get("dfs.namenode.acls.enabled"), "true");
    }

    @Override
    public long getDefaultBlockSize(FileSystem fs, Path path) {
        return fs.getDefaultBlockSize(path);
    }

    @Override
    public short getDefaultReplication(FileSystem fs, Path path) {
        return fs.getDefaultReplication(path);
    }

    @Override
    public boolean moveToAppropriateTrash(FileSystem fs, Path path, Configuration conf) throws IOException {
        return Trash.moveToAppropriateTrash((FileSystem)fs, (Path)path, (Configuration)conf);
    }

    @Override
    public void setTotalOrderPartitionFile(JobConf jobConf, Path partitionFile) {
        try {
            Class<?> clazz = Class.forName("org.apache.hadoop.mapred.lib.TotalOrderPartitioner");
            try {
                Method method = clazz.getMethod("setPartitionFile", Configuration.class, Path.class);
                method.invoke(null, jobConf, partitionFile);
            }
            catch (NoSuchMethodException nsme) {
                Method method = clazz.getMethod("setPartitionFile", JobConf.class, Path.class);
                method.invoke(null, jobConf, partitionFile);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to find TotalOrderPartitioner.setPartitionFile", e);
        }
    }

    @Override
    public Comparator<LongWritable> getLongComparator() {
        return new Comparator<LongWritable>(){

            @Override
            public int compare(LongWritable o1, LongWritable o2) {
                return o1.compareTo(o2);
            }
        };
    }

    @Override
    public void refreshDefaultQueue(Configuration conf, String userName) throws IOException {
        if (StringUtils.isNotBlank(userName) && this.isFairScheduler(conf)) {
            ShimLoader.getSchedulerShims().refreshDefaultQueue(conf, userName);
        }
    }

    private boolean isFairScheduler(Configuration conf) {
        return "org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler".equalsIgnoreCase(conf.get("yarn.resourcemanager.scheduler.class"));
    }

    @Override
    public MiniMrShim getMiniMrCluster(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
        return new MiniMrShim(conf, numberOfTaskTrackers, nameNode, numDir);
    }

    @Override
    public HadoopShims.MiniMrShim getLocalMiniTezCluster(Configuration conf, boolean usingLlap) {
        return new MiniTezLocalShim(conf, usingLlap);
    }

    @Override
    public MiniMrShim getMiniTezCluster(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
        return new MiniTezShim(conf, numberOfTaskTrackers, nameNode, numDir);
    }

    private void configureImpersonation(Configuration conf) {
        String user;
        try {
            user = Utils.getUGI().getShortUserName();
        }
        catch (Exception e) {
            String msg = "Cannot obtain username: " + e;
            throw new IllegalStateException(msg, e);
        }
        conf.set("hadoop.proxyuser." + user + ".groups", "*");
        conf.set("hadoop.proxyuser." + user + ".hosts", "*");
    }

    @Override
    public MiniMrShim getMiniSparkCluster(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
        return new MiniSparkShim(conf, numberOfTaskTrackers, nameNode, numDir);
    }

    @Override
    public HadoopShims.MiniDFSShim getMiniDfs(Configuration conf, int numDataNodes, boolean format, String[] racks) throws IOException {
        this.configureImpersonation(conf);
        MiniDFSCluster miniDFSCluster = new MiniDFSCluster(conf, numDataNodes, format, racks);
        KeyProviderCryptoExtension keyProvider = miniDFSCluster.getNameNode().getNamesystem().getProvider();
        if (keyProvider != null) {
            miniDFSCluster.getFileSystem().getClient().setKeyProvider((KeyProvider)keyProvider);
        }
        this.cluster = new MiniDFSShim(miniDFSCluster);
        return this.cluster;
    }

    @Override
    public HadoopShims.HCatHadoopShims getHCatShim() {
        if (this.hcatShimInstance == null) {
            this.hcatShimInstance = new HCatHadoopShims23();
        }
        return this.hcatShimInstance;
    }

    @Override
    public HadoopShims.WebHCatJTShim getWebHCatShim(Configuration conf, UserGroupInformation ugi) throws IOException {
        return new WebHCatJTShim23(conf, ugi);
    }

    @Override
    public List<FileStatus> listLocatedStatus(FileSystem fs, Path path, PathFilter filter) throws IOException {
        RemoteIterator itr = fs.listLocatedStatus(path);
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        while (itr.hasNext()) {
            FileStatus stat = (FileStatus)itr.next();
            if (filter != null && !filter.accept(stat.getPath())) continue;
            result.add(stat);
        }
        return result;
    }

    @Override
    public BlockLocation[] getLocations(FileSystem fs, FileStatus status) throws IOException {
        if (status instanceof LocatedFileStatus) {
            return ((LocatedFileStatus)status).getBlockLocations();
        }
        return fs.getFileBlockLocations(status, 0L, status.getLen());
    }

    @Override
    public TreeMap<Long, BlockLocation> getLocationsWithOffset(FileSystem fs, FileStatus status) throws IOException {
        BlockLocation[] locations;
        TreeMap<Long, BlockLocation> offsetBlockMap = new TreeMap<Long, BlockLocation>();
        for (BlockLocation location : locations = this.getLocations(fs, status)) {
            offsetBlockMap.put(location.getOffset(), location);
        }
        return offsetBlockMap;
    }

    @Override
    public void hflush(FSDataOutputStream stream) throws IOException {
        stream.hflush();
    }

    @Override
    public HadoopShims.HdfsFileStatus getFullFileStatus(Configuration conf, FileSystem fs, Path file) throws IOException {
        FileStatus fileStatus = fs.getFileStatus(file);
        AclStatus aclStatus = null;
        if (this.isExtendedAclEnabled(conf)) {
            try {
                aclStatus = fs.getAclStatus(file);
            }
            catch (Exception e) {
                LOG.info((Object)("Skipping ACL inheritance: File system for path " + file + " " + "does not support ACLs but dfs.namenode.acls.enabled is set to true. "));
                LOG.debug((Object)("The details are: " + e), (Throwable)e);
            }
        }
        return new Hadoop23FileStatus(fileStatus, aclStatus);
    }

    @Override
    public void setFullFileStatus(Configuration conf, HadoopShims.HdfsFileStatus sourceStatus, String targetGroup, FileSystem fs, Path target, boolean recursive) {
        this.setFullFileStatus(conf, sourceStatus, targetGroup, fs, target, recursive, recursive ? new FsShell() : null);
    }

    @Override
    public void setFullFileStatus(Configuration conf, HadoopShims.HdfsFileStatus sourceStatus, String targetGroup, FileSystem fs, Path target, boolean recursive, FsShell fsShell) {
        try {
            Hadoop23FileStatus status;
            String group = sourceStatus.getFileStatus().getGroup();
            boolean aclEnabled = this.isExtendedAclEnabled(conf);
            ArrayList<AclEntry> aclEntries = null;
            FsPermission sourcePerm = sourceStatus.getFileStatus().getPermission();
            if (aclEnabled && (status = (Hadoop23FileStatus)sourceStatus).getAclEntries() != null) {
                aclEntries = new ArrayList<AclEntry>(status.getAclEntries());
                this.removeBaseAclEntries(aclEntries);
                aclEntries.add(this.newAclEntry(AclEntryScope.ACCESS, AclEntryType.USER, sourcePerm.getUserAction()));
                aclEntries.add(this.newAclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, sourcePerm.getGroupAction()));
                aclEntries.add(this.newAclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, sourcePerm.getOtherAction()));
            }
            if (recursive) {
                fsShell.setConf(conf);
                if (group != null && !group.isEmpty()) {
                    this.run(fsShell, new String[]{"-chgrp", "-R", group, target.toString()});
                }
                if (aclEnabled) {
                    if (aclEntries != null) {
                        try {
                            String aclEntry = Joiner.on(",").join(aclEntries);
                            this.run(fsShell, new String[]{"-setfacl", "-R", "--set", aclEntry, target.toString()});
                        }
                        catch (Exception e) {
                            LOG.info((Object)("Skipping ACL inheritance: File system for path " + target + " " + "does not support ACLs but dfs.namenode.acls.enabled is set to true. "));
                            LOG.debug((Object)("The details are: " + e), (Throwable)e);
                        }
                    }
                } else {
                    String permission = Integer.toString(sourceStatus.getFileStatus().getPermission().toShort(), 8);
                    this.run(fsShell, new String[]{"-chmod", "-R", permission, target.toString()});
                }
            } else {
                if (!(group == null || group.isEmpty() || targetGroup != null && group.equals(targetGroup))) {
                    fs.setOwner(target, null, group);
                }
                if (aclEnabled) {
                    if (null != aclEntries) {
                        fs.setAcl(target, aclEntries);
                    }
                } else {
                    fs.setPermission(target, sourcePerm);
                }
            }
            try {
                if (LOG.isDebugEnabled()) {
                    this.getFullFileStatus(conf, fs, target).debugLog();
                }
            }
            catch (Exception e) {}
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to inherit permissions for file " + target + " from file " + sourceStatus.getFileStatus().getPath() + " " + e.getMessage()));
            LOG.debug((Object)"Exception while inheriting permissions", (Throwable)e);
        }
    }

    private AclEntry newAclEntry(AclEntryScope scope, AclEntryType type, FsAction permission) {
        return new AclEntry.Builder().setScope(scope).setType(type).setPermission(permission).build();
    }

    private void removeBaseAclEntries(List<AclEntry> entries) {
        Iterables.removeIf(entries, new Predicate<AclEntry>(){

            @Override
            public boolean apply(AclEntry input) {
                return input.getName() == null;
            }
        });
    }

    private boolean isMR2() {
        return MRVersion.isMR2();
    }

    @Override
    public FileSystem createProxyFileSystem(FileSystem fs, URI uri) {
        return new ProxyFileSystem23(fs, uri);
    }

    @Override
    public Map<String, String> getHadoopConfNames() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("HADOOPFS", "fs.defaultFS");
        if (this.isMR2()) {
            ret.put("HADOOPMAPFILENAME", "mapreduce.map.input.file");
            ret.put("HADOOPMAPREDINPUTDIR", "mapreduce.input.fileinputformat.inputdir");
            ret.put("HADOOPMAPREDINPUTDIRRECURSIVE", "mapreduce.input.fileinputformat.input.dir.recursive");
            ret.put("MAPREDMAXSPLITSIZE", "mapreduce.input.fileinputformat.split.maxsize");
            ret.put("MAPREDMINSPLITSIZE", "mapreduce.input.fileinputformat.split.minsize");
            ret.put("MAPREDMINSPLITSIZEPERNODE", "mapreduce.input.fileinputformat.split.minsize.per.node");
            ret.put("MAPREDMINSPLITSIZEPERRACK", "mapreduce.input.fileinputformat.split.minsize.per.rack");
            ret.put("HADOOPNUMREDUCERS", "mapreduce.job.reduces");
            ret.put("HADOOPJOBNAME", "mapreduce.job.name");
            ret.put("HADOOPSPECULATIVEEXECREDUCERS", "mapreduce.reduce.speculative");
            ret.put("MAPREDSETUPCLEANUPNEEDED", "mapreduce.job.committer.setup.cleanup.needed");
            ret.put("MAPREDTASKCLEANUPNEEDED", "mapreduce.job.committer.task.cleanup.needed");
        } else {
            ret.put("HADOOPMAPFILENAME", "map.input.file");
            ret.put("HADOOPMAPREDINPUTDIR", "mapred.input.dir");
            ret.put("HADOOPMAPREDINPUTDIRRECURSIVE", "mapred.input.dir.recursive");
            ret.put("MAPREDMAXSPLITSIZE", "mapred.max.split.size");
            ret.put("MAPREDMINSPLITSIZE", "mapred.min.split.size");
            ret.put("MAPREDMINSPLITSIZEPERNODE", "mapred.min.split.size.per.node");
            ret.put("MAPREDMINSPLITSIZEPERRACK", "mapred.min.split.size.per.rack");
            ret.put("HADOOPNUMREDUCERS", "mapred.reduce.tasks");
            ret.put("HADOOPJOBNAME", "mapred.job.name");
            ret.put("HADOOPSPECULATIVEEXECREDUCERS", "mapred.reduce.tasks.speculative.execution");
            ret.put("MAPREDSETUPCLEANUPNEEDED", "mapred.committer.job.setup.cleanup.needed");
            ret.put("MAPREDTASKCLEANUPNEEDED", "mapreduce.job.committer.task.cleanup.needed");
        }
        return ret;
    }

    @Override
    public HadoopShims.ZeroCopyReaderShim getZeroCopyReader(FSDataInputStream in, HadoopShims.ByteBufferPoolShim pool) throws IOException {
        if (this.zeroCopy) {
            return ZeroCopyShims.getZeroCopyReader(in, pool);
        }
        return null;
    }

    @Override
    public HadoopShims.DirectDecompressorShim getDirectDecompressor(HadoopShims.DirectCompressionType codec) {
        if (this.zeroCopy) {
            return ZeroCopyShims.getDirectDecompressor(codec);
        }
        return null;
    }

    @Override
    public Configuration getConfiguration(org.apache.hadoop.mapreduce.JobContext context) {
        return context.getConfiguration();
    }

    @Override
    public JobConf getJobConf(JobContext context) {
        return context.getJobConf();
    }

    @Override
    public FileSystem getNonCachedFileSystem(URI uri, Configuration conf) throws IOException {
        return FileSystem.newInstance((URI)uri, (Configuration)conf);
    }

    @Override
    public void getMergedCredentials(JobConf jobConf) throws IOException {
        jobConf.getCredentials().mergeAll(UserGroupInformation.getCurrentUser().getCredentials());
    }

    @Override
    public void mergeCredentials(JobConf dest, JobConf src) throws IOException {
        dest.getCredentials().mergeAll(src.getCredentials());
    }

    @Override
    public void checkFileAccess(FileSystem fs, FileStatus stat, FsAction action) throws IOException, java.security.AccessControlException, Exception {
        try {
            if (accessMethod == null) {
                DefaultFileAccess.checkFileAccess(fs, stat, action);
            } else {
                accessMethod.invoke((Object)fs, stat.getPath(), action);
            }
        }
        catch (Exception err) {
            throw Hadoop23Shims.wrapAccessException(err);
        }
    }

    private static Exception wrapAccessException(Exception err) {
        int maxDepth = 20;
        Throwable curErr = err;
        for (int idx = 0; curErr != null && idx < 20; curErr = curErr.getCause(), ++idx) {
            if (!(curErr instanceof org.apache.hadoop.security.AccessControlException) && !(curErr instanceof AccessControlException)) continue;
            java.security.AccessControlException newErr = new java.security.AccessControlException(curErr.getMessage());
            newErr.initCause(err);
            return newErr;
        }
        return err;
    }

    @Override
    public String getPassword(Configuration conf, String name) throws IOException {
        if (getPasswordMethod == null) {
            return conf.get(name);
        }
        try {
            char[] pw = (char[])getPasswordMethod.invoke((Object)conf, name);
            if (pw == null) {
                return null;
            }
            return new String(pw);
        }
        catch (Exception err) {
            throw new IOException(err.getMessage(), err);
        }
    }

    @Override
    public boolean supportStickyBit() {
        return true;
    }

    @Override
    public boolean hasStickyBit(FsPermission permission) {
        return permission.getStickyBit();
    }

    @Override
    public boolean supportTrashFeature() {
        return true;
    }

    @Override
    public Path getCurrentTrashPath(Configuration conf, FileSystem fs) {
        TrashPolicy tp = TrashPolicy.getInstance((Configuration)conf, (FileSystem)fs, (Path)fs.getHomeDirectory());
        return tp.getCurrentTrashDir();
    }

    @Override
    public KerberosNameShim getKerberosNameShim(String name) throws IOException {
        return new KerberosNameShim(name);
    }

    @Override
    public boolean isDirectory(FileStatus fileStatus) {
        return fileStatus.isDirectory();
    }

    @Override
    public boolean runDistCp(Path src, Path dst, Configuration conf) throws IOException {
        DistCpOptions options = new DistCpOptions(Collections.singletonList(src), dst);
        options.setSyncFolder(true);
        options.setSkipCRC(true);
        options.preserve(DistCpOptions.FileAttribute.BLOCKSIZE);
        String[] params = new String[]{"-update", "-skipcrccheck", src.toString(), dst.toString()};
        try {
            DistCp distcp = new DistCp(conf, options);
            return distcp.run(params) == 0;
        }
        catch (Exception e) {
            throw new IOException("Cannot execute DistCp process: " + e, e);
        }
    }

    @Override
    public HadoopShims.HdfsEncryptionShim createHdfsEncryptionShim(FileSystem fs, Configuration conf) throws IOException {
        URI uri = fs.getUri();
        if ("hdfs".equals(uri.getScheme())) {
            return new HdfsEncryptionShim(uri, conf);
        }
        return new HadoopShims.NoopHdfsEncryptionShim();
    }

    @Override
    public Path getPathWithoutSchemeAndAuthority(Path path) {
        return Path.getPathWithoutSchemeAndAuthority((Path)path);
    }

    static {
        Method m = null;
        try {
            m = FileSystem.class.getMethod("access", Path.class, FsAction.class);
        }
        catch (NoSuchMethodException err) {
            // empty catch block
        }
        accessMethod = m;
        try {
            m = Configuration.class.getMethod("getPassword", String.class);
        }
        catch (NoSuchMethodException err) {
            m = null;
        }
        getPasswordMethod = m;
    }

    public class HdfsEncryptionShim
    implements HadoopShims.HdfsEncryptionShim {
        private final String HDFS_SECURITY_DEFAULT_CIPHER = "AES/CTR/NoPadding";
        private HdfsAdmin hdfsAdmin = null;
        private KeyProvider keyProvider = null;
        private Configuration conf;

        public HdfsEncryptionShim(URI uri, Configuration conf) throws IOException {
            DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
            this.conf = conf;
            this.hdfsAdmin = new HdfsAdmin(uri, conf);
            this.keyProvider = this.hdfsAdmin.getKeyProvider();
        }

        @Override
        public boolean isPathEncrypted(Path path) throws IOException {
            Path fullPath = path.isAbsolute() ? path : path.getFileSystem(this.conf).makeQualified(path);
            if (!"hdfs".equalsIgnoreCase(path.toUri().getScheme())) {
                return false;
            }
            return this.hdfsAdmin.getEncryptionZoneForPath(fullPath) != null;
        }

        @Override
        public boolean arePathsOnSameEncryptionZone(Path path1, Path path2) throws IOException {
            return this.equivalentEncryptionZones(this.hdfsAdmin.getEncryptionZoneForPath(path1), this.hdfsAdmin.getEncryptionZoneForPath(path2));
        }

        private boolean equivalentEncryptionZones(EncryptionZone zone1, EncryptionZone zone2) {
            if (zone1 == null && zone2 == null) {
                return true;
            }
            if (zone1 == null || zone2 == null) {
                return false;
            }
            return zone1.equals((Object)zone2);
        }

        @Override
        public boolean arePathsOnSameEncryptionZone(Path path1, Path path2, HadoopShims.HdfsEncryptionShim encryptionShim2) throws IOException {
            if (!(encryptionShim2 instanceof HdfsEncryptionShim)) {
                HadoopShimsSecure.LOG.warn((Object)("EncryptionShim for path2 (" + path2 + ") is of unexpected type: " + encryptionShim2.getClass() + ". Assuming path2 is on the same EncryptionZone as path1(" + path1 + ")."));
                return true;
            }
            return this.equivalentEncryptionZones(this.hdfsAdmin.getEncryptionZoneForPath(path1), ((HdfsEncryptionShim)encryptionShim2).hdfsAdmin.getEncryptionZoneForPath(path2));
        }

        @Override
        public int comparePathKeyStrength(Path path1, Path path2) throws IOException {
            EncryptionZone zone1 = this.hdfsAdmin.getEncryptionZoneForPath(path1);
            EncryptionZone zone2 = this.hdfsAdmin.getEncryptionZoneForPath(path2);
            if (zone1 == null && zone2 == null) {
                return 0;
            }
            if (zone1 == null) {
                return -1;
            }
            if (zone2 == null) {
                return 1;
            }
            return this.compareKeyStrength(zone1.getKeyName(), zone2.getKeyName());
        }

        @Override
        public void createEncryptionZone(Path path, String keyName) throws IOException {
            this.hdfsAdmin.createEncryptionZone(path, keyName);
        }

        @Override
        public void createKey(String keyName, int bitLength) throws IOException, NoSuchAlgorithmException {
            this.checkKeyProvider();
            if (this.keyProvider.getMetadata(keyName) != null) {
                throw new IOException("key '" + keyName + "' already exists");
            }
            KeyProvider.Options options = new KeyProvider.Options(this.conf);
            options.setCipher("AES/CTR/NoPadding");
            options.setBitLength(bitLength);
            this.keyProvider.createKey(keyName, options);
            this.keyProvider.flush();
        }

        @Override
        public void deleteKey(String keyName) throws IOException {
            this.checkKeyProvider();
            if (this.keyProvider.getMetadata(keyName) == null) {
                throw new IOException("key '" + keyName + "' does not exist.");
            }
            this.keyProvider.deleteKey(keyName);
            this.keyProvider.flush();
        }

        @Override
        public List<String> getKeys() throws IOException {
            this.checkKeyProvider();
            return this.keyProvider.getKeys();
        }

        private void checkKeyProvider() throws IOException {
            if (this.keyProvider == null) {
                throw new IOException("HDFS security key provider is not configured on your server.");
            }
        }

        private int compareKeyStrength(String keyname1, String keyname2) throws IOException {
            if (this.keyProvider == null) {
                throw new IOException("HDFS security key provider is not configured on your server.");
            }
            KeyProvider.Metadata meta1 = this.keyProvider.getMetadata(keyname1);
            KeyProvider.Metadata meta2 = this.keyProvider.getMetadata(keyname2);
            if (meta1.getBitLength() < meta2.getBitLength()) {
                return -1;
            }
            if (meta1.getBitLength() == meta2.getBitLength()) {
                return 0;
            }
            return 1;
        }
    }

    public class KerberosNameShim
    implements HadoopShims.KerberosNameShim {
        private final KerberosName kerberosName;

        public KerberosNameShim(String name) {
            this.kerberosName = new KerberosName(name);
        }

        @Override
        public String getDefaultRealm() {
            return this.kerberosName.getDefaultRealm();
        }

        @Override
        public String getServiceName() {
            return this.kerberosName.getServiceName();
        }

        @Override
        public String getHostName() {
            return this.kerberosName.getHostName();
        }

        @Override
        public String getRealm() {
            return this.kerberosName.getRealm();
        }

        @Override
        public String getShortName() throws IOException {
            return this.kerberosName.getShortName();
        }
    }

    class ProxyFileSystem23
    extends ProxyFileSystem {
        public ProxyFileSystem23(FileSystem fs) {
            super(fs);
        }

        public ProxyFileSystem23(FileSystem fs, URI uri) {
            super(fs, uri);
        }

        public RemoteIterator<LocatedFileStatus> listLocatedStatus(final Path f) throws FileNotFoundException, IOException {
            return new RemoteIterator<LocatedFileStatus>(){
                private final RemoteIterator<LocatedFileStatus> stats;
                {
                    this.stats = ProxyFileSystem23.super.listLocatedStatus(ProxyFileSystem23.super.swizzleParamPath(f));
                }

                public boolean hasNext() throws IOException {
                    return this.stats.hasNext();
                }

                public LocatedFileStatus next() throws IOException {
                    LocatedFileStatus result = (LocatedFileStatus)this.stats.next();
                    return new LocatedFileStatus(ProxyFileSystem23.super.swizzleFileStatus((FileStatus)result, false), result.getBlockLocations());
                }
            };
        }

        public void access(Path path, FsAction action) throws java.security.AccessControlException, FileNotFoundException, IOException {
            Path underlyingFsPath = this.swizzleParamPath(path);
            FileStatus underlyingFsStatus = this.fs.getFileStatus(underlyingFsPath);
            try {
                if (accessMethod != null) {
                    accessMethod.invoke((Object)this.fs, underlyingFsPath, action);
                } else {
                    DefaultFileAccess.checkFileAccess(this.fs, underlyingFsStatus, action);
                }
            }
            catch (java.security.AccessControlException err) {
                throw err;
            }
            catch (FileNotFoundException err) {
                throw err;
            }
            catch (IOException err) {
                throw err;
            }
            catch (Exception err) {
                throw new RuntimeException(err.getMessage(), err);
            }
        }
    }

    public class Hadoop23FileStatus
    implements HadoopShims.HdfsFileStatus {
        private final FileStatus fileStatus;
        private final AclStatus aclStatus;

        public Hadoop23FileStatus(FileStatus fileStatus, AclStatus aclStatus) {
            this.fileStatus = fileStatus;
            this.aclStatus = aclStatus;
        }

        @Override
        public FileStatus getFileStatus() {
            return this.fileStatus;
        }

        public List<AclEntry> getAclEntries() {
            return this.aclStatus == null ? null : Collections.unmodifiableList(this.aclStatus.getEntries());
        }

        @VisibleForTesting
        AclStatus getAclStatus() {
            return this.aclStatus;
        }

        @Override
        public void debugLog() {
            if (this.fileStatus != null) {
                HadoopShimsSecure.LOG.debug((Object)this.fileStatus.toString());
            }
            if (this.aclStatus != null) {
                HadoopShimsSecure.LOG.debug((Object)this.aclStatus.toString());
            }
        }
    }

    private final class HCatHadoopShims23
    implements HadoopShims.HCatHadoopShims {
        private HCatHadoopShims23() {
        }

        @Override
        public TaskID createTaskID() {
            return new TaskID("", 0, TaskType.MAP, 0);
        }

        @Override
        public TaskAttemptID createTaskAttemptID() {
            return new TaskAttemptID("", 0, TaskType.MAP, 0, 0);
        }

        @Override
        public TaskAttemptContext createTaskAttemptContext(Configuration conf, TaskAttemptID taskId) {
            return new TaskAttemptContextImpl((Configuration)(conf instanceof JobConf ? new JobConf(conf) : conf), taskId);
        }

        @Override
        public org.apache.hadoop.mapred.TaskAttemptContext createTaskAttemptContext(JobConf conf, org.apache.hadoop.mapred.TaskAttemptID taskId, Progressable progressable) {
            org.apache.hadoop.mapred.TaskAttemptContext newContext = null;
            try {
                Constructor construct = org.apache.hadoop.mapred.TaskAttemptContextImpl.class.getDeclaredConstructor(JobConf.class, org.apache.hadoop.mapred.TaskAttemptID.class, Reporter.class);
                construct.setAccessible(true);
                newContext = (org.apache.hadoop.mapred.TaskAttemptContext)construct.newInstance(new JobConf((Configuration)conf), taskId, progressable);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return newContext;
        }

        @Override
        public org.apache.hadoop.mapreduce.JobContext createJobContext(Configuration conf, JobID jobId) {
            return new JobContextImpl((Configuration)(conf instanceof JobConf ? new JobConf(conf) : conf), jobId);
        }

        @Override
        public JobContext createJobContext(JobConf conf, JobID jobId, Progressable progressable) {
            try {
                Constructor construct = org.apache.hadoop.mapred.JobContextImpl.class.getDeclaredConstructor(JobConf.class, JobID.class, Progressable.class);
                construct.setAccessible(true);
                return (JobContext)construct.newInstance(new JobConf((Configuration)conf), jobId, progressable);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void commitJob(OutputFormat outputFormat, Job job) throws IOException {
        }

        @Override
        public void abortJob(OutputFormat outputFormat, Job job) throws IOException {
        }

        @Override
        public InetSocketAddress getResourceManagerAddress(Configuration conf) {
            String addr = conf.get("yarn.resourcemanager.address", "localhost:8032");
            return NetUtils.createSocketAddr((String)addr);
        }

        @Override
        public String getPropertyName(HadoopShims.HCatHadoopShims.PropertyName name) {
            boolean mr2 = Hadoop23Shims.this.isMR2();
            switch (name) {
                case CACHE_ARCHIVES: {
                    if (mr2) {
                        return "mapreduce.job.cache.archives";
                    }
                    return "mapred.cache.archives";
                }
                case CACHE_FILES: {
                    if (mr2) {
                        return "mapreduce.job.cache.files";
                    }
                    return "mapred.cache.files";
                }
                case CACHE_SYMLINK: {
                    if (mr2) {
                        return "mapreduce.job.cache.symlink.create";
                    }
                    return "mapred.create.symlink";
                }
                case CLASSPATH_ARCHIVES: {
                    return "mapreduce.job.classpath.archives";
                }
                case CLASSPATH_FILES: {
                    return "mapreduce.job.classpath.files";
                }
            }
            return "";
        }

        @Override
        public boolean isFileInHDFS(FileSystem fs, Path path) throws IOException {
            return "hdfs".equals(fs.resolvePath(path).toUri().getScheme());
        }
    }

    public class MiniDFSShim
    implements HadoopShims.MiniDFSShim {
        private final MiniDFSCluster cluster;

        public MiniDFSShim(MiniDFSCluster cluster) {
            this.cluster = cluster;
        }

        @Override
        public FileSystem getFileSystem() throws IOException {
            return this.cluster.getFileSystem();
        }

        @Override
        public void shutdown() {
            this.cluster.shutdown();
        }
    }

    public class MiniSparkShim
    extends MiniMrShim {
        private final MiniSparkOnYARNCluster mr;
        private final Configuration conf;

        public MiniSparkShim(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
            this.mr = new MiniSparkOnYARNCluster("sparkOnYarn");
            conf.set("fs.defaultFS", nameNode);
            conf.set("yarn.resourcemanager.scheduler.class", "org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler");
            Hadoop23Shims.this.configureImpersonation(conf);
            this.mr.init(conf);
            this.mr.start();
            this.conf = this.mr.getConfig();
        }

        @Override
        public int getJobTrackerPort() throws UnsupportedOperationException {
            String address = this.conf.get("yarn.resourcemanager.address");
            if (StringUtils.isBlank(address = StringUtils.substringAfterLast(address, ":"))) {
                throw new IllegalArgumentException("Invalid YARN resource manager port.");
            }
            return Integer.parseInt(address);
        }

        @Override
        public void shutdown() throws IOException {
            this.mr.stop();
        }

        @Override
        public void setupConfiguration(Configuration conf) {
            Configuration config = this.mr.getConfig();
            for (Map.Entry pair : config) {
                conf.set((String)pair.getKey(), (String)pair.getValue());
            }
        }
    }

    public class MiniTezShim
    extends MiniMrShim {
        private final MiniTezCluster mr;
        private final Configuration conf;

        public MiniTezShim(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
            this.mr = new MiniTezCluster("hive", numberOfTaskTrackers);
            conf.set("fs.defaultFS", nameNode);
            conf.set("tez.am.log.level", "DEBUG");
            conf.set("yarn.app.mapreduce.am.staging-dir", "/apps_staging_dir");
            this.mr.init(conf);
            this.mr.start();
            this.conf = this.mr.getConfig();
        }

        @Override
        public int getJobTrackerPort() throws UnsupportedOperationException {
            String address = this.conf.get("yarn.resourcemanager.address");
            if (StringUtils.isBlank(address = StringUtils.substringAfterLast(address, ":"))) {
                throw new IllegalArgumentException("Invalid YARN resource manager port.");
            }
            return Integer.parseInt(address);
        }

        @Override
        public void shutdown() throws IOException {
            this.mr.stop();
        }

        @Override
        public void setupConfiguration(Configuration conf) {
            Configuration config = this.mr.getConfig();
            for (Map.Entry pair : config) {
                conf.set((String)pair.getKey(), (String)pair.getValue());
            }
        }
    }

    public class MiniTezLocalShim
    extends MiniMrShim {
        private final Configuration conf;
        private final boolean isLlap;

        public MiniTezLocalShim(Configuration conf, boolean usingLlap) {
            this.conf = conf;
            this.isLlap = usingLlap;
            this.setupConfiguration(conf);
        }

        @Override
        public int getJobTrackerPort() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("No JobTracker port for local mode");
        }

        @Override
        public void setupConfiguration(Configuration conf) {
            conf.setBoolean("tez.local.mode", true);
            conf.setBoolean("tez.runtime.optimize.local.fetch", true);
            conf.setBoolean("tez.ignore.lib.uris", true);
            if (!this.isLlap) {
                conf.setBoolean("hive.llap.io.enabled", false);
            }
        }

        @Override
        public void shutdown() throws IOException {
        }
    }

    public class MiniMrShim
    implements HadoopShims.MiniMrShim {
        private final MiniMRCluster mr;
        private final Configuration conf;

        public MiniMrShim() {
            this.mr = null;
            this.conf = null;
        }

        public MiniMrShim(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
            this.conf = conf;
            JobConf jConf = new JobConf(conf);
            jConf.set("yarn.scheduler.capacity.root.queues", "default");
            jConf.set("yarn.scheduler.capacity.root.default.capacity", "100");
            this.mr = new MiniMRCluster(numberOfTaskTrackers, nameNode, numDir, null, null, jConf);
        }

        @Override
        public int getJobTrackerPort() throws UnsupportedOperationException {
            String address = this.conf.get("yarn.resourcemanager.address");
            if (StringUtils.isBlank(address = StringUtils.substringAfterLast(address, ":"))) {
                throw new IllegalArgumentException("Invalid YARN resource manager port.");
            }
            return Integer.parseInt(address);
        }

        @Override
        public void shutdown() throws IOException {
            this.mr.shutdown();
        }

        @Override
        public void setupConfiguration(Configuration conf) {
            JobConf jConf = this.mr.createJobConf();
            for (Map.Entry pair : jConf) {
                conf.set((String)pair.getKey(), (String)pair.getValue());
            }
        }
    }
}

