/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.jsonexplain.tez;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hive.common.jsonexplain.tez.Attr;
import org.apache.hadoop.hive.common.jsonexplain.tez.Connection;
import org.apache.hadoop.hive.common.jsonexplain.tez.Printer;
import org.apache.hadoop.hive.common.jsonexplain.tez.TezJsonParser;
import org.apache.hadoop.hive.common.jsonexplain.tez.Vertex;
import org.json.JSONException;
import org.json.JSONObject;

public final class Op {
    public final String name;
    public final TezJsonParser parser;
    public final String operatorId;
    public Op parent;
    public final List<Op> children;
    public final List<Attr> attrs;
    public final JSONObject opObject;
    public final Vertex vertex;
    public final String outputVertexName;

    public Op(String name, String id, String outputVertexName, List<Op> children, List<Attr> attrs, JSONObject opObject, Vertex vertex, TezJsonParser tezJsonParser) throws JSONException {
        this.name = name;
        this.operatorId = id;
        this.outputVertexName = outputVertexName;
        this.children = children;
        this.attrs = attrs;
        this.opObject = opObject;
        this.vertex = vertex;
        this.parser = tezJsonParser;
    }

    private void inlineJoinOp() throws Exception {
        if (this.name.equals("Map Join Operator")) {
            JSONObject mapjoinObj = this.opObject.getJSONObject("Map Join Operator");
            JSONObject verticeObj = mapjoinObj.getJSONObject("input vertices:");
            HashMap<String, String> posToVertex = new HashMap<String, String>();
            for (String pos : JSONObject.getNames(verticeObj)) {
                String vertexName = verticeObj.getString(pos);
                posToVertex.put(pos, vertexName);
                Connection c = null;
                for (Connection connection : this.vertex.parentConnections) {
                    if (!connection.from.name.equals(vertexName)) continue;
                    c = connection;
                    break;
                }
                if (c == null) continue;
                this.parser.addInline(this, c);
            }
            this.removeAttr("input vertices:");
            JSONObject keys = mapjoinObj.getJSONObject("keys:");
            if (keys.length() != 0) {
                JSONObject newKeys = new JSONObject();
                for (String key : JSONObject.getNames(keys)) {
                    String vertexName = (String)posToVertex.get(key);
                    if (vertexName != null) {
                        newKeys.put(vertexName, keys.get(key));
                        continue;
                    }
                    newKeys.put(this.vertex.name, keys.get(key));
                }
                this.removeAttr("keys:");
                this.attrs.add(new Attr("keys:", newKeys.toString()));
            }
        } else if (this.vertex != null) {
            for (Vertex v : this.vertex.mergeJoinDummyVertexs) {
                this.parser.addInline(this, new Connection(null, v));
            }
        }
    }

    private String getNameWithOpId() {
        if (this.operatorId != null) {
            return this.name + " [" + this.operatorId + "]";
        }
        return this.name;
    }

    public void print(Printer printer, List<Boolean> indentFlag, boolean branchOfJoinOp) throws Exception {
        ArrayList<Boolean> vertexFlag;
        if (this.parser.printSet.contains(this)) {
            printer.println(TezJsonParser.prefixString(indentFlag) + " Please refer to the previous " + this.getNameWithOpId());
            return;
        }
        this.parser.printSet.add(this);
        if (!branchOfJoinOp) {
            printer.println(TezJsonParser.prefixString(indentFlag) + this.getNameWithOpId());
        } else {
            printer.println(TezJsonParser.prefixString(indentFlag, "|<-") + this.getNameWithOpId());
        }
        branchOfJoinOp = false;
        if (this.name.equals("Map Join Operator") || this.name.equals("Merge Join Operator")) {
            this.inlineJoinOp();
            branchOfJoinOp = true;
        }
        ArrayList<Connection> noninlined = new ArrayList<Connection>();
        if (this.parent == null && this.vertex != null) {
            for (Connection connection : this.vertex.parentConnections) {
                if (this.parser.isInline(connection.from)) continue;
                noninlined.add(connection);
            }
        }
        ArrayList<Boolean> attFlag = new ArrayList<Boolean>();
        attFlag.addAll(indentFlag);
        if (branchOfJoinOp || this.parent == null && !noninlined.isEmpty()) {
            attFlag.add(true);
        } else {
            attFlag.add(false);
        }
        Collections.sort(this.attrs);
        for (Attr attr : this.attrs) {
            printer.println(TezJsonParser.prefixString(attFlag) + attr.toString());
        }
        if (this.parser.inlineMap.containsKey(this)) {
            for (int index = 0; index < this.parser.inlineMap.get(this).size(); ++index) {
                Connection connection = this.parser.inlineMap.get(this).get(index);
                vertexFlag = new ArrayList();
                vertexFlag.addAll(indentFlag);
                if (branchOfJoinOp) {
                    vertexFlag.add(true);
                } else {
                    vertexFlag.add(false);
                }
                connection.from.print(printer, vertexFlag, connection.type, this.vertex);
            }
        }
        if (this.parent != null) {
            ArrayList<Boolean> parentFlag = new ArrayList<Boolean>();
            parentFlag.addAll(indentFlag);
            parentFlag.add(false);
            this.parent.print(printer, parentFlag, branchOfJoinOp);
        } else {
            for (int index = 0; index < noninlined.size(); ++index) {
                Vertex v = ((Connection)noninlined.get((int)index)).from;
                vertexFlag = new ArrayList<Boolean>();
                vertexFlag.addAll(indentFlag);
                if (index != noninlined.size() - 1) {
                    vertexFlag.add(true);
                } else {
                    vertexFlag.add(false);
                }
                v.print(printer, vertexFlag, ((Connection)noninlined.get((int)index)).type, this.vertex);
            }
        }
    }

    public void removeAttr(String name) {
        int removeIndex = -1;
        for (int index = 0; index < this.attrs.size(); ++index) {
            if (!this.attrs.get((int)index).name.equals(name)) continue;
            removeIndex = index;
            break;
        }
        if (removeIndex != -1) {
            this.attrs.remove(removeIndex);
        }
    }
}

