/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Date;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.ColumnStatsWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.StringUtils;

public class ColumnStatsTask
extends Task<ColumnStatsWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private FetchOperator ftOp;
    private static final transient Log LOG = LogFactory.getLog(ColumnStatsTask.class);

    @Override
    public void initialize(HiveConf conf, QueryPlan queryPlan, DriverContext ctx) {
        super.initialize(conf, queryPlan, ctx);
        ((ColumnStatsWork)this.work).initializeForFetch();
        try {
            JobConf job = new JobConf((Configuration)conf);
            this.ftOp = new FetchOperator(((ColumnStatsWork)this.work).getfWork(), job);
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    private void unpackBooleanStats(ObjectInspector oi, Object o, String fName, ColumnStatisticsObj statsObj) {
        long v = ((LongObjectInspector)oi).get(o);
        if (fName.equals("counttrues")) {
            statsObj.getStatsData().getBooleanStats().setNumTrues(v);
        } else if (fName.equals("countfalses")) {
            statsObj.getStatsData().getBooleanStats().setNumFalses(v);
        } else if (fName.equals("countnulls")) {
            statsObj.getStatsData().getBooleanStats().setNumNulls(v);
        }
    }

    private void unpackDoubleStats(ObjectInspector oi, Object o, String fName, ColumnStatisticsObj statsObj) {
        if (fName.equals("countnulls")) {
            long v = ((LongObjectInspector)oi).get(o);
            statsObj.getStatsData().getDoubleStats().setNumNulls(v);
        } else if (fName.equals("numdistinctvalues")) {
            long v = ((LongObjectInspector)oi).get(o);
            statsObj.getStatsData().getDoubleStats().setNumDVs(v);
        } else if (fName.equals("max")) {
            double d = ((DoubleObjectInspector)oi).get(o);
            statsObj.getStatsData().getDoubleStats().setHighValue(d);
        } else if (fName.equals("min")) {
            double d = ((DoubleObjectInspector)oi).get(o);
            statsObj.getStatsData().getDoubleStats().setLowValue(d);
        }
    }

    private void unpackDecimalStats(ObjectInspector oi, Object o, String fName, ColumnStatisticsObj statsObj) {
        if (fName.equals("countnulls")) {
            long v = ((LongObjectInspector)oi).get(o);
            statsObj.getStatsData().getDecimalStats().setNumNulls(v);
        } else if (fName.equals("numdistinctvalues")) {
            long v = ((LongObjectInspector)oi).get(o);
            statsObj.getStatsData().getDecimalStats().setNumDVs(v);
        } else if (fName.equals("max")) {
            HiveDecimal d = ((HiveDecimalObjectInspector)oi).getPrimitiveJavaObject(o);
            statsObj.getStatsData().getDecimalStats().setHighValue(this.convertToThriftDecimal(d));
        } else if (fName.equals("min")) {
            HiveDecimal d = ((HiveDecimalObjectInspector)oi).getPrimitiveJavaObject(o);
            statsObj.getStatsData().getDecimalStats().setLowValue(this.convertToThriftDecimal(d));
        }
    }

    private Decimal convertToThriftDecimal(HiveDecimal d) {
        return new Decimal(ByteBuffer.wrap(d.unscaledValue().toByteArray()), (short)d.scale());
    }

    private void unpackLongStats(ObjectInspector oi, Object o, String fName, ColumnStatisticsObj statsObj) {
        if (fName.equals("countnulls")) {
            long v = ((LongObjectInspector)oi).get(o);
            statsObj.getStatsData().getLongStats().setNumNulls(v);
        } else if (fName.equals("numdistinctvalues")) {
            long v = ((LongObjectInspector)oi).get(o);
            statsObj.getStatsData().getLongStats().setNumDVs(v);
        } else if (fName.equals("max")) {
            long v = ((LongObjectInspector)oi).get(o);
            statsObj.getStatsData().getLongStats().setHighValue(v);
        } else if (fName.equals("min")) {
            long v = ((LongObjectInspector)oi).get(o);
            statsObj.getStatsData().getLongStats().setLowValue(v);
        }
    }

    private void unpackStringStats(ObjectInspector oi, Object o, String fName, ColumnStatisticsObj statsObj) {
        if (fName.equals("countnulls")) {
            long v = ((LongObjectInspector)oi).get(o);
            statsObj.getStatsData().getStringStats().setNumNulls(v);
        } else if (fName.equals("numdistinctvalues")) {
            long v = ((LongObjectInspector)oi).get(o);
            statsObj.getStatsData().getStringStats().setNumDVs(v);
        } else if (fName.equals("avglength")) {
            double d = ((DoubleObjectInspector)oi).get(o);
            statsObj.getStatsData().getStringStats().setAvgColLen(d);
        } else if (fName.equals("maxlength")) {
            long v = ((LongObjectInspector)oi).get(o);
            statsObj.getStatsData().getStringStats().setMaxColLen(v);
        }
    }

    private void unpackBinaryStats(ObjectInspector oi, Object o, String fName, ColumnStatisticsObj statsObj) {
        if (fName.equals("countnulls")) {
            long v = ((LongObjectInspector)oi).get(o);
            statsObj.getStatsData().getBinaryStats().setNumNulls(v);
        } else if (fName.equals("avglength")) {
            double d = ((DoubleObjectInspector)oi).get(o);
            statsObj.getStatsData().getBinaryStats().setAvgColLen(d);
        } else if (fName.equals("maxlength")) {
            long v = ((LongObjectInspector)oi).get(o);
            statsObj.getStatsData().getBinaryStats().setMaxColLen(v);
        }
    }

    private void unpackDateStats(ObjectInspector oi, Object o, String fName, ColumnStatisticsObj statsObj) {
        if (fName.equals("countnulls")) {
            long v = ((LongObjectInspector)oi).get(o);
            statsObj.getStatsData().getDateStats().setNumNulls(v);
        } else if (fName.equals("numdistinctvalues")) {
            long v = ((LongObjectInspector)oi).get(o);
            statsObj.getStatsData().getDateStats().setNumDVs(v);
        } else if (fName.equals("max")) {
            DateWritable v = ((DateObjectInspector)oi).getPrimitiveWritableObject(o);
            statsObj.getStatsData().getDateStats().setHighValue(new Date((long)v.getDays()));
        } else if (fName.equals("min")) {
            DateWritable v = ((DateObjectInspector)oi).getPrimitiveWritableObject(o);
            statsObj.getStatsData().getDateStats().setLowValue(new Date((long)v.getDays()));
        }
    }

    private void unpackPrimitiveObject(ObjectInspector oi, Object o, String fieldName, ColumnStatisticsObj statsObj) {
        if (o == null) {
            return;
        }
        if (fieldName.equals("columntype")) {
            PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
            String s = ((StringObjectInspector)poi).getPrimitiveJavaObject(o);
            ColumnStatisticsData statsData = new ColumnStatisticsData();
            if (s.equalsIgnoreCase("long")) {
                LongColumnStatsData longStats = new LongColumnStatsData();
                statsData.setLongStats(longStats);
                statsObj.setStatsData(statsData);
            } else if (s.equalsIgnoreCase("double")) {
                DoubleColumnStatsData doubleStats = new DoubleColumnStatsData();
                statsData.setDoubleStats(doubleStats);
                statsObj.setStatsData(statsData);
            } else if (s.equalsIgnoreCase("string")) {
                StringColumnStatsData stringStats = new StringColumnStatsData();
                statsData.setStringStats(stringStats);
                statsObj.setStatsData(statsData);
            } else if (s.equalsIgnoreCase("boolean")) {
                BooleanColumnStatsData booleanStats = new BooleanColumnStatsData();
                statsData.setBooleanStats(booleanStats);
                statsObj.setStatsData(statsData);
            } else if (s.equalsIgnoreCase("binary")) {
                BinaryColumnStatsData binaryStats = new BinaryColumnStatsData();
                statsData.setBinaryStats(binaryStats);
                statsObj.setStatsData(statsData);
            } else if (s.equalsIgnoreCase("decimal")) {
                DecimalColumnStatsData decimalStats = new DecimalColumnStatsData();
                statsData.setDecimalStats(decimalStats);
                statsObj.setStatsData(statsData);
            } else if (s.equalsIgnoreCase("date")) {
                DateColumnStatsData dateStats = new DateColumnStatsData();
                statsData.setDateStats(dateStats);
                statsObj.setStatsData(statsData);
            }
        } else if (statsObj.getStatsData().isSetBooleanStats()) {
            this.unpackBooleanStats(oi, o, fieldName, statsObj);
        } else if (statsObj.getStatsData().isSetLongStats()) {
            this.unpackLongStats(oi, o, fieldName, statsObj);
        } else if (statsObj.getStatsData().isSetDoubleStats()) {
            this.unpackDoubleStats(oi, o, fieldName, statsObj);
        } else if (statsObj.getStatsData().isSetStringStats()) {
            this.unpackStringStats(oi, o, fieldName, statsObj);
        } else if (statsObj.getStatsData().isSetBinaryStats()) {
            this.unpackBinaryStats(oi, o, fieldName, statsObj);
        } else if (statsObj.getStatsData().isSetDecimalStats()) {
            this.unpackDecimalStats(oi, o, fieldName, statsObj);
        } else if (statsObj.getStatsData().isSetDateStats()) {
            this.unpackDateStats(oi, o, fieldName, statsObj);
        }
    }

    private void unpackStructObject(ObjectInspector oi, Object o, String fName, ColumnStatisticsObj cStatsObj) {
        if (oi.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new RuntimeException("Invalid object datatype : " + oi.getCategory().toString());
        }
        StructObjectInspector soi = (StructObjectInspector)oi;
        List<? extends StructField> fields = soi.getAllStructFieldRefs();
        List<Object> list = soi.getStructFieldsDataAsList(o);
        for (int i = 0; i < fields.size(); ++i) {
            ObjectInspector foi = fields.get(i).getFieldObjectInspector();
            Object f = list == null ? null : list.get(i);
            String fieldName = fields.get(i).getFieldName();
            if (foi.getCategory() == ObjectInspector.Category.PRIMITIVE) {
                this.unpackPrimitiveObject(foi, f, fieldName, cStatsObj);
                continue;
            }
            this.unpackStructObject(foi, f, fieldName, cStatsObj);
        }
    }

    private List<ColumnStatistics> constructColumnStatsFromPackedRows() throws HiveException, MetaException, IOException {
        InspectableObject packedRow;
        String currentDb = SessionState.get().getCurrentDatabase();
        String tableName = ((ColumnStatsWork)this.work).getColStats().getTableName();
        String partName = null;
        List<String> colName = ((ColumnStatsWork)this.work).getColStats().getColName();
        List<String> colType = ((ColumnStatsWork)this.work).getColStats().getColType();
        boolean isTblLevel = ((ColumnStatsWork)this.work).getColStats().isTblLevel();
        ArrayList<ColumnStatistics> stats = new ArrayList<ColumnStatistics>();
        Table tbl = this.db.getTable(currentDb, tableName);
        while ((packedRow = this.ftOp.getNextRow()) != null) {
            if (packedRow.oi.getCategory() != ObjectInspector.Category.STRUCT) {
                throw new HiveException("Unexpected object type encountered while unpacking row");
            }
            ArrayList<ColumnStatisticsObj> statsObjs = new ArrayList<ColumnStatisticsObj>();
            StructObjectInspector soi = (StructObjectInspector)packedRow.oi;
            List<? extends StructField> fields = soi.getAllStructFieldRefs();
            List<Object> list = soi.getStructFieldsDataAsList(packedRow.o);
            List<FieldSchema> partColSchema = tbl.getPartCols();
            int numOfStatCols = isTblLevel ? fields.size() : fields.size() - partColSchema.size();
            for (int i = 0; i < numOfStatCols; ++i) {
                ObjectInspector foi = fields.get(i).getFieldObjectInspector();
                Object f = list == null ? null : list.get(i);
                String fieldName = fields.get(i).getFieldName();
                ColumnStatisticsObj statsObj = new ColumnStatisticsObj();
                statsObj.setColName(colName.get(i));
                statsObj.setColType(colType.get(i));
                this.unpackStructObject(foi, f, fieldName, statsObj);
                statsObjs.add(statsObj);
            }
            if (!isTblLevel) {
                ArrayList<String> partVals = new ArrayList<String>();
                for (int i = fields.size() - partColSchema.size(); i < fields.size(); ++i) {
                    Object partVal = ((PrimitiveObjectInspector)fields.get(i).getFieldObjectInspector()).getPrimitiveJavaObject(list.get(i));
                    partVals.add(partVal == null ? this.conf.getVar(HiveConf.ConfVars.DEFAULTPARTITIONNAME) : partVal.toString());
                }
                partName = Warehouse.makePartName(partColSchema, partVals);
            }
            String[] names = Utilities.getDbTableName(currentDb, tableName);
            ColumnStatisticsDesc statsDesc = this.getColumnStatsDesc(names[0], names[1], partName, isTblLevel);
            ColumnStatistics colStats = new ColumnStatistics();
            colStats.setStatsDesc(statsDesc);
            colStats.setStatsObj(statsObjs);
            stats.add(colStats);
        }
        this.ftOp.clearFetchContext();
        return stats;
    }

    private ColumnStatisticsDesc getColumnStatsDesc(String dbName, String tableName, String partName, boolean isTblLevel) {
        ColumnStatisticsDesc statsDesc = new ColumnStatisticsDesc();
        statsDesc.setDbName(dbName);
        statsDesc.setTableName(tableName);
        statsDesc.setIsTblLevel(isTblLevel);
        if (!isTblLevel) {
            statsDesc.setPartName(partName);
        } else {
            statsDesc.setPartName(null);
        }
        return statsDesc;
    }

    private int persistPartitionStats() throws HiveException, MetaException, IOException {
        List<ColumnStatistics> colStats = this.constructColumnStatsFromPackedRows();
        this.db.setPartitionColumnStatistics(new SetPartitionsStatsRequest(colStats));
        return 0;
    }

    private int persistTableStats() throws HiveException, MetaException, IOException {
        ColumnStatistics colStats = this.constructColumnStatsFromPackedRows().get(0);
        this.db.updateTableColumnStatistics(colStats);
        return 0;
    }

    @Override
    public int execute(DriverContext driverContext) {
        try {
            if (((ColumnStatsWork)this.work).getColStats().isTblLevel()) {
                return this.persistTableStats();
            }
            return this.persistPartitionStats();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to run column stats task", (Throwable)e);
            return 1;
        }
    }

    @Override
    public StageType getType() {
        return StageType.COLUMNSTATS;
    }

    @Override
    public String getName() {
        return "COLUMNSTATS TASK";
    }
}

