/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastHashSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastKeyStore;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashSetResult;
import org.apache.hadoop.io.BytesWritable;

public abstract class VectorMapJoinFastBytesHashSet
extends VectorMapJoinFastBytesHashTable
implements VectorMapJoinBytesHashSet {
    private static final Log LOG = LogFactory.getLog(VectorMapJoinFastBytesHashSet.class);

    @Override
    public VectorMapJoinHashSetResult createHashSetResult() {
        return new VectorMapJoinFastHashSet.HashSetResult();
    }

    @Override
    public void assignSlot(int slot, byte[] keyBytes, int keyStart, int keyLength, long hashCode, boolean isNewKey, BytesWritable currentValue) {
        int tripleIndex = 3 * slot;
        if (isNewKey) {
            this.slotTriples[tripleIndex] = this.keyStore.add(keyBytes, keyStart, keyLength);
            this.slotTriples[tripleIndex + 1] = hashCode;
            this.slotTriples[tripleIndex + 2] = 1L;
        }
    }

    @Override
    public JoinUtil.JoinResult contains(byte[] keyBytes, int keyStart, int keyLength, VectorMapJoinHashSetResult hashSetResult) {
        VectorMapJoinFastHashSet.HashSetResult optimizedHashSetResult = (VectorMapJoinFastHashSet.HashSetResult)hashSetResult;
        optimizedHashSetResult.forget();
        long hashCode = VectorMapJoinFastBytesHashUtil.hashKey(keyBytes, keyStart, keyLength);
        long existance = this.findReadSlot(keyBytes, keyStart, keyLength, hashCode);
        JoinUtil.JoinResult joinResult = existance == -1L ? JoinUtil.JoinResult.NOMATCH : JoinUtil.JoinResult.MATCH;
        optimizedHashSetResult.setJoinResult(joinResult);
        return joinResult;
    }

    public VectorMapJoinFastBytesHashSet(int initialCapacity, float loadFactor, int writeBuffersSize) {
        super(initialCapacity, loadFactor, writeBuffersSize);
        this.keyStore = new VectorMapJoinFastKeyStore(writeBuffersSize);
    }
}

