/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class NullRowsInputFormat
implements InputFormat<NullWritable, NullWritable>,
JobConfigurable {
    static final int MAX_ROW = 100;
    static final Log LOG = LogFactory.getLog((String)NullRowsRecordReader.class.getName());

    public RecordReader<NullWritable, NullWritable> getRecordReader(InputSplit arg0, JobConf arg1, Reporter arg2) throws IOException {
        return new NullRowsRecordReader();
    }

    public InputSplit[] getSplits(JobConf conf, int arg1) throws IOException {
        String[] paths = conf.getTrimmedStrings("mapreduce.input.fileinputformat.inputdir", (String[])null);
        if (paths == null) {
            throw new IOException("Cannot find path in conf");
        }
        InputSplit[] result = new InputSplit[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            result[i] = new DummyInputSplit(paths[i]);
        }
        return result;
    }

    public void configure(JobConf job) {
        LOG.info((Object)"Using null rows input format");
    }

    public static class NullRowsRecordReader
    implements RecordReader<NullWritable, NullWritable> {
        private int counter;

        public void close() throws IOException {
        }

        public NullWritable createKey() {
            return NullWritable.get();
        }

        public NullWritable createValue() {
            return NullWritable.get();
        }

        public long getPos() throws IOException {
            return this.counter;
        }

        public float getProgress() throws IOException {
            return (float)this.counter / 100.0f;
        }

        public boolean next(NullWritable arg0, NullWritable arg1) throws IOException {
            return this.counter++ < 100;
        }
    }

    public static class DummyInputSplit
    extends FileSplit {
        public DummyInputSplit() {
        }

        public DummyInputSplit(String path) {
            super(new Path(path, "null"), 0L, 1L, (String[])null);
        }
    }
}

