/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.io.orc.InStream;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.PositionProvider;
import org.apache.hadoop.hive.ql.io.orc.SchemaEvolution;
import org.apache.hadoop.hive.ql.io.orc.StreamName;
import org.apache.hadoop.hive.ql.io.orc.TreeReaderFactory;
import org.apache.hadoop.hive.ql.io.orc.TypeDescription;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertTreeReaderFactory
extends TreeReaderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TreeReaderFactory.class);

    private static TreeReaderFactory.TreeReader createAnyIntegerConvertTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, SchemaEvolution evolution, boolean[] included, boolean skipCorrupt) throws IOException {
        switch (readerType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                if (fileType.getCategory() == readerType.getCategory()) {
                    throw new IllegalArgumentException("No conversion of type " + (Object)((Object)readerType.getCategory()) + " to self needed");
                }
                return new AnyIntegerFromAnyIntegerTreeReader(columnId, fileType, readerType, skipCorrupt);
            }
            case FLOAT: {
                return new FloatFromAnyIntegerTreeReader(columnId, fileType, skipCorrupt);
            }
            case DOUBLE: {
                return new DoubleFromAnyIntegerTreeReader(columnId, fileType, skipCorrupt);
            }
            case DECIMAL: {
                return new DecimalFromAnyIntegerTreeReader(columnId, fileType, readerType, skipCorrupt);
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new StringGroupFromAnyIntegerTreeReader(columnId, fileType, readerType, skipCorrupt);
            }
            case TIMESTAMP: {
                return new TimestampFromAnyIntegerTreeReader(columnId, fileType, skipCorrupt);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    private static TreeReaderFactory.TreeReader createFloatConvertTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, SchemaEvolution evolution, boolean[] included, boolean skipCorrupt) throws IOException {
        switch (readerType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new AnyIntegerFromFloatTreeReader(columnId, readerType);
            }
            case FLOAT: {
                throw new IllegalArgumentException("No conversion of type " + (Object)((Object)readerType.getCategory()) + " to self needed");
            }
            case DOUBLE: {
                return new DoubleFromFloatTreeReader(columnId);
            }
            case DECIMAL: {
                return new DecimalFromFloatTreeReader(columnId, readerType);
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new StringGroupFromFloatTreeReader(columnId, readerType, skipCorrupt);
            }
            case TIMESTAMP: {
                return new TimestampFromFloatTreeReader(columnId, readerType, skipCorrupt);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    private static TreeReaderFactory.TreeReader createDoubleConvertTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, SchemaEvolution evolution, boolean[] included, boolean skipCorrupt) throws IOException {
        switch (readerType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new AnyIntegerFromDoubleTreeReader(columnId, readerType);
            }
            case FLOAT: {
                return new FloatFromDoubleTreeReader(columnId);
            }
            case DOUBLE: {
                throw new IllegalArgumentException("No conversion of type " + (Object)((Object)readerType.getCategory()) + " to self needed");
            }
            case DECIMAL: {
                return new DecimalFromDoubleTreeReader(columnId, readerType);
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new StringGroupFromDoubleTreeReader(columnId, readerType, skipCorrupt);
            }
            case TIMESTAMP: {
                return new TimestampFromDoubleTreeReader(columnId, readerType, skipCorrupt);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    private static TreeReaderFactory.TreeReader createDecimalConvertTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, SchemaEvolution evolution, boolean[] included, boolean skipCorrupt) throws IOException {
        switch (readerType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new AnyIntegerFromDecimalTreeReader(columnId, fileType, readerType);
            }
            case FLOAT: {
                return new FloatFromDecimalTreeReader(columnId, fileType, readerType);
            }
            case DOUBLE: {
                return new DoubleFromDecimalTreeReader(columnId, fileType, readerType);
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new StringGroupFromDecimalTreeReader(columnId, fileType, readerType, skipCorrupt);
            }
            case TIMESTAMP: {
                return new TimestampFromDecimalTreeReader(columnId, fileType, skipCorrupt);
            }
            case DECIMAL: {
                return new DecimalFromDecimalTreeReader(columnId, fileType, readerType);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    private static TreeReaderFactory.TreeReader createStringConvertTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, SchemaEvolution evolution, boolean[] included, boolean skipCorrupt) throws IOException {
        switch (readerType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new AnyIntegerFromStringGroupTreeReader(columnId, fileType, readerType);
            }
            case FLOAT: {
                return new FloatFromStringGroupTreeReader(columnId, fileType);
            }
            case DOUBLE: {
                return new DoubleFromStringGroupTreeReader(columnId, fileType);
            }
            case DECIMAL: {
                return new DecimalFromStringGroupTreeReader(columnId, fileType, readerType);
            }
            case CHAR: {
                return new StringGroupFromStringGroupTreeReader(columnId, fileType, readerType);
            }
            case VARCHAR: {
                return new StringGroupFromStringGroupTreeReader(columnId, fileType, readerType);
            }
            case STRING: {
                throw new IllegalArgumentException("No conversion of type " + (Object)((Object)readerType.getCategory()) + " to self needed");
            }
            case BINARY: {
                return new BinaryFromStringGroupTreeReader(columnId, fileType);
            }
            case TIMESTAMP: {
                return new TimestampFromStringGroupTreeReader(columnId, fileType);
            }
            case DATE: {
                return new DateFromStringGroupTreeReader(columnId, fileType);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    private static TreeReaderFactory.TreeReader createCharConvertTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, SchemaEvolution evolution, boolean[] included, boolean skipCorrupt) throws IOException {
        switch (readerType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new AnyIntegerFromStringGroupTreeReader(columnId, fileType, readerType);
            }
            case FLOAT: {
                return new FloatFromStringGroupTreeReader(columnId, fileType);
            }
            case DOUBLE: {
                return new DoubleFromStringGroupTreeReader(columnId, fileType);
            }
            case DECIMAL: {
                return new DecimalFromStringGroupTreeReader(columnId, fileType, readerType);
            }
            case STRING: {
                return new StringGroupFromStringGroupTreeReader(columnId, fileType, readerType);
            }
            case VARCHAR: {
                return new StringGroupFromStringGroupTreeReader(columnId, fileType, readerType);
            }
            case CHAR: {
                return new StringGroupFromStringGroupTreeReader(columnId, fileType, readerType);
            }
            case BINARY: {
                return new BinaryFromStringGroupTreeReader(columnId, fileType);
            }
            case TIMESTAMP: {
                return new TimestampFromStringGroupTreeReader(columnId, fileType);
            }
            case DATE: {
                return new DateFromStringGroupTreeReader(columnId, fileType);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    private static TreeReaderFactory.TreeReader createVarcharConvertTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, SchemaEvolution evolution, boolean[] included, boolean skipCorrupt) throws IOException {
        switch (readerType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new AnyIntegerFromStringGroupTreeReader(columnId, fileType, readerType);
            }
            case FLOAT: {
                return new FloatFromStringGroupTreeReader(columnId, fileType);
            }
            case DOUBLE: {
                return new DoubleFromStringGroupTreeReader(columnId, fileType);
            }
            case DECIMAL: {
                return new DecimalFromStringGroupTreeReader(columnId, fileType, readerType);
            }
            case STRING: {
                return new StringGroupFromStringGroupTreeReader(columnId, fileType, readerType);
            }
            case CHAR: {
                return new StringGroupFromStringGroupTreeReader(columnId, fileType, readerType);
            }
            case VARCHAR: {
                return new StringGroupFromStringGroupTreeReader(columnId, fileType, readerType);
            }
            case BINARY: {
                return new BinaryFromStringGroupTreeReader(columnId, fileType);
            }
            case TIMESTAMP: {
                return new TimestampFromStringGroupTreeReader(columnId, fileType);
            }
            case DATE: {
                return new DateFromStringGroupTreeReader(columnId, fileType);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    private static TreeReaderFactory.TreeReader createTimestampConvertTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, SchemaEvolution evolution, boolean[] included, boolean skipCorrupt) throws IOException {
        switch (readerType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new AnyIntegerFromTimestampTreeReader(columnId, readerType, skipCorrupt);
            }
            case FLOAT: {
                return new FloatFromTimestampTreeReader(columnId, readerType, skipCorrupt);
            }
            case DOUBLE: {
                return new DoubleFromTimestampTreeReader(columnId, readerType, skipCorrupt);
            }
            case DECIMAL: {
                return new DecimalFromTimestampTreeReader(columnId, readerType, skipCorrupt);
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new StringGroupFromTimestampTreeReader(columnId, readerType, skipCorrupt);
            }
            case TIMESTAMP: {
                throw new IllegalArgumentException("No conversion of type " + (Object)((Object)readerType.getCategory()) + " to self needed");
            }
            case DATE: {
                return new DateFromTimestampTreeReader(columnId, readerType, skipCorrupt);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    private static TreeReaderFactory.TreeReader createDateConvertTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, SchemaEvolution evolution, boolean[] included, boolean skipCorrupt) throws IOException {
        switch (readerType.getCategory()) {
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new StringGroupFromDateTreeReader(columnId, readerType, skipCorrupt);
            }
            case TIMESTAMP: {
                return new TimestampFromDateTreeReader(columnId, readerType, skipCorrupt);
            }
            case DATE: {
                throw new IllegalArgumentException("No conversion of type " + (Object)((Object)readerType.getCategory()) + " to self needed");
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    private static TreeReaderFactory.TreeReader createBinaryConvertTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, SchemaEvolution evolution, boolean[] included, boolean skipCorrupt) throws IOException {
        switch (readerType.getCategory()) {
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new StringGroupFromBinaryTreeReader(columnId, readerType, skipCorrupt);
            }
            case BINARY: {
                throw new IllegalArgumentException("No conversion of type " + (Object)((Object)readerType.getCategory()) + " to self needed");
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    public static TreeReaderFactory.TreeReader createConvertTreeReader(TypeDescription readerType, SchemaEvolution evolution, boolean[] included, boolean skipCorrupt) throws IOException {
        int columnId = readerType.getId();
        TypeDescription fileType = evolution.getFileType(readerType);
        switch (fileType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return ConvertTreeReaderFactory.createAnyIntegerConvertTreeReader(columnId, fileType, readerType, evolution, included, skipCorrupt);
            }
            case FLOAT: {
                return ConvertTreeReaderFactory.createFloatConvertTreeReader(columnId, fileType, readerType, evolution, included, skipCorrupt);
            }
            case DOUBLE: {
                return ConvertTreeReaderFactory.createDoubleConvertTreeReader(columnId, fileType, readerType, evolution, included, skipCorrupt);
            }
            case DECIMAL: {
                return ConvertTreeReaderFactory.createDecimalConvertTreeReader(columnId, fileType, readerType, evolution, included, skipCorrupt);
            }
            case STRING: {
                return ConvertTreeReaderFactory.createStringConvertTreeReader(columnId, fileType, readerType, evolution, included, skipCorrupt);
            }
            case CHAR: {
                return ConvertTreeReaderFactory.createCharConvertTreeReader(columnId, fileType, readerType, evolution, included, skipCorrupt);
            }
            case VARCHAR: {
                return ConvertTreeReaderFactory.createVarcharConvertTreeReader(columnId, fileType, readerType, evolution, included, skipCorrupt);
            }
            case TIMESTAMP: {
                return ConvertTreeReaderFactory.createTimestampConvertTreeReader(columnId, fileType, readerType, evolution, included, skipCorrupt);
            }
            case DATE: {
                return ConvertTreeReaderFactory.createDateConvertTreeReader(columnId, fileType, readerType, evolution, included, skipCorrupt);
            }
            case BINARY: {
                return ConvertTreeReaderFactory.createBinaryConvertTreeReader(columnId, fileType, readerType, evolution, included, skipCorrupt);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)fileType.getCategory()));
    }

    public static boolean canConvert(TypeDescription fileType, TypeDescription readerType) throws IOException {
        TypeDescription.Category readerTypeCategory = readerType.getCategory();
        switch (readerTypeCategory) {
            case STRUCT: 
            case LIST: 
            case MAP: 
            case UNION: {
                return false;
            }
        }
        switch (fileType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                switch (readerType.getCategory()) {
                    case BINARY: 
                    case DATE: {
                        return false;
                    }
                }
                return true;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                switch (readerType.getCategory()) {
                    default: 
                }
                return true;
            }
            case TIMESTAMP: {
                switch (readerType.getCategory()) {
                    case BINARY: {
                        return false;
                    }
                }
                return true;
            }
            case DATE: {
                switch (readerType.getCategory()) {
                    case BOOLEAN: 
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case DECIMAL: 
                    case BINARY: {
                        return false;
                    }
                }
                return true;
            }
            case BINARY: {
                switch (readerType.getCategory()) {
                    case BOOLEAN: 
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case DECIMAL: 
                    case TIMESTAMP: {
                        return false;
                    }
                }
                return true;
            }
            case STRUCT: 
            case LIST: 
            case MAP: 
            case UNION: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)fileType.getCategory()));
    }

    public static class BinaryFromStringGroupTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TreeReader stringGroupTreeReader;
        private final TypeDescription fileType;
        private Writable writable;

        BinaryFromStringGroupTreeReader(int columnId, TypeDescription fileType) throws IOException {
            super(columnId);
            this.fileType = fileType;
            this.stringGroupTreeReader = this.getStringGroupTreeReader(columnId, fileType);
            this.setConvertTreeReader(this.stringGroupTreeReader);
            this.writable = this.getStringGroupWritable(fileType);
        }

        @Override
        Object next(Object previous) throws IOException {
            String stringValue = this.stringFromStringGroupTreeReader(this.stringGroupTreeReader, this.writable, this.fileType);
            BytesWritable result = null;
            if (stringValue != null) {
                byte[] bytes = stringValue.getBytes();
                result = previous == null ? new BytesWritable() : (BytesWritable)previous;
                result.set(bytes, 0, bytes.length);
            }
            return result;
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            return super.nextVector(previousVector, batchSize);
        }
    }

    public static class DateFromTimestampTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TimestampTreeReader timestampTreeReader;
        private final TypeDescription readerType;
        private TimestampWritable timestampResult;
        private TimestampColumnVector timestampColVector;
        private LongColumnVector longColVector;

        DateFromTimestampTreeReader(int columnId, TypeDescription readerType, boolean skipCorrupt) throws IOException {
            super(columnId);
            this.readerType = readerType;
            this.timestampTreeReader = new TreeReaderFactory.TimestampTreeReader(columnId, skipCorrupt);
            this.setConvertTreeReader(this.timestampTreeReader);
            this.timestampResult = new TimestampWritable();
        }

        @Override
        Object next(Object previous) throws IOException {
            TimestampWritable readTimestampResult = (TimestampWritable)this.timestampTreeReader.next(this.timestampResult);
            DateWritable result = null;
            if (readTimestampResult != null) {
                Date dateValue = DateWritable.timeToDate(readTimestampResult.getSeconds());
                result = previous == null ? new DateWritable() : (DateWritable)previous;
                result.set(dateValue);
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            this.timestampResult.set(this.timestampColVector.asScratchTimestamp(elementNum));
            Date dateValue = DateWritable.timeToDate(this.timestampResult.getSeconds());
            this.longColVector.vector[elementNum] = DateWritable.dateToDays(dateValue);
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.timestampColVector == null) {
                this.timestampColVector = new TimestampColumnVector();
                this.longColVector = (LongColumnVector)previousVector;
            }
            this.timestampTreeReader.nextVector(this.timestampColVector, batchSize);
            this.convertVector(this.timestampColVector, this.longColVector, batchSize);
            return this.longColVector;
        }
    }

    public static class DateFromStringGroupTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TreeReader stringGroupTreeReader;
        private final TypeDescription fileType;
        private Writable writable;
        private BytesColumnVector bytesColVector;
        private LongColumnVector longColVector;

        DateFromStringGroupTreeReader(int columnId, TypeDescription fileType) throws IOException {
            super(columnId);
            this.fileType = fileType;
            this.stringGroupTreeReader = this.getStringGroupTreeReader(columnId, fileType);
            this.setConvertTreeReader(this.stringGroupTreeReader);
            this.writable = this.getStringGroupWritable(fileType);
        }

        @Override
        Object next(Object previous) throws IOException {
            Date dateValue;
            String stringValue = this.stringFromStringGroupTreeReader(this.stringGroupTreeReader, this.writable, this.fileType);
            DateWritable result = null;
            if (stringValue != null && (dateValue = this.parseDateFromString(stringValue)) != null) {
                result = previous == null ? new DateWritable() : (DateWritable)previous;
                result.set(dateValue);
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            String stringValue = this.stringFromBytesColumnVectorEntry(this.bytesColVector, elementNum);
            Date dateValue = this.parseDateFromString(stringValue);
            if (dateValue != null) {
                this.longColVector.vector[elementNum] = DateWritable.dateToDays(dateValue);
            } else {
                this.longColVector.noNulls = false;
                this.longColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.bytesColVector == null) {
                this.bytesColVector = new BytesColumnVector();
                this.longColVector = (LongColumnVector)previousVector;
            }
            this.stringGroupTreeReader.nextVector(this.bytesColVector, batchSize);
            this.convertVector(this.bytesColVector, this.longColVector, batchSize);
            return this.longColVector;
        }
    }

    public static class TimestampFromDateTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.DateTreeReader dateTreeReader;
        private DateWritable doubleResult;
        private LongColumnVector longColVector;
        private TimestampColumnVector timestampColVector;

        TimestampFromDateTreeReader(int columnId, TypeDescription fileType, boolean skipCorrupt) throws IOException {
            super(columnId);
            this.dateTreeReader = new TreeReaderFactory.DateTreeReader(columnId);
            this.setConvertTreeReader(this.dateTreeReader);
            this.doubleResult = new DateWritable();
        }

        @Override
        Object next(Object previous) throws IOException {
            DateWritable readDateResult = (DateWritable)this.dateTreeReader.next(this.doubleResult);
            TimestampWritable result = null;
            if (readDateResult != null) {
                Timestamp timestamp = new Timestamp(readDateResult.get().getTime());
                result = previous == null ? new TimestampWritable() : (TimestampWritable)previous;
                result.set(timestamp);
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            long millis = DateWritable.daysToMillis((int)this.longColVector.vector[elementNum]);
            this.timestampColVector.set(elementNum, new Timestamp(millis));
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.longColVector == null) {
                this.longColVector = new LongColumnVector();
                this.timestampColVector = (TimestampColumnVector)previousVector;
            }
            this.dateTreeReader.nextVector(this.longColVector, batchSize);
            this.convertVector(this.longColVector, this.timestampColVector, batchSize);
            return this.timestampColVector;
        }
    }

    public static class TimestampFromStringGroupTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TreeReader stringGroupTreeReader;
        private final TypeDescription fileType;
        private Writable writable;
        private BytesColumnVector bytesColVector;
        private TimestampColumnVector timestampColVector;

        TimestampFromStringGroupTreeReader(int columnId, TypeDescription fileType) throws IOException {
            super(columnId);
            this.fileType = fileType;
            this.stringGroupTreeReader = this.getStringGroupTreeReader(columnId, fileType);
            this.setConvertTreeReader(this.stringGroupTreeReader);
            this.writable = this.getStringGroupWritable(fileType);
        }

        @Override
        Object next(Object previous) throws IOException {
            Timestamp timestampValue;
            String stringValue = this.stringFromStringGroupTreeReader(this.stringGroupTreeReader, this.writable, this.fileType);
            TimestampWritable result = null;
            if (stringValue != null && (timestampValue = this.parseTimestampFromString(stringValue)) != null) {
                result = previous == null ? new TimestampWritable() : (TimestampWritable)previous;
                result.set(timestampValue);
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            String stringValue = this.stringFromBytesColumnVectorEntry(this.bytesColVector, elementNum);
            Timestamp timestampValue = this.parseTimestampFromString(stringValue);
            if (timestampValue != null) {
                this.timestampColVector.set(elementNum, timestampValue);
            } else {
                this.timestampColVector.noNulls = false;
                this.timestampColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.bytesColVector == null) {
                this.bytesColVector = new BytesColumnVector();
                this.timestampColVector = (TimestampColumnVector)previousVector;
            }
            this.stringGroupTreeReader.nextVector(this.bytesColVector, batchSize);
            this.convertVector(this.bytesColVector, this.timestampColVector, batchSize);
            return this.timestampColVector;
        }
    }

    public static class TimestampFromDecimalTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.DecimalTreeReader decimalTreeReader;
        private final int precision;
        private final int scale;
        private HiveDecimalWritable hiveDecimalResult;
        private DecimalColumnVector decimalColVector;
        private TimestampColumnVector timestampColVector;

        TimestampFromDecimalTreeReader(int columnId, TypeDescription fileType, boolean skipCorrupt) throws IOException {
            super(columnId);
            this.precision = fileType.getPrecision();
            this.scale = fileType.getScale();
            this.decimalTreeReader = new TreeReaderFactory.DecimalTreeReader(columnId, this.precision, this.scale);
            this.setConvertTreeReader(this.decimalTreeReader);
            this.hiveDecimalResult = new HiveDecimalWritable();
        }

        @Override
        Object next(Object previous) throws IOException {
            HiveDecimalWritable readHiveDecimalResult = (HiveDecimalWritable)this.decimalTreeReader.next(this.hiveDecimalResult);
            TimestampWritable result = null;
            if (readHiveDecimalResult != null) {
                Timestamp timestampValue = TimestampWritable.decimalToTimestamp(readHiveDecimalResult.getHiveDecimal());
                result = previous == null ? new TimestampWritable() : (TimestampWritable)previous;
                result.set(timestampValue);
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            Timestamp timestampValue = TimestampWritable.decimalToTimestamp(this.decimalColVector.vector[elementNum].getHiveDecimal());
            this.timestampColVector.set(elementNum, timestampValue);
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.decimalColVector == null) {
                this.decimalColVector = new DecimalColumnVector(this.precision, this.scale);
                this.timestampColVector = (TimestampColumnVector)previousVector;
            }
            this.decimalTreeReader.nextVector(this.decimalColVector, batchSize);
            this.convertVector(this.decimalColVector, this.timestampColVector, batchSize);
            return this.timestampColVector;
        }
    }

    public static class TimestampFromDoubleTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.DoubleTreeReader doubleTreeReader;
        private DoubleWritable doubleResult;
        private DoubleColumnVector doubleColVector;
        private TimestampColumnVector timestampColVector;

        TimestampFromDoubleTreeReader(int columnId, TypeDescription fileType, boolean skipCorrupt) throws IOException {
            super(columnId);
            this.doubleTreeReader = new TreeReaderFactory.DoubleTreeReader(columnId);
            this.setConvertTreeReader(this.doubleTreeReader);
            this.doubleResult = new DoubleWritable();
        }

        @Override
        Object next(Object previous) throws IOException {
            DoubleWritable readDoubleResult = (DoubleWritable)((Object)this.doubleTreeReader.next((Object)this.doubleResult));
            TimestampWritable result = null;
            if (readDoubleResult != null) {
                double doubleValue = readDoubleResult.get();
                result = previous == null ? new TimestampWritable() : (TimestampWritable)previous;
                result.set(TimestampWritable.doubleToTimestamp(doubleValue));
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            double doubleValue = this.doubleColVector.vector[elementNum];
            this.timestampColVector.set(elementNum, TimestampWritable.doubleToTimestamp(doubleValue));
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.doubleColVector == null) {
                this.doubleColVector = new DoubleColumnVector();
                this.timestampColVector = (TimestampColumnVector)previousVector;
            }
            this.doubleTreeReader.nextVector(this.doubleColVector, batchSize);
            this.convertVector(this.doubleColVector, this.timestampColVector, batchSize);
            return this.timestampColVector;
        }
    }

    public static class TimestampFromFloatTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.FloatTreeReader floatTreeReader;
        private FloatWritable floatResult;
        private DoubleColumnVector doubleColVector;
        private TimestampColumnVector timestampColVector;

        TimestampFromFloatTreeReader(int columnId, TypeDescription fileType, boolean skipCorrupt) throws IOException {
            super(columnId);
            this.floatTreeReader = new TreeReaderFactory.FloatTreeReader(columnId);
            this.setConvertTreeReader(this.floatTreeReader);
            this.floatResult = new FloatWritable();
        }

        @Override
        Object next(Object previous) throws IOException {
            FloatWritable readFloatResult = (FloatWritable)this.floatTreeReader.next(this.floatResult);
            TimestampWritable result = null;
            if (readFloatResult != null) {
                float floatValue = readFloatResult.get();
                result = previous == null ? new TimestampWritable() : (TimestampWritable)previous;
                result.set(TimestampWritable.doubleToTimestamp(floatValue));
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            float floatValue = (float)this.doubleColVector.vector[elementNum];
            this.timestampColVector.set(elementNum, TimestampWritable.doubleToTimestamp(floatValue));
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.doubleColVector == null) {
                this.doubleColVector = new DoubleColumnVector();
                this.timestampColVector = (TimestampColumnVector)previousVector;
            }
            this.floatTreeReader.nextVector(this.doubleColVector, batchSize);
            this.convertVector(this.doubleColVector, this.timestampColVector, batchSize);
            return this.timestampColVector;
        }
    }

    public static class TimestampFromAnyIntegerTreeReader
    extends ConvertTreeReader {
        private AnyIntegerTreeReader anyIntegerAsLongTreeReader;
        private LongColumnVector longColVector;
        private TimestampColumnVector timestampColVector;

        TimestampFromAnyIntegerTreeReader(int columnId, TypeDescription fileType, boolean skipCorrupt) throws IOException {
            super(columnId);
            this.anyIntegerAsLongTreeReader = new AnyIntegerTreeReader(columnId, fileType, skipCorrupt);
            this.setConvertTreeReader(this.anyIntegerAsLongTreeReader);
        }

        @Override
        Object next(Object previous) throws IOException {
            TimestampWritable result = null;
            if (this.anyIntegerAsLongTreeReader.read()) {
                long longValue = this.anyIntegerAsLongTreeReader.getLong();
                result = previous == null ? new TimestampWritable() : (TimestampWritable)previous;
                result.set(TimestampWritable.longToTimestamp(longValue, false));
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            long longValue = this.longColVector.vector[elementNum];
            this.timestampColVector.set(elementNum, TimestampWritable.longToTimestamp(longValue, false));
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.longColVector == null) {
                this.longColVector = new LongColumnVector();
                this.timestampColVector = (TimestampColumnVector)previousVector;
            }
            this.anyIntegerAsLongTreeReader.nextVector(this.longColVector, batchSize);
            this.convertVector(this.longColVector, this.timestampColVector, batchSize);
            return this.timestampColVector;
        }
    }

    public static class StringGroupFromBinaryTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.BinaryTreeReader binaryTreeReader;
        private final TypeDescription readerType;
        private BytesWritable binaryWritableResult;
        private BytesColumnVector inBytesColVector;
        private BytesColumnVector outBytesColVector;

        StringGroupFromBinaryTreeReader(int columnId, TypeDescription readerType, boolean skipCorrupt) throws IOException {
            super(columnId);
            this.readerType = readerType;
            this.binaryTreeReader = new TreeReaderFactory.BinaryTreeReader(columnId);
            this.setConvertTreeReader(this.binaryTreeReader);
            this.binaryWritableResult = new BytesWritable();
        }

        @Override
        Object next(Object previous) throws IOException {
            BytesWritable readBytesWritableResult = (BytesWritable)this.binaryTreeReader.next(this.binaryWritableResult);
            Writable result = null;
            if (readBytesWritableResult != null) {
                result = this.getStringGroupResultFromString(previous, this.readerType, readBytesWritableResult.toString());
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            byte[] bytes = this.inBytesColVector.vector[elementNum];
            int start = this.inBytesColVector.start[elementNum];
            int length = this.inBytesColVector.length[elementNum];
            this.assignStringGroupVectorEntry(this.outBytesColVector, elementNum, this.readerType, bytes, start, length);
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.inBytesColVector == null) {
                this.inBytesColVector = new BytesColumnVector();
                this.outBytesColVector = (BytesColumnVector)previousVector;
            }
            this.binaryTreeReader.nextVector(this.inBytesColVector, batchSize);
            this.convertVector(this.inBytesColVector, this.outBytesColVector, batchSize);
            return this.outBytesColVector;
        }
    }

    public static class StringGroupFromStringGroupTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TreeReader stringGroupTreeReader;
        private final TypeDescription fileType;
        private final TypeDescription readerType;
        private Writable writable;

        StringGroupFromStringGroupTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType) throws IOException {
            super(columnId);
            this.fileType = fileType;
            this.readerType = readerType;
            this.stringGroupTreeReader = this.getStringGroupTreeReader(columnId, fileType);
            this.setConvertTreeReader(this.stringGroupTreeReader);
            this.writable = this.getStringGroupWritable(fileType);
        }

        @Override
        Object next(Object previous) throws IOException {
            String stringValue = this.stringFromStringGroupTreeReader(this.stringGroupTreeReader, this.writable, this.fileType);
            Writable result = null;
            if (stringValue != null) {
                result = this.getStringGroupResultFromString(previous, this.readerType, stringValue);
            }
            return result;
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            this.stringGroupTreeReader.nextVector(previousVector, batchSize);
            BytesColumnVector resultColVector = (BytesColumnVector)previousVector;
            if (resultColVector.isRepeating) {
                if (resultColVector.noNulls || !resultColVector.isNull[0]) {
                    this.convertStringGroupVectorElement(resultColVector, 0, this.readerType);
                } else {
                    resultColVector.noNulls = false;
                    resultColVector.isNull[0] = true;
                }
            } else if (resultColVector.noNulls) {
                int i = 0;
                while ((long)i < batchSize) {
                    this.convertStringGroupVectorElement(resultColVector, i, this.readerType);
                    ++i;
                }
            } else {
                int i = 0;
                while ((long)i < batchSize) {
                    if (!resultColVector.isNull[i]) {
                        this.convertStringGroupVectorElement(resultColVector, i, this.readerType);
                    } else {
                        resultColVector.noNulls = false;
                        resultColVector.isNull[i] = true;
                    }
                    ++i;
                }
            }
            return resultColVector;
        }
    }

    public static class StringGroupFromDateTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.DateTreeReader dateTreeReader;
        private final TypeDescription readerType;
        private LongColumnVector longColVector;
        private BytesColumnVector bytesColVector;
        private DateWritable dateWritableResult;
        private Date date;

        StringGroupFromDateTreeReader(int columnId, TypeDescription readerType, boolean skipCorrupt) throws IOException {
            super(columnId);
            this.readerType = readerType;
            this.dateTreeReader = new TreeReaderFactory.DateTreeReader(columnId);
            this.setConvertTreeReader(this.dateTreeReader);
            this.dateWritableResult = new DateWritable();
            this.date = new Date(0L);
        }

        @Override
        Object next(Object previous) throws IOException {
            DateWritable readDateWritableResult = (DateWritable)this.dateTreeReader.next(this.dateWritableResult);
            Writable result = null;
            if (readDateWritableResult != null) {
                result = this.getStringGroupResultFromString(previous, this.readerType, readDateWritableResult.toString());
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            this.date.setTime(DateWritable.daysToMillis((int)this.longColVector.vector[elementNum]));
            String string = this.date.toString();
            byte[] bytes = string.getBytes();
            this.assignStringGroupVectorEntry(this.bytesColVector, elementNum, this.readerType, bytes);
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.longColVector == null) {
                this.longColVector = new LongColumnVector();
                this.bytesColVector = (BytesColumnVector)previousVector;
            }
            this.dateTreeReader.nextVector(this.longColVector, batchSize);
            this.convertVector(this.longColVector, this.bytesColVector, batchSize);
            return this.bytesColVector;
        }
    }

    public static class StringGroupFromTimestampTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TimestampTreeReader timestampTreeReader;
        private final TypeDescription readerType;
        private TimestampWritable timestampWritableResult;
        private TimestampColumnVector timestampColVector;
        private BytesColumnVector bytesColVector;

        StringGroupFromTimestampTreeReader(int columnId, TypeDescription readerType, boolean skipCorrupt) throws IOException {
            super(columnId);
            this.readerType = readerType;
            this.timestampTreeReader = new TreeReaderFactory.TimestampTreeReader(columnId, skipCorrupt);
            this.setConvertTreeReader(this.timestampTreeReader);
            this.timestampWritableResult = new TimestampWritable();
        }

        @Override
        Object next(Object previous) throws IOException {
            TimestampWritable readTimestampWritableResult = (TimestampWritable)this.timestampTreeReader.next(this.timestampWritableResult);
            Writable result = null;
            if (readTimestampWritableResult != null) {
                result = this.getStringGroupResultFromString(previous, this.readerType, readTimestampWritableResult.toString());
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            String string = this.timestampColVector.asScratchTimestamp(elementNum).toString();
            byte[] bytes = string.getBytes();
            this.assignStringGroupVectorEntry(this.bytesColVector, elementNum, this.readerType, bytes);
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.timestampColVector == null) {
                this.timestampColVector = new TimestampColumnVector();
                this.bytesColVector = (BytesColumnVector)previousVector;
            }
            this.timestampTreeReader.nextVector(this.timestampColVector, batchSize);
            this.convertVector(this.timestampColVector, this.bytesColVector, batchSize);
            return this.bytesColVector;
        }
    }

    public static class StringGroupFromDecimalTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.DecimalTreeReader decimalTreeReader;
        private int precision;
        private int scale;
        private final TypeDescription readerType;
        private HiveDecimalWritable hiveDecimalResult;
        private DecimalColumnVector decimalColVector;
        private BytesColumnVector bytesColVector;

        StringGroupFromDecimalTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, boolean skipCorrupt) throws IOException {
            super(columnId);
            this.precision = fileType.getPrecision();
            this.scale = fileType.getScale();
            this.readerType = readerType;
            this.decimalTreeReader = new TreeReaderFactory.DecimalTreeReader(columnId, this.precision, this.scale);
            this.setConvertTreeReader(this.decimalTreeReader);
            this.hiveDecimalResult = new HiveDecimalWritable();
        }

        @Override
        Object next(Object previous) throws IOException {
            HiveDecimalWritable readHiveDecimalResult = (HiveDecimalWritable)this.decimalTreeReader.next(this.hiveDecimalResult);
            Writable result = null;
            if (readHiveDecimalResult != null) {
                result = this.getStringGroupResultFromString(previous, this.readerType, readHiveDecimalResult.getHiveDecimal().toString());
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            String string = this.decimalColVector.vector[elementNum].getHiveDecimal().toString();
            byte[] bytes = string.getBytes();
            this.assignStringGroupVectorEntry(this.bytesColVector, elementNum, this.readerType, bytes);
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.decimalColVector == null) {
                this.decimalColVector = new DecimalColumnVector(this.precision, this.scale);
                this.bytesColVector = (BytesColumnVector)previousVector;
            }
            this.decimalTreeReader.nextVector(this.decimalColVector, batchSize);
            this.convertVector(this.decimalColVector, this.bytesColVector, batchSize);
            return this.bytesColVector;
        }
    }

    public static class StringGroupFromDoubleTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.DoubleTreeReader doubleTreeReader;
        private final TypeDescription readerType;
        private DoubleWritable doubleResult;
        private DoubleColumnVector doubleColVector;
        private BytesColumnVector bytesColVector;

        StringGroupFromDoubleTreeReader(int columnId, TypeDescription readerType, boolean skipCorrupt) throws IOException {
            super(columnId);
            this.readerType = readerType;
            this.doubleTreeReader = new TreeReaderFactory.DoubleTreeReader(columnId);
            this.setConvertTreeReader(this.doubleTreeReader);
            this.doubleResult = new DoubleWritable();
        }

        @Override
        Object next(Object previous) throws IOException {
            double doubleValue;
            DoubleWritable readDoubleResult = (DoubleWritable)((Object)this.doubleTreeReader.next((Object)this.doubleResult));
            Writable result = null;
            if (readDoubleResult != null && !Double.isNaN(doubleValue = readDoubleResult.get())) {
                result = this.getStringGroupResultFromString(previous, this.readerType, String.valueOf(doubleValue));
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            double doubleValue = this.doubleColVector.vector[elementNum];
            if (!Double.isNaN(doubleValue)) {
                String string = String.valueOf(doubleValue);
                byte[] bytes = string.getBytes();
                this.assignStringGroupVectorEntry(this.bytesColVector, elementNum, this.readerType, bytes);
            } else {
                this.bytesColVector.noNulls = false;
                this.bytesColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.doubleColVector == null) {
                this.doubleColVector = new DoubleColumnVector();
                this.bytesColVector = (BytesColumnVector)previousVector;
            }
            this.doubleTreeReader.nextVector(this.doubleColVector, batchSize);
            this.convertVector(this.doubleColVector, this.bytesColVector, batchSize);
            return this.bytesColVector;
        }
    }

    public static class StringGroupFromFloatTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.FloatTreeReader floatTreeReader;
        private final TypeDescription readerType;
        private FloatWritable floatResult;
        private DoubleColumnVector doubleColVector;
        private BytesColumnVector bytesColVector;

        StringGroupFromFloatTreeReader(int columnId, TypeDescription readerType, boolean skipCorrupt) throws IOException {
            super(columnId);
            this.readerType = readerType;
            this.floatTreeReader = new TreeReaderFactory.FloatTreeReader(columnId);
            this.setConvertTreeReader(this.floatTreeReader);
            this.floatResult = new FloatWritable();
        }

        @Override
        Object next(Object previous) throws IOException {
            float floatValue;
            FloatWritable readFloatResult = (FloatWritable)this.floatTreeReader.next(this.floatResult);
            Writable result = null;
            if (readFloatResult != null && !Float.isNaN(floatValue = readFloatResult.get())) {
                result = this.getStringGroupResultFromString(previous, this.readerType, String.valueOf(floatValue));
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            float floatValue = (float)this.doubleColVector.vector[elementNum];
            if (!Float.isNaN(floatValue)) {
                String string = String.valueOf(floatValue);
                byte[] bytes = string.getBytes();
                this.assignStringGroupVectorEntry(this.bytesColVector, elementNum, this.readerType, bytes);
            } else {
                this.bytesColVector.noNulls = false;
                this.bytesColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.doubleColVector == null) {
                this.doubleColVector = new DoubleColumnVector();
                this.bytesColVector = (BytesColumnVector)previousVector;
            }
            this.floatTreeReader.nextVector(this.doubleColVector, batchSize);
            this.convertVector(this.doubleColVector, this.bytesColVector, batchSize);
            return this.bytesColVector;
        }
    }

    public static class StringGroupFromAnyIntegerTreeReader
    extends ConvertTreeReader {
        private AnyIntegerTreeReader anyIntegerAsLongTreeReader;
        private final TypeDescription fileType;
        private final TypeDescription readerType;
        private LongColumnVector longColVector;
        private BytesColumnVector bytesColVector;

        StringGroupFromAnyIntegerTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, boolean skipCorrupt) throws IOException {
            super(columnId);
            this.fileType = fileType;
            this.readerType = readerType;
            this.anyIntegerAsLongTreeReader = new AnyIntegerTreeReader(columnId, fileType, skipCorrupt);
            this.setConvertTreeReader(this.anyIntegerAsLongTreeReader);
        }

        @Override
        Object next(Object previous) throws IOException {
            Writable result = null;
            if (this.anyIntegerAsLongTreeReader.read()) {
                result = this.getStringGroupResultFromString(previous, this.readerType, this.anyIntegerAsLongTreeReader.getString());
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            long longValue = this.longColVector.vector[elementNum];
            String string = this.anyIntegerAsLongTreeReader.getString(longValue);
            byte[] bytes = string.getBytes();
            this.assignStringGroupVectorEntry(this.bytesColVector, elementNum, this.readerType, bytes);
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.longColVector == null) {
                this.longColVector = new LongColumnVector();
                this.bytesColVector = (BytesColumnVector)previousVector;
            }
            this.anyIntegerAsLongTreeReader.nextVector(this.longColVector, batchSize);
            this.convertVector(this.longColVector, this.bytesColVector, batchSize);
            return this.bytesColVector;
        }
    }

    public static class DecimalFromDecimalTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.DecimalTreeReader decimalTreeReader;
        private DecimalColumnVector fileDecimalColVector;
        private int filePrecision;
        private int fileScale;
        private int readerPrecision;
        private int readerScale;
        private DecimalColumnVector decimalColVector;
        private HiveDecimalWritable hiveDecimalResult;

        DecimalFromDecimalTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType) throws IOException {
            super(columnId);
            this.filePrecision = fileType.getPrecision();
            this.fileScale = fileType.getScale();
            this.readerPrecision = readerType.getPrecision();
            this.readerScale = readerType.getScale();
            this.decimalTreeReader = new TreeReaderFactory.DecimalTreeReader(columnId, this.filePrecision, this.fileScale);
            this.hiveDecimalResult = new HiveDecimalWritable();
            this.setConvertTreeReader(this.decimalTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            HiveDecimalWritable valueWritable = HiveDecimalWritable.enforcePrecisionScale(this.fileDecimalColVector.vector[elementNum], this.readerPrecision, this.readerScale);
            if (valueWritable != null) {
                this.decimalColVector.set(elementNum, valueWritable);
            } else {
                this.decimalColVector.noNulls = false;
                this.decimalColVector.isNull[elementNum] = true;
            }
        }

        @Override
        Object next(Object previous) throws IOException {
            HiveDecimalWritable readHiveDecimalResult = (HiveDecimalWritable)this.decimalTreeReader.next(this.hiveDecimalResult);
            if (readHiveDecimalResult == null) {
                return null;
            }
            HiveDecimal value = readHiveDecimalResult.getHiveDecimal();
            if (value == null) {
                return null;
            }
            HiveDecimalWritable result = previous == null ? new HiveDecimalWritable() : (HiveDecimalWritable)previous;
            result.set(value, this.readerPrecision, this.readerScale);
            return result;
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.fileDecimalColVector == null) {
                this.fileDecimalColVector = new DecimalColumnVector(this.filePrecision, this.fileScale);
                this.decimalColVector = (DecimalColumnVector)previousVector;
            }
            this.decimalTreeReader.nextVector(this.fileDecimalColVector, batchSize);
            this.convertVector(this.fileDecimalColVector, this.decimalColVector, batchSize);
            return this.decimalColVector;
        }
    }

    public static class DecimalFromTimestampTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TimestampTreeReader timestampTreeReader;
        private final TypeDescription readerType;
        private TimestampWritable timestampResult;
        private TimestampColumnVector timestampColVector;
        private int precision;
        private int scale;
        private DecimalColumnVector decimalColVector;

        DecimalFromTimestampTreeReader(int columnId, TypeDescription readerType, boolean skipCorrupt) throws IOException {
            super(columnId);
            this.readerType = readerType;
            this.precision = readerType.getPrecision();
            this.scale = readerType.getScale();
            this.timestampTreeReader = new TreeReaderFactory.TimestampTreeReader(columnId, skipCorrupt);
            this.setConvertTreeReader(this.timestampTreeReader);
            this.timestampResult = new TimestampWritable();
        }

        @Override
        Object next(Object previous) throws IOException {
            double doubleValue;
            HiveDecimal value;
            TimestampWritable readTimestampResult = (TimestampWritable)this.timestampTreeReader.next(this.timestampResult);
            HiveDecimalWritable result = null;
            if (readTimestampResult != null && (value = HiveDecimal.create(Double.toString(doubleValue = readTimestampResult.getDouble()))) != null) {
                result = previous == null ? new HiveDecimalWritable() : (HiveDecimalWritable)previous;
                result.set(value, this.precision, this.scale);
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            this.timestampResult.set(this.timestampColVector.asScratchTimestamp(elementNum));
            double doubleValue = this.timestampResult.getDouble();
            HiveDecimal value = HiveDecimal.create(Double.toString(doubleValue));
            if (value != null) {
                this.decimalColVector.set(elementNum, value);
            } else {
                this.decimalColVector.noNulls = false;
                this.decimalColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.timestampColVector == null) {
                this.timestampColVector = new TimestampColumnVector();
                this.decimalColVector = (DecimalColumnVector)previousVector;
            }
            this.timestampTreeReader.nextVector(this.timestampColVector, batchSize);
            this.convertVector(this.timestampColVector, this.decimalColVector, batchSize);
            return this.decimalColVector;
        }
    }

    public static class DecimalFromStringGroupTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TreeReader stringGroupTreeReader;
        private final TypeDescription fileType;
        private Writable writable;
        private BytesColumnVector bytesColVector;
        private int precision;
        private int scale;
        private DecimalColumnVector decimalColVector;

        DecimalFromStringGroupTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType) throws IOException {
            super(columnId);
            this.fileType = fileType;
            this.precision = readerType.getPrecision();
            this.scale = readerType.getScale();
            this.stringGroupTreeReader = this.getStringGroupTreeReader(columnId, fileType);
            this.setConvertTreeReader(this.stringGroupTreeReader);
            this.writable = this.getStringGroupWritable(fileType);
        }

        @Override
        Object next(Object previous) throws IOException {
            HiveDecimal value;
            String stringValue = this.stringFromStringGroupTreeReader(this.stringGroupTreeReader, this.writable, this.fileType);
            HiveDecimalWritable result = null;
            if (stringValue != null && (value = this.parseDecimalFromString(stringValue)) != null) {
                result = previous == null ? new HiveDecimalWritable() : (HiveDecimalWritable)previous;
                result.set(value, this.precision, this.scale);
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            String string = this.stringFromBytesColumnVectorEntry(this.bytesColVector, elementNum);
            HiveDecimal value = this.parseDecimalFromString(string);
            if (value != null) {
                this.decimalColVector.set(elementNum, value);
            } else {
                this.decimalColVector.noNulls = false;
                this.decimalColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.bytesColVector == null) {
                this.bytesColVector = new BytesColumnVector();
                this.decimalColVector = (DecimalColumnVector)previousVector;
            }
            this.stringGroupTreeReader.nextVector(this.bytesColVector, batchSize);
            this.convertVector(this.bytesColVector, this.decimalColVector, batchSize);
            return this.decimalColVector;
        }
    }

    public static class DecimalFromDoubleTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.DoubleTreeReader doubleTreeReader;
        private int precision;
        private int scale;
        private DoubleWritable doubleResult;
        private DoubleColumnVector doubleColVector;
        private DecimalColumnVector decimalColVector;

        DecimalFromDoubleTreeReader(int columnId, TypeDescription readerType) throws IOException {
            super(columnId);
            this.precision = readerType.getPrecision();
            this.scale = readerType.getScale();
            this.doubleTreeReader = new TreeReaderFactory.DoubleTreeReader(columnId);
            this.setConvertTreeReader(this.doubleTreeReader);
            this.doubleResult = new DoubleWritable();
        }

        @Override
        Object next(Object previous) throws IOException {
            HiveDecimal value;
            DoubleWritable readDoubleResult = (DoubleWritable)((Object)this.doubleTreeReader.next((Object)this.doubleResult));
            HiveDecimalWritable result = null;
            if (readDoubleResult != null && (value = HiveDecimal.create(Double.toString(readDoubleResult.get()))) != null) {
                result = previous == null ? new HiveDecimalWritable() : (HiveDecimalWritable)previous;
                result.set(value);
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            HiveDecimal value = HiveDecimal.create(Double.toString(this.doubleColVector.vector[elementNum]));
            if (value != null) {
                this.decimalColVector.set(elementNum, value);
            } else {
                this.decimalColVector.noNulls = false;
                this.decimalColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.doubleColVector == null) {
                this.doubleColVector = new DoubleColumnVector();
                this.decimalColVector = (DecimalColumnVector)previousVector;
            }
            this.doubleTreeReader.nextVector(this.doubleColVector, batchSize);
            this.convertVector(this.doubleColVector, this.decimalColVector, batchSize);
            return this.decimalColVector;
        }
    }

    public static class DecimalFromFloatTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.FloatTreeReader floatTreeReader;
        private int precision;
        private int scale;
        private FloatWritable floatResult;
        private DoubleColumnVector doubleColVector;
        private DecimalColumnVector decimalColVector;

        DecimalFromFloatTreeReader(int columnId, TypeDescription readerType) throws IOException {
            super(columnId);
            this.precision = readerType.getPrecision();
            this.scale = readerType.getScale();
            this.floatTreeReader = new TreeReaderFactory.FloatTreeReader(columnId);
            this.setConvertTreeReader(this.floatTreeReader);
            this.floatResult = new FloatWritable();
        }

        @Override
        Object next(Object previous) throws IOException {
            HiveDecimal value;
            FloatWritable readFloatResult = (FloatWritable)this.floatTreeReader.next(this.floatResult);
            HiveDecimalWritable result = null;
            if (readFloatResult != null && (value = HiveDecimal.create(Float.toString(readFloatResult.get()))) != null) {
                result = previous == null ? new HiveDecimalWritable() : (HiveDecimalWritable)previous;
                result.set(value);
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            float floatValue = (float)this.doubleColVector.vector[elementNum];
            if (!Float.isNaN(floatValue)) {
                HiveDecimal value = HiveDecimal.create(Float.toString(floatValue));
                if (value != null) {
                    this.decimalColVector.set(elementNum, value);
                } else {
                    this.decimalColVector.noNulls = false;
                    this.decimalColVector.isNull[elementNum] = true;
                }
            } else {
                this.decimalColVector.noNulls = false;
                this.decimalColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.doubleColVector == null) {
                this.doubleColVector = new DoubleColumnVector();
                this.decimalColVector = (DecimalColumnVector)previousVector;
            }
            this.floatTreeReader.nextVector(this.doubleColVector, batchSize);
            this.convertVector(this.doubleColVector, this.decimalColVector, batchSize);
            return this.decimalColVector;
        }
    }

    public static class DecimalFromAnyIntegerTreeReader
    extends ConvertTreeReader {
        private AnyIntegerTreeReader anyIntegerAsLongTreeReader;
        private int precision;
        private int scale;
        private LongColumnVector longColVector;
        private DecimalColumnVector decimalColVector;

        DecimalFromAnyIntegerTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, boolean skipCorrupt) throws IOException {
            super(columnId);
            this.precision = readerType.getPrecision();
            this.scale = readerType.getScale();
            this.anyIntegerAsLongTreeReader = new AnyIntegerTreeReader(columnId, fileType, skipCorrupt);
            this.setConvertTreeReader(this.anyIntegerAsLongTreeReader);
        }

        @Override
        Object next(Object previous) throws IOException {
            HiveDecimalWritable result = null;
            if (this.anyIntegerAsLongTreeReader.read()) {
                long longValue = this.anyIntegerAsLongTreeReader.getLong();
                result = new HiveDecimalWritable(longValue);
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            long longValue = this.longColVector.vector[elementNum];
            HiveDecimalWritable hiveDecimalWritable = new HiveDecimalWritable(longValue);
            this.decimalColVector.set(elementNum, hiveDecimalWritable);
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.longColVector == null) {
                this.longColVector = new LongColumnVector();
                this.decimalColVector = (DecimalColumnVector)previousVector;
            }
            this.anyIntegerAsLongTreeReader.nextVector(this.longColVector, batchSize);
            this.convertVector(this.longColVector, this.decimalColVector, batchSize);
            return this.decimalColVector;
        }
    }

    public static class DoubleFromTimestampTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TimestampTreeReader timestampTreeReader;
        private final TypeDescription readerType;
        private TimestampWritable timestampResult;
        private TimestampColumnVector timestampColVector;
        private DoubleColumnVector doubleColVector;

        DoubleFromTimestampTreeReader(int columnId, TypeDescription readerType, boolean skipCorrupt) throws IOException {
            super(columnId);
            this.readerType = readerType;
            this.timestampTreeReader = new TreeReaderFactory.TimestampTreeReader(columnId, skipCorrupt);
            this.setConvertTreeReader(this.timestampTreeReader);
            this.timestampResult = new TimestampWritable();
        }

        @Override
        Object next(Object previous) throws IOException {
            TimestampWritable readTimestampResult = (TimestampWritable)this.timestampTreeReader.next(this.timestampResult);
            DoubleWritable result = null;
            if (readTimestampResult != null) {
                double doubleValue = readTimestampResult.getDouble();
                result = previous == null ? new DoubleWritable() : (DoubleWritable)((Object)previous);
                result.set(doubleValue);
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            this.timestampResult.set(this.timestampColVector.asScratchTimestamp(elementNum));
            this.doubleColVector.vector[elementNum] = this.timestampResult.getDouble();
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.timestampColVector == null) {
                this.timestampColVector = new TimestampColumnVector();
                this.doubleColVector = (DoubleColumnVector)previousVector;
            }
            this.timestampTreeReader.nextVector(this.timestampColVector, batchSize);
            this.convertVector(this.timestampColVector, this.doubleColVector, batchSize);
            return this.doubleColVector;
        }
    }

    public static class DoubleFromStringGroupTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TreeReader stringGroupTreeReader;
        private final TypeDescription fileType;
        private Writable writable;
        private BytesColumnVector bytesColVector;
        private DoubleColumnVector doubleColVector;

        DoubleFromStringGroupTreeReader(int columnId, TypeDescription fileType) throws IOException {
            super(columnId);
            this.fileType = fileType;
            this.stringGroupTreeReader = this.getStringGroupTreeReader(columnId, fileType);
            this.setConvertTreeReader(this.stringGroupTreeReader);
            this.writable = this.getStringGroupWritable(fileType);
        }

        @Override
        Object next(Object previous) throws IOException {
            String stringValue = this.stringFromStringGroupTreeReader(this.stringGroupTreeReader, this.writable, this.fileType);
            DoubleWritable result = null;
            if (stringValue != null) {
                double doubleValue = this.parseDoubleFromString(stringValue);
                if (!this.getIsParseError()) {
                    result = previous == null ? new DoubleWritable() : (DoubleWritable)((Object)previous);
                    result.set(doubleValue);
                }
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            String string = this.stringFromBytesColumnVectorEntry(this.bytesColVector, elementNum);
            double doubleValue = this.parseDoubleFromString(string);
            if (!this.getIsParseError()) {
                this.doubleColVector.vector[elementNum] = doubleValue;
            } else {
                this.doubleColVector.noNulls = false;
                this.doubleColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.bytesColVector == null) {
                this.bytesColVector = new BytesColumnVector();
                this.doubleColVector = (DoubleColumnVector)previousVector;
            }
            this.stringGroupTreeReader.nextVector(this.bytesColVector, batchSize);
            this.convertVector(this.bytesColVector, this.doubleColVector, batchSize);
            return this.doubleColVector;
        }
    }

    public static class DoubleFromDecimalTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.DecimalTreeReader decimalTreeReader;
        private final int precision;
        private final int scale;
        private final TypeDescription readerType;
        private HiveDecimalWritable hiveDecimalResult;
        private DecimalColumnVector decimalColVector;
        private DoubleColumnVector doubleColVector;

        DoubleFromDecimalTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType) throws IOException {
            super(columnId);
            this.precision = fileType.getPrecision();
            this.scale = fileType.getScale();
            this.readerType = readerType;
            this.decimalTreeReader = new TreeReaderFactory.DecimalTreeReader(columnId, this.precision, this.scale);
            this.setConvertTreeReader(this.decimalTreeReader);
            this.hiveDecimalResult = new HiveDecimalWritable();
        }

        @Override
        Object next(Object previous) throws IOException {
            HiveDecimalWritable readHiveDecimalResult = (HiveDecimalWritable)this.decimalTreeReader.next(this.hiveDecimalResult);
            DoubleWritable result = null;
            if (readHiveDecimalResult != null) {
                double doubleValue = readHiveDecimalResult.getHiveDecimal().doubleValue();
                result = previous == null ? new DoubleWritable() : (DoubleWritable)((Object)previous);
                result.set(doubleValue);
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            this.doubleColVector.vector[elementNum] = this.decimalColVector.vector[elementNum].getHiveDecimal().doubleValue();
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.decimalColVector == null) {
                this.decimalColVector = new DecimalColumnVector(this.precision, this.scale);
                this.doubleColVector = (DoubleColumnVector)previousVector;
            }
            this.decimalTreeReader.nextVector(this.decimalColVector, batchSize);
            this.convertVector(this.decimalColVector, this.doubleColVector, batchSize);
            return this.doubleColVector;
        }
    }

    public static class DoubleFromFloatTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.FloatTreeReader floatTreeReader;
        private FloatWritable floatResult;

        DoubleFromFloatTreeReader(int columnId) throws IOException {
            super(columnId);
            this.floatTreeReader = new TreeReaderFactory.FloatTreeReader(columnId);
            this.setConvertTreeReader(this.floatTreeReader);
            this.floatResult = new FloatWritable();
        }

        @Override
        Object next(Object previous) throws IOException {
            FloatWritable readFloatResult = (FloatWritable)this.floatTreeReader.next(this.floatResult);
            DoubleWritable result = null;
            if (readFloatResult != null) {
                result = previous == null ? new DoubleWritable() : (DoubleWritable)((Object)previous);
                result.set(readFloatResult.get());
            }
            return result;
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            return this.floatTreeReader.nextVector(previousVector, batchSize);
        }
    }

    public static class DoubleFromAnyIntegerTreeReader
    extends ConvertTreeReader {
        private AnyIntegerTreeReader anyIntegerAsLongTreeReader;
        private LongColumnVector longColVector;
        private DoubleColumnVector doubleColVector;

        DoubleFromAnyIntegerTreeReader(int columnId, TypeDescription fileType, boolean skipCorrupt) throws IOException {
            super(columnId);
            this.anyIntegerAsLongTreeReader = new AnyIntegerTreeReader(columnId, fileType, skipCorrupt);
            this.setConvertTreeReader(this.anyIntegerAsLongTreeReader);
        }

        @Override
        Object next(Object previous) throws IOException {
            long longValue;
            double doubleValue;
            DoubleWritable result = null;
            if (this.anyIntegerAsLongTreeReader.read() && !Double.isNaN(doubleValue = (double)(longValue = this.anyIntegerAsLongTreeReader.getLong()))) {
                result = previous == null ? new DoubleWritable() : (DoubleWritable)((Object)previous);
                result.set(doubleValue);
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            double doubleValue = this.longColVector.vector[elementNum];
            if (!Double.isNaN(doubleValue)) {
                this.doubleColVector.vector[elementNum] = doubleValue;
            } else {
                this.doubleColVector.vector[elementNum] = Double.NaN;
                this.doubleColVector.noNulls = false;
                this.doubleColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.longColVector == null) {
                this.longColVector = new LongColumnVector();
                this.doubleColVector = (DoubleColumnVector)previousVector;
            }
            this.anyIntegerAsLongTreeReader.nextVector(this.longColVector, batchSize);
            this.convertVector(this.longColVector, this.doubleColVector, batchSize);
            return this.doubleColVector;
        }
    }

    public static class FloatFromTimestampTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TimestampTreeReader timestampTreeReader;
        private final TypeDescription readerType;
        private TimestampWritable timestampResult;
        private TimestampColumnVector timestampColVector;
        private DoubleColumnVector doubleColVector;

        FloatFromTimestampTreeReader(int columnId, TypeDescription readerType, boolean skipCorrupt) throws IOException {
            super(columnId);
            this.readerType = readerType;
            this.timestampTreeReader = new TreeReaderFactory.TimestampTreeReader(columnId, skipCorrupt);
            this.setConvertTreeReader(this.timestampTreeReader);
            this.timestampResult = new TimestampWritable();
        }

        @Override
        Object next(Object previous) throws IOException {
            TimestampWritable readTimestampResult = (TimestampWritable)this.timestampTreeReader.next(this.timestampResult);
            FloatWritable result = null;
            if (readTimestampResult != null) {
                double doubleValue = readTimestampResult.getDouble();
                result = previous == null ? new FloatWritable() : (FloatWritable)previous;
                result.set((float)doubleValue);
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            this.timestampResult.set(this.timestampColVector.asScratchTimestamp(elementNum));
            this.doubleColVector.vector[elementNum] = (float)this.timestampResult.getDouble();
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.timestampColVector == null) {
                this.timestampColVector = new TimestampColumnVector();
                this.doubleColVector = (DoubleColumnVector)previousVector;
            }
            this.timestampTreeReader.nextVector(this.timestampColVector, batchSize);
            this.convertVector(this.timestampColVector, this.doubleColVector, batchSize);
            return this.doubleColVector;
        }
    }

    public static class FloatFromStringGroupTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TreeReader stringGroupTreeReader;
        private final TypeDescription fileType;
        private Writable writable;
        private BytesColumnVector bytesColVector;
        private DoubleColumnVector doubleColVector;

        FloatFromStringGroupTreeReader(int columnId, TypeDescription fileType) throws IOException {
            super(columnId);
            this.fileType = fileType;
            this.stringGroupTreeReader = this.getStringGroupTreeReader(columnId, fileType);
            this.setConvertTreeReader(this.stringGroupTreeReader);
            this.writable = this.getStringGroupWritable(fileType);
        }

        @Override
        Object next(Object previous) throws IOException {
            String stringValue = this.stringFromStringGroupTreeReader(this.stringGroupTreeReader, this.writable, this.fileType);
            FloatWritable result = null;
            if (stringValue != null) {
                float floatValue = this.parseFloatFromString(stringValue);
                if (!this.getIsParseError()) {
                    result = previous == null ? new FloatWritable() : (FloatWritable)previous;
                    result.set(floatValue);
                }
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            String string = this.stringFromBytesColumnVectorEntry(this.bytesColVector, elementNum);
            float floatValue = this.parseFloatFromString(string);
            if (!this.getIsParseError()) {
                this.doubleColVector.vector[elementNum] = floatValue;
            } else {
                this.doubleColVector.vector[elementNum] = Double.NaN;
                this.doubleColVector.noNulls = false;
                this.doubleColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.bytesColVector == null) {
                this.bytesColVector = new BytesColumnVector();
                this.doubleColVector = (DoubleColumnVector)previousVector;
            }
            this.stringGroupTreeReader.nextVector(this.bytesColVector, batchSize);
            this.convertVector(this.bytesColVector, this.doubleColVector, batchSize);
            return this.doubleColVector;
        }
    }

    public static class FloatFromDecimalTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.DecimalTreeReader decimalTreeReader;
        private final int precision;
        private final int scale;
        private final TypeDescription readerType;
        private HiveDecimalWritable hiveDecimalResult;
        private DecimalColumnVector decimalColVector;
        private DoubleColumnVector doubleColVector;

        FloatFromDecimalTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType) throws IOException {
            super(columnId);
            this.precision = fileType.getPrecision();
            this.scale = fileType.getScale();
            this.readerType = readerType;
            this.decimalTreeReader = new TreeReaderFactory.DecimalTreeReader(columnId, this.precision, this.scale);
            this.setConvertTreeReader(this.decimalTreeReader);
            this.hiveDecimalResult = new HiveDecimalWritable();
        }

        @Override
        Object next(Object previous) throws IOException {
            HiveDecimalWritable readHiveDecimalResult = (HiveDecimalWritable)this.decimalTreeReader.next(this.hiveDecimalResult);
            FloatWritable result = null;
            if (readHiveDecimalResult != null) {
                double doubleValue = readHiveDecimalResult.getHiveDecimal().doubleValue();
                result = previous == null ? new FloatWritable() : (FloatWritable)previous;
                result.set((float)doubleValue);
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            this.doubleColVector.vector[elementNum] = (float)this.decimalColVector.vector[elementNum].getHiveDecimal().doubleValue();
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.decimalColVector == null) {
                this.decimalColVector = new DecimalColumnVector(this.precision, this.scale);
                this.doubleColVector = (DoubleColumnVector)previousVector;
            }
            this.decimalTreeReader.nextVector(this.decimalColVector, batchSize);
            this.convertVector(this.decimalColVector, this.doubleColVector, batchSize);
            return this.doubleColVector;
        }
    }

    public static class FloatFromDoubleTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.DoubleTreeReader doubleTreeReader;
        private DoubleWritable doubleResult;

        FloatFromDoubleTreeReader(int columnId) throws IOException {
            super(columnId);
            this.doubleTreeReader = new TreeReaderFactory.DoubleTreeReader(columnId);
            this.setConvertTreeReader(this.doubleTreeReader);
            this.doubleResult = new DoubleWritable();
        }

        @Override
        Object next(Object previous) throws IOException {
            DoubleWritable readDoubleResult = (DoubleWritable)((Object)this.doubleTreeReader.next((Object)this.doubleResult));
            FloatWritable result = null;
            if (readDoubleResult != null) {
                result = previous == null ? new FloatWritable() : (FloatWritable)previous;
                result.set((float)readDoubleResult.get());
            }
            return result;
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            this.doubleTreeReader.nextVector(previousVector, batchSize);
            DoubleColumnVector resultColVector = (DoubleColumnVector)previousVector;
            double[] resultVector = resultColVector.vector;
            if (resultColVector.isRepeating) {
                if (resultColVector.noNulls || !resultColVector.isNull[0]) {
                    resultVector[0] = (float)resultVector[0];
                } else {
                    resultColVector.noNulls = false;
                    resultColVector.isNull[0] = true;
                }
            } else if (resultColVector.noNulls) {
                int i = 0;
                while ((long)i < batchSize) {
                    resultVector[i] = (float)resultVector[i];
                    ++i;
                }
            } else {
                int i = 0;
                while ((long)i < batchSize) {
                    if (!resultColVector.isNull[i]) {
                        resultVector[i] = (float)resultVector[i];
                    } else {
                        resultColVector.noNulls = false;
                        resultColVector.isNull[i] = true;
                    }
                    ++i;
                }
            }
            return resultColVector;
        }
    }

    public static class FloatFromAnyIntegerTreeReader
    extends ConvertTreeReader {
        private AnyIntegerTreeReader anyIntegerAsLongTreeReader;
        private LongColumnVector longColVector;
        private DoubleColumnVector doubleColVector;

        FloatFromAnyIntegerTreeReader(int columnId, TypeDescription fileType, boolean skipCorrupt) throws IOException {
            super(columnId);
            this.anyIntegerAsLongTreeReader = new AnyIntegerTreeReader(columnId, fileType, skipCorrupt);
            this.setConvertTreeReader(this.anyIntegerAsLongTreeReader);
        }

        @Override
        Object next(Object previous) throws IOException {
            long longValue;
            float floatValue;
            FloatWritable result = null;
            if (this.anyIntegerAsLongTreeReader.read() && !Float.isNaN(floatValue = (float)(longValue = this.anyIntegerAsLongTreeReader.getLong()))) {
                result = previous == null ? new FloatWritable() : (FloatWritable)previous;
                result.set(floatValue);
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            float floatValue = this.longColVector.vector[elementNum];
            if (!Float.isNaN(floatValue)) {
                this.doubleColVector.vector[elementNum] = floatValue;
            } else {
                this.doubleColVector.vector[elementNum] = Double.NaN;
                this.doubleColVector.noNulls = false;
                this.doubleColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.longColVector == null) {
                this.longColVector = new LongColumnVector();
                this.doubleColVector = (DoubleColumnVector)previousVector;
            }
            this.anyIntegerAsLongTreeReader.nextVector(this.longColVector, batchSize);
            this.convertVector(this.longColVector, this.doubleColVector, batchSize);
            return this.doubleColVector;
        }
    }

    public static class AnyIntegerFromTimestampTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TimestampTreeReader timestampTreeReader;
        private final TypeDescription readerType;
        private TimestampWritable timestampResult;
        private TimestampColumnVector timestampColVector;
        private LongColumnVector longColVector;

        AnyIntegerFromTimestampTreeReader(int columnId, TypeDescription readerType, boolean skipCorrupt) throws IOException {
            super(columnId);
            this.readerType = readerType;
            this.timestampTreeReader = new TreeReaderFactory.TimestampTreeReader(columnId, skipCorrupt);
            this.setConvertTreeReader(this.timestampTreeReader);
            this.timestampResult = new TimestampWritable();
        }

        @Override
        Object next(Object previous) throws IOException {
            TimestampWritable readHiveTimestampResult = (TimestampWritable)this.timestampTreeReader.next(this.timestampResult);
            Writable result = null;
            if (readHiveTimestampResult != null) {
                long longValue = readHiveTimestampResult.getSeconds();
                result = this.anyIntegerWritable(longValue, previous, this.readerType);
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            this.timestampResult.set(this.timestampColVector.asScratchTimestamp(elementNum));
            long longValue = this.timestampResult.getSeconds();
            this.longColVector.vector[elementNum] = this.downCastAnyInteger(longValue, this.readerType);
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.timestampColVector == null) {
                this.timestampColVector = new TimestampColumnVector();
                this.longColVector = (LongColumnVector)previousVector;
            }
            this.timestampTreeReader.nextVector(this.timestampColVector, batchSize);
            this.convertVector(this.timestampColVector, this.longColVector, batchSize);
            return this.longColVector;
        }
    }

    public static class AnyIntegerFromStringGroupTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TreeReader stringGroupTreeReader;
        private final TypeDescription fileType;
        private final TypeDescription readerType;
        private Writable writable;
        private BytesColumnVector bytesColVector;
        private LongColumnVector longColVector;

        AnyIntegerFromStringGroupTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType) throws IOException {
            super(columnId);
            this.fileType = fileType;
            this.readerType = readerType;
            this.stringGroupTreeReader = this.getStringGroupTreeReader(columnId, fileType);
            this.setConvertTreeReader(this.stringGroupTreeReader);
            this.writable = this.getStringGroupWritable(fileType);
        }

        @Override
        Object next(Object previous) throws IOException {
            String stringValue = this.stringFromStringGroupTreeReader(this.stringGroupTreeReader, this.writable, this.fileType);
            Writable result = null;
            if (stringValue != null) {
                long longValue = this.parseLongFromString(stringValue);
                if (!this.getIsParseError()) {
                    result = this.anyIntegerWritable(longValue, previous, this.readerType);
                }
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            String string = this.stringFromBytesColumnVectorEntry(this.bytesColVector, elementNum);
            long longValue = this.parseLongFromString(string);
            if (!this.getIsParseError()) {
                this.longColVector.vector[elementNum] = this.downCastAnyInteger(longValue, this.readerType);
            } else {
                this.longColVector.noNulls = false;
                this.longColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.bytesColVector == null) {
                this.bytesColVector = new BytesColumnVector();
                this.longColVector = (LongColumnVector)previousVector;
            }
            this.stringGroupTreeReader.nextVector(this.bytesColVector, batchSize);
            this.convertVector(this.bytesColVector, this.longColVector, batchSize);
            return this.longColVector;
        }
    }

    public static class AnyIntegerFromDecimalTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.DecimalTreeReader decimalTreeReader;
        private final int precision;
        private final int scale;
        private final TypeDescription readerType;
        private HiveDecimalWritable hiveDecimalResult;
        private DecimalColumnVector decimalColVector;
        private LongColumnVector longColVector;

        AnyIntegerFromDecimalTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType) throws IOException {
            super(columnId);
            this.precision = fileType.getPrecision();
            this.scale = fileType.getScale();
            this.readerType = readerType;
            this.decimalTreeReader = new TreeReaderFactory.DecimalTreeReader(columnId, this.precision, this.scale);
            this.setConvertTreeReader(this.decimalTreeReader);
            this.hiveDecimalResult = new HiveDecimalWritable();
        }

        @Override
        Object next(Object previous) throws IOException {
            HiveDecimalWritable readHiveDecimalResult = (HiveDecimalWritable)this.decimalTreeReader.next(this.hiveDecimalResult);
            Writable result = null;
            if (readHiveDecimalResult != null) {
                long longValue = readHiveDecimalResult.getHiveDecimal().longValue();
                result = this.anyIntegerWritable(longValue, previous, this.readerType);
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            this.longColVector.vector[elementNum] = this.downCastAnyInteger(this.decimalColVector.vector[elementNum].getHiveDecimal().longValue(), this.readerType);
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.decimalColVector == null) {
                this.decimalColVector = new DecimalColumnVector(this.precision, this.scale);
                this.longColVector = (LongColumnVector)previousVector;
            }
            this.decimalTreeReader.nextVector(this.decimalColVector, batchSize);
            this.convertVector(this.decimalColVector, this.longColVector, batchSize);
            return this.longColVector;
        }
    }

    public static class AnyIntegerFromDoubleTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.DoubleTreeReader doubleTreeReader;
        private final TypeDescription readerType;
        private DoubleWritable doubleResult;
        private DoubleColumnVector doubleColVector;
        private LongColumnVector longColVector;

        AnyIntegerFromDoubleTreeReader(int columnId, TypeDescription readerType) throws IOException {
            super(columnId);
            this.readerType = readerType;
            this.doubleTreeReader = new TreeReaderFactory.DoubleTreeReader(columnId);
            this.setConvertTreeReader(this.doubleTreeReader);
            this.doubleResult = new DoubleWritable();
        }

        @Override
        Object next(Object previous) throws IOException {
            DoubleWritable readDoubleResult = (DoubleWritable)((Object)this.doubleTreeReader.next((Object)this.doubleResult));
            Writable result = null;
            if (readDoubleResult != null) {
                long longValue = (long)readDoubleResult.get();
                result = this.anyIntegerWritable(longValue, previous, this.readerType);
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            this.longColVector.vector[elementNum] = this.downCastAnyInteger((long)this.doubleColVector.vector[elementNum], this.readerType);
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.doubleColVector == null) {
                this.doubleColVector = new DoubleColumnVector();
                this.longColVector = (LongColumnVector)previousVector;
            }
            this.doubleTreeReader.nextVector(this.doubleColVector, batchSize);
            this.convertVector(this.doubleColVector, this.longColVector, batchSize);
            return this.longColVector;
        }
    }

    public static class AnyIntegerFromFloatTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.FloatTreeReader floatTreeReader;
        private final TypeDescription readerType;
        private FloatWritable floatResult;
        private DoubleColumnVector doubleColVector;
        private LongColumnVector longColVector;

        AnyIntegerFromFloatTreeReader(int columnId, TypeDescription readerType) throws IOException {
            super(columnId);
            this.readerType = readerType;
            this.floatTreeReader = new TreeReaderFactory.FloatTreeReader(columnId);
            this.setConvertTreeReader(this.floatTreeReader);
            this.floatResult = new FloatWritable();
        }

        @Override
        Object next(Object previous) throws IOException {
            FloatWritable readfloatResult = (FloatWritable)this.floatTreeReader.next(this.floatResult);
            Writable result = null;
            if (readfloatResult != null) {
                long longValue = (long)readfloatResult.get();
                result = this.anyIntegerWritable(longValue, previous, this.readerType);
            }
            return result;
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            float floatValue = (float)this.doubleColVector.vector[elementNum];
            this.longColVector.vector[elementNum] = this.downCastAnyInteger((long)floatValue, this.readerType);
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            if (this.doubleColVector == null) {
                this.doubleColVector = new DoubleColumnVector();
                this.longColVector = (LongColumnVector)previousVector;
            }
            this.floatTreeReader.nextVector(this.doubleColVector, batchSize);
            this.convertVector(this.doubleColVector, this.longColVector, batchSize);
            return this.longColVector;
        }
    }

    public static class AnyIntegerFromAnyIntegerTreeReader
    extends ConvertTreeReader {
        private AnyIntegerTreeReader anyIntegerAsLongTreeReader;
        private final TypeDescription readerType;
        private final boolean downCastNeeded;

        AnyIntegerFromAnyIntegerTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, boolean skipCorrupt) throws IOException {
            super(columnId);
            this.readerType = readerType;
            this.anyIntegerAsLongTreeReader = new AnyIntegerTreeReader(columnId, fileType, skipCorrupt);
            this.setConvertTreeReader(this.anyIntegerAsLongTreeReader);
            this.downCastNeeded = this.integerDownCastNeeded(fileType, readerType);
        }

        @Override
        Object next(Object previous) throws IOException {
            Writable result = null;
            if (this.anyIntegerAsLongTreeReader.read()) {
                long longValue = this.anyIntegerAsLongTreeReader.getLong();
                result = this.anyIntegerWritable(longValue, previous, this.readerType);
            }
            return result;
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            LongColumnVector resultColVector;
            block10: {
                this.anyIntegerAsLongTreeReader.nextVector(previousVector, batchSize);
                resultColVector = (LongColumnVector)previousVector;
                if (!this.downCastNeeded) break block10;
                long[] resultVector = resultColVector.vector;
                if (resultColVector.isRepeating) {
                    if (resultColVector.noNulls || !resultColVector.isNull[0]) {
                        resultVector[0] = this.downCastAnyInteger(resultVector[0], this.readerType);
                    } else {
                        resultColVector.noNulls = false;
                        resultColVector.isNull[0] = true;
                    }
                } else if (resultColVector.noNulls) {
                    int i = 0;
                    while ((long)i < batchSize) {
                        resultVector[i] = this.downCastAnyInteger(resultVector[i], this.readerType);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while ((long)i < batchSize) {
                        if (!resultColVector.isNull[i]) {
                            resultVector[i] = this.downCastAnyInteger(resultVector[i], this.readerType);
                        } else {
                            resultColVector.noNulls = false;
                            resultColVector.isNull[i] = true;
                        }
                        ++i;
                    }
                }
            }
            return resultColVector;
        }
    }

    public static class AnyIntegerTreeReader
    extends ConvertTreeReader {
        private TypeDescription.Category fileTypeCategory;
        private TreeReaderFactory.TreeReader anyIntegerTreeReader;
        private long longValue;

        AnyIntegerTreeReader(int columnId, TypeDescription fileType, boolean skipCorrupt) throws IOException {
            super(columnId);
            this.fileTypeCategory = fileType.getCategory();
            switch (this.fileTypeCategory) {
                case BOOLEAN: {
                    this.anyIntegerTreeReader = new TreeReaderFactory.BooleanTreeReader(columnId);
                    break;
                }
                case BYTE: {
                    this.anyIntegerTreeReader = new TreeReaderFactory.ByteTreeReader(columnId);
                    break;
                }
                case SHORT: {
                    this.anyIntegerTreeReader = new TreeReaderFactory.ShortTreeReader(columnId);
                    break;
                }
                case INT: {
                    this.anyIntegerTreeReader = new TreeReaderFactory.IntTreeReader(columnId);
                    break;
                }
                case LONG: {
                    this.anyIntegerTreeReader = new TreeReaderFactory.LongTreeReader(columnId, skipCorrupt);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected type kind " + fileType.getCategory().name());
                }
            }
            this.setConvertTreeReader(this.anyIntegerTreeReader);
        }

        @Override
        Object next(Object previous) throws IOException {
            throw new RuntimeException("Call read() and getLong instead");
        }

        protected boolean read() throws IOException {
            this.anyIntegerTreeReader.readValuePresent();
            if (!this.anyIntegerTreeReader.valuePresent) {
                return false;
            }
            switch (this.fileTypeCategory) {
                case BOOLEAN: {
                    this.longValue = ((TreeReaderFactory.BooleanTreeReader)this.anyIntegerTreeReader).reader.next();
                    break;
                }
                case BYTE: {
                    this.longValue = ((TreeReaderFactory.ByteTreeReader)this.anyIntegerTreeReader).reader.next();
                    break;
                }
                case SHORT: {
                    this.longValue = ((TreeReaderFactory.ShortTreeReader)this.anyIntegerTreeReader).reader.next();
                    break;
                }
                case INT: {
                    this.longValue = ((TreeReaderFactory.IntTreeReader)this.anyIntegerTreeReader).reader.next();
                    break;
                }
                case LONG: {
                    this.longValue = ((TreeReaderFactory.LongTreeReader)this.anyIntegerTreeReader).reader.next();
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected type kind " + this.fileTypeCategory.name());
                }
            }
            return true;
        }

        protected long getLong() throws IOException {
            return this.longValue;
        }

        protected String getString(long longValue) {
            if (this.fileTypeCategory == TypeDescription.Category.BOOLEAN) {
                return longValue == 0L ? "FALSE" : "TRUE";
            }
            return Long.toString(longValue);
        }

        protected String getString() {
            return this.getString(this.longValue);
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            return this.anyIntegerTreeReader.nextVector(previousVector, batchSize);
        }
    }

    public static class ConvertTreeReader
    extends TreeReaderFactory.TreeReader {
        private TreeReaderFactory.TreeReader convertTreeReader;
        private static List<TypeDescription.Category> numericTypeList = new ArrayList<TypeDescription.Category>();
        private static EnumMap<TypeDescription.Category, Integer> numericTypes = new EnumMap(TypeDescription.Category.class);
        private boolean isParseError;

        ConvertTreeReader(int columnId) throws IOException {
            super(columnId);
        }

        private static void registerNumericType(TypeDescription.Category kind, int level) {
            numericTypeList.add(kind);
            numericTypes.put(kind, level);
        }

        protected void setConvertTreeReader(TreeReaderFactory.TreeReader convertTreeReader) {
            this.convertTreeReader = convertTreeReader;
        }

        protected TreeReaderFactory.TreeReader getStringGroupTreeReader(int columnId, TypeDescription fileType) throws IOException {
            switch (fileType.getCategory()) {
                case STRING: {
                    return new TreeReaderFactory.StringTreeReader(columnId);
                }
                case CHAR: {
                    return new TreeReaderFactory.CharTreeReader(columnId, fileType.getMaxLength());
                }
                case VARCHAR: {
                    return new TreeReaderFactory.VarcharTreeReader(columnId, fileType.getMaxLength());
                }
            }
            throw new RuntimeException("Unexpected type kind " + fileType.getCategory().name());
        }

        protected Writable getStringGroupWritable(TypeDescription fileType) throws IOException {
            switch (fileType.getCategory()) {
                case STRING: {
                    return new Text();
                }
                case CHAR: {
                    return new HiveCharWritable();
                }
                case VARCHAR: {
                    return new HiveVarcharWritable();
                }
            }
            throw new RuntimeException("Unexpected type kind " + fileType.getCategory().name());
        }

        protected Writable getStringGroupResultFromString(Object previous, TypeDescription readerType, String string) {
            switch (readerType.getCategory()) {
                case STRING: {
                    Text textResult = previous == null ? new Text() : (Text)previous;
                    textResult.set(string);
                    return textResult;
                }
                case CHAR: {
                    HiveCharWritable hiveCharResult = previous == null ? new HiveCharWritable() : (HiveCharWritable)previous;
                    hiveCharResult.set(string, readerType.getMaxLength());
                    return hiveCharResult;
                }
                case VARCHAR: {
                    HiveVarcharWritable hiveVarcharResult = previous == null ? new HiveVarcharWritable() : (HiveVarcharWritable)previous;
                    hiveVarcharResult.set(string, readerType.getMaxLength());
                    return hiveVarcharResult;
                }
            }
            throw new RuntimeException("Unexpected type kind " + readerType.getCategory().name());
        }

        protected void assignStringGroupVectorEntry(BytesColumnVector bytesColVector, int elementNum, TypeDescription readerType, byte[] bytes) {
            this.assignStringGroupVectorEntry(bytesColVector, elementNum, readerType, bytes, 0, bytes.length);
        }

        protected void assignStringGroupVectorEntry(BytesColumnVector bytesColVector, int elementNum, TypeDescription readerType, byte[] bytes, int start, int length) {
            switch (readerType.getCategory()) {
                case STRING: {
                    bytesColVector.setVal(elementNum, bytes, start, length);
                    break;
                }
                case CHAR: {
                    int adjustedDownLen = StringExpr.rightTrimAndTruncate(bytes, start, length, readerType.getMaxLength());
                    bytesColVector.setVal(elementNum, bytes, start, adjustedDownLen);
                    break;
                }
                case VARCHAR: {
                    int adjustedDownLen = StringExpr.truncate(bytes, start, length, readerType.getMaxLength());
                    bytesColVector.setVal(elementNum, bytes, start, adjustedDownLen);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected type kind " + readerType.getCategory().name());
                }
            }
        }

        protected void convertStringGroupVectorElement(BytesColumnVector bytesColVector, int elementNum, TypeDescription readerType) {
            switch (readerType.getCategory()) {
                case STRING: {
                    break;
                }
                case CHAR: {
                    int length = bytesColVector.length[elementNum];
                    int adjustedDownLen = StringExpr.rightTrimAndTruncate(bytesColVector.vector[elementNum], bytesColVector.start[elementNum], length, readerType.getMaxLength());
                    if (adjustedDownLen >= length) break;
                    bytesColVector.length[elementNum] = adjustedDownLen;
                    break;
                }
                case VARCHAR: {
                    int length = bytesColVector.length[elementNum];
                    int adjustedDownLen = StringExpr.truncate(bytesColVector.vector[elementNum], bytesColVector.start[elementNum], length, readerType.getMaxLength());
                    if (adjustedDownLen >= length) break;
                    bytesColVector.length[elementNum] = adjustedDownLen;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected type kind " + readerType.getCategory().name());
                }
            }
        }

        protected boolean getIsParseError() {
            return this.isParseError;
        }

        protected long parseLongFromString(String string) {
            try {
                long longValue = Long.parseLong(string);
                this.isParseError = false;
                return longValue;
            }
            catch (NumberFormatException e) {
                this.isParseError = true;
                return 0L;
            }
        }

        protected float parseFloatFromString(String string) {
            try {
                float floatValue = Float.parseFloat(string);
                this.isParseError = false;
                return floatValue;
            }
            catch (NumberFormatException e) {
                this.isParseError = true;
                return Float.NaN;
            }
        }

        protected double parseDoubleFromString(String string) {
            try {
                double value = Double.parseDouble(string);
                this.isParseError = false;
                return value;
            }
            catch (NumberFormatException e) {
                this.isParseError = true;
                return Double.NaN;
            }
        }

        protected HiveDecimal parseDecimalFromString(String string) {
            try {
                HiveDecimal value = HiveDecimal.create(string);
                return value;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        protected Timestamp parseTimestampFromString(String string) {
            try {
                Timestamp value = Timestamp.valueOf(string);
                return value;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        protected Date parseDateFromString(String string) {
            try {
                Date value = Date.valueOf(string);
                return value;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        protected String stringFromStringGroupTreeReader(TreeReaderFactory.TreeReader stringGroupTreeReader, Writable writable, TypeDescription fileType) throws IOException {
            switch (fileType.getCategory()) {
                case STRING: {
                    Text readTextResult = (Text)((TreeReaderFactory.StringTreeReader)stringGroupTreeReader).next(writable);
                    if (readTextResult == null) {
                        return null;
                    }
                    return readTextResult.toString();
                }
                case CHAR: {
                    HiveCharWritable readHiveCharResult = (HiveCharWritable)((TreeReaderFactory.CharTreeReader)stringGroupTreeReader).next(writable);
                    if (readHiveCharResult == null) {
                        return null;
                    }
                    return readHiveCharResult.getStrippedValue().toString();
                }
                case VARCHAR: {
                    HiveVarcharWritable readHiveVarcharResult = (HiveVarcharWritable)((TreeReaderFactory.VarcharTreeReader)stringGroupTreeReader).next(writable);
                    if (readHiveVarcharResult == null) {
                        return null;
                    }
                    return readHiveVarcharResult.toString();
                }
            }
            throw new RuntimeException("Unexpected type kind " + fileType.getCategory().name());
        }

        protected String stringFromBytesColumnVectorEntry(BytesColumnVector bytesColVector, int elementNum) {
            String string = new String(bytesColVector.vector[elementNum], bytesColVector.start[elementNum], bytesColVector.length[elementNum], StandardCharsets.UTF_8);
            return string;
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            this.convertTreeReader.checkEncoding(encoding);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            this.convertTreeReader.startStripe(streams, stripeFooter);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.convertTreeReader.seek(index);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            this.convertTreeReader.seek(index);
        }

        @Override
        void skipRows(long items) throws IOException {
            this.convertTreeReader.skipRows(items);
        }

        public void setConvertVectorElement(int elementNum) throws IOException {
            throw new RuntimeException("Expected this method to be overriden");
        }

        public void convertVector(ColumnVector fromColVector, ColumnVector resultColVector, long batchSize) throws IOException {
            resultColVector.reset();
            if (fromColVector.isRepeating) {
                resultColVector.isRepeating = true;
                if (fromColVector.noNulls || !fromColVector.isNull[0]) {
                    this.setConvertVectorElement(0);
                } else {
                    resultColVector.noNulls = false;
                    resultColVector.isNull[0] = true;
                }
            } else if (fromColVector.noNulls) {
                int i = 0;
                while ((long)i < batchSize) {
                    this.setConvertVectorElement(i);
                    ++i;
                }
            } else {
                int i = 0;
                while ((long)i < batchSize) {
                    if (!fromColVector.isNull[i]) {
                        this.setConvertVectorElement(i);
                    } else {
                        resultColVector.noNulls = false;
                        resultColVector.isNull[i] = true;
                    }
                    ++i;
                }
            }
        }

        public long downCastAnyInteger(long input, TypeDescription readerType) {
            switch (readerType.getCategory()) {
                case BOOLEAN: {
                    return input == 0L ? 0L : 1L;
                }
                case BYTE: {
                    return (byte)input;
                }
                case SHORT: {
                    return (short)input;
                }
                case INT: {
                    return (int)input;
                }
                case LONG: {
                    return input;
                }
            }
            throw new RuntimeException("Unexpected type kind " + readerType.getCategory().name());
        }

        protected Writable anyIntegerWritable(long longValue, Object previous, TypeDescription readerType) {
            switch (readerType.getCategory()) {
                case BOOLEAN: {
                    BooleanWritable booleanResult = previous == null ? new BooleanWritable() : (BooleanWritable)previous;
                    booleanResult.set(longValue != 0L);
                    return booleanResult;
                }
                case BYTE: {
                    ByteWritable byteResult = previous == null ? new ByteWritable() : (ByteWritable)((Object)previous);
                    byteResult.set((byte)longValue);
                    return byteResult;
                }
                case SHORT: {
                    ShortWritable shortResult = previous == null ? new ShortWritable() : (ShortWritable)previous;
                    shortResult.set((short)longValue);
                    return shortResult;
                }
                case INT: {
                    IntWritable intResult = previous == null ? new IntWritable() : (IntWritable)previous;
                    intResult.set((int)longValue);
                    return intResult;
                }
                case LONG: {
                    LongWritable longResult = previous == null ? new LongWritable() : (LongWritable)previous;
                    longResult.set(longValue);
                    return longResult;
                }
            }
            throw new RuntimeException("Unexpected type kind " + readerType.getCategory().name());
        }

        protected boolean integerDownCastNeeded(TypeDescription fileType, TypeDescription readerType) {
            Integer fileLevel = numericTypes.get((Object)fileType.getCategory());
            Integer schemaLevel = numericTypes.get((Object)readerType.getCategory());
            return schemaLevel < fileLevel;
        }

        static {
            ConvertTreeReader.registerNumericType(TypeDescription.Category.BOOLEAN, 1);
            ConvertTreeReader.registerNumericType(TypeDescription.Category.BYTE, 2);
            ConvertTreeReader.registerNumericType(TypeDescription.Category.SHORT, 3);
            ConvertTreeReader.registerNumericType(TypeDescription.Category.INT, 4);
            ConvertTreeReader.registerNumericType(TypeDescription.Category.LONG, 5);
            ConvertTreeReader.registerNumericType(TypeDescription.Category.FLOAT, 6);
            ConvertTreeReader.registerNumericType(TypeDescription.Category.DOUBLE, 7);
            ConvertTreeReader.registerNumericType(TypeDescription.Category.DECIMAL, 8);
        }
    }
}

