/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.PTFUtils;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.parse.TableSample;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;

@Explain(displayName="TableScan", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class TableScanDesc
extends AbstractOperatorDesc {
    private static final long serialVersionUID = 1L;
    private String alias;
    private List<VirtualColumn> virtualCols;
    private String statsAggKeyPrefix;
    private List<String> partColumns;
    private int rowLimit = -1;
    private boolean gatherStats;
    private boolean statsReliable;
    private int maxStatsKeyPrefixLength = -1;
    private String tmpStatsDir;
    private ExprNodeGenericFuncDesc filterExpr;
    private transient Serializable filterObject;
    private List<Integer> neededColumnIDs;
    private List<String> neededColumns;
    private transient List<String> referencedColumns;
    public static final String FILTER_EXPR_CONF_STR = "hive.io.filter.expr.serialized";
    public static final String FILTER_TEXT_CONF_STR = "hive.io.filter.text";
    public static final String FILTER_OBJECT_CONF_STR = "hive.io.filter.object";
    private Map<String, Integer> bucketFileNameMapping;
    private boolean isMetadataOnly = false;
    private boolean isAcidTable;
    private transient TableSample tableSample;
    private final transient Table tableMetadata;

    public TableScanDesc() {
        this(null, null);
    }

    public TableScanDesc(Table tblMetadata) {
        this(null, tblMetadata);
    }

    public TableScanDesc(String alias, Table tblMetadata) {
        this(alias, null, tblMetadata);
    }

    public TableScanDesc(String alias, List<VirtualColumn> vcs, Table tblMetadata) {
        this.alias = alias;
        this.virtualCols = vcs;
        this.tableMetadata = tblMetadata;
        this.isAcidTable = AcidUtils.isAcidTable(this.tableMetadata);
    }

    @Override
    public Object clone() {
        ArrayList<VirtualColumn> vcs = new ArrayList<VirtualColumn>(this.getVirtualCols());
        return new TableScanDesc(this.getAlias(), vcs, this.tableMetadata);
    }

    @Explain(displayName="alias", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getAlias() {
        return this.alias;
    }

    @Explain(displayName="ACID table", explainLevels={Explain.Level.USER}, displayOnlyOnTrue=true)
    public boolean isAcidTable() {
        return this.isAcidTable;
    }

    @Explain(displayName="filterExpr")
    public String getFilterExprString() {
        StringBuffer sb = new StringBuffer();
        PlanUtils.addExprToStringBuffer(this.filterExpr, sb);
        return sb.toString();
    }

    public ExprNodeGenericFuncDesc getFilterExpr() {
        return this.filterExpr;
    }

    public void setFilterExpr(ExprNodeGenericFuncDesc filterExpr) {
        this.filterExpr = filterExpr;
    }

    public Serializable getFilterObject() {
        return this.filterObject;
    }

    public void setFilterObject(Serializable filterObject) {
        this.filterObject = filterObject;
    }

    public void setNeededColumnIDs(List<Integer> neededColumnIDs) {
        this.neededColumnIDs = neededColumnIDs;
    }

    public List<Integer> getNeededColumnIDs() {
        return this.neededColumnIDs;
    }

    public void setNeededColumns(List<String> neededColumns) {
        this.neededColumns = neededColumns;
    }

    public List<String> getNeededColumns() {
        return this.neededColumns;
    }

    public void setReferencedColumns(List<String> referencedColumns) {
        this.referencedColumns = referencedColumns;
    }

    public List<String> getReferencedColumns() {
        return this.referencedColumns;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setPartColumns(List<String> partColumns) {
        this.partColumns = partColumns;
    }

    public List<String> getPartColumns() {
        return this.partColumns;
    }

    public void setGatherStats(boolean gatherStats) {
        this.gatherStats = gatherStats;
    }

    @Explain(displayName="GatherStats", explainLevels={Explain.Level.EXTENDED})
    public boolean isGatherStats() {
        return this.gatherStats;
    }

    public String getTmpStatsDir() {
        return this.tmpStatsDir;
    }

    public void setTmpStatsDir(String tmpStatsDir) {
        this.tmpStatsDir = tmpStatsDir;
    }

    public List<VirtualColumn> getVirtualCols() {
        return this.virtualCols;
    }

    public void setVirtualCols(List<VirtualColumn> virtualCols) {
        this.virtualCols = virtualCols;
    }

    public void addVirtualCols(List<VirtualColumn> virtualCols) {
        this.virtualCols.addAll(virtualCols);
    }

    public boolean hasVirtualCols() {
        return this.virtualCols != null && !this.virtualCols.isEmpty();
    }

    public void setStatsAggPrefix(String k) {
        this.statsAggKeyPrefix = k;
    }

    @Explain(displayName="Statistics Aggregation Key Prefix", explainLevels={Explain.Level.EXTENDED})
    public String getStatsAggPrefix() {
        return this.statsAggKeyPrefix;
    }

    public boolean isStatsReliable() {
        return this.statsReliable;
    }

    public void setStatsReliable(boolean statsReliable) {
        this.statsReliable = statsReliable;
    }

    public int getMaxStatsKeyPrefixLength() {
        return this.maxStatsKeyPrefixLength;
    }

    public void setMaxStatsKeyPrefixLength(int maxStatsKeyPrefixLength) {
        this.maxStatsKeyPrefixLength = maxStatsKeyPrefixLength;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    @Explain(displayName="Row Limit Per Split")
    public Integer getRowLimitExplain() {
        return this.rowLimit >= 0 ? Integer.valueOf(this.rowLimit) : null;
    }

    public Map<String, Integer> getBucketFileNameMapping() {
        return this.bucketFileNameMapping;
    }

    public void setBucketFileNameMapping(Map<String, Integer> bucketFileNameMapping) {
        this.bucketFileNameMapping = bucketFileNameMapping;
    }

    public void setIsMetadataOnly(boolean metadata_only) {
        this.isMetadataOnly = metadata_only;
    }

    public boolean getIsMetadataOnly() {
        return this.isMetadataOnly;
    }

    public Table getTableMetadata() {
        return this.tableMetadata;
    }

    public TableSample getTableSample() {
        return this.tableSample;
    }

    public void setTableSample(TableSample tableSample) {
        this.tableSample = tableSample;
    }

    public boolean isNeedSkipHeaderFooters() {
        Map params;
        boolean rtn = false;
        if (this.tableMetadata != null && this.tableMetadata.getTTable() != null && (params = this.tableMetadata.getTTable().getParameters()) != null) {
            String skipHVal = (String)params.get("skip.header.line.count");
            int hcount = skipHVal == null ? 0 : Integer.parseInt(skipHVal);
            String skipFVal = (String)params.get("skip.footer.line.count");
            int fcount = skipFVal == null ? 0 : Integer.parseInt(skipFVal);
            rtn = hcount != 0 || fcount != 0;
        }
        return rtn;
    }

    static {
        PTFUtils.makeTransient(TableScanDesc.class, "filterObject", "referencedColumns", "tableMetadata");
    }
}

