/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.session;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.optimizer.lineage.LineageCtx;

public class LineageState {
    private final Map<Path, FileSinkOperator> dirToFop = new HashMap<Path, FileSinkOperator>();
    private LineageCtx.Index index;
    private final LineageInfo linfo = new LineageInfo();

    public void mapDirToFop(Path dir, FileSinkOperator fop) {
        this.dirToFop.put(dir, fop);
    }

    public void setLineage(Path dir, LineageInfo.DataContainer dc, List<FieldSchema> cols) {
        FileSinkOperator fop = this.dirToFop.get(dir);
        if (fop == null) {
            return;
        }
        ArrayList<ColumnInfo> signature = fop.getSchema().getSignature();
        int i = 0;
        for (FieldSchema fs : cols) {
            this.linfo.putDependency(dc, fs, this.index.getDependency(fop, (ColumnInfo)signature.get(i++)));
        }
    }

    public LineageInfo getLineageInfo() {
        return this.linfo;
    }

    public void setIndex(LineageCtx.Index index) {
        this.index = index;
    }

    public void clear() {
        if (this.dirToFop != null) {
            this.dirToFop.clear();
        }
        if (this.linfo != null) {
            this.linfo.clear();
        }
        if (this.index != null) {
            this.index.clear();
        }
    }
}

