/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BaseEngine;
import org.apache.oozie.BaseEngineException;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorActionInfo;
import org.apache.oozie.CoordinatorEngineException;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.CoordinatorJobInfo;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordActionInfoCommand;
import org.apache.oozie.command.coord.CoordActionInfoXCommand;
import org.apache.oozie.command.coord.CoordChangeCommand;
import org.apache.oozie.command.coord.CoordChangeXCommand;
import org.apache.oozie.command.coord.CoordJobCommand;
import org.apache.oozie.command.coord.CoordJobXCommand;
import org.apache.oozie.command.coord.CoordJobsCommand;
import org.apache.oozie.command.coord.CoordJobsXCommand;
import org.apache.oozie.command.coord.CoordKillCommand;
import org.apache.oozie.command.coord.CoordKillXCommand;
import org.apache.oozie.command.coord.CoordRerunCommand;
import org.apache.oozie.command.coord.CoordRerunXCommand;
import org.apache.oozie.command.coord.CoordResumeCommand;
import org.apache.oozie.command.coord.CoordResumeXCommand;
import org.apache.oozie.command.coord.CoordSubmitCommand;
import org.apache.oozie.command.coord.CoordSubmitXCommand;
import org.apache.oozie.command.coord.CoordSuspendCommand;
import org.apache.oozie.command.coord.CoordSuspendXCommand;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogService;
import org.apache.oozie.util.CoordActionsInDateRange;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XLogStreamer;

public class CoordinatorEngine
extends BaseEngine {
    private static boolean useXCommand = true;
    private static XLog LOG = XLog.getLog(CoordinatorEngine.class);
    private static final Set<String> FILTER_NAMES = new HashSet<String>();

    public CoordinatorEngine() {
        if (!Services.get().getConf().getBoolean("oozie.useXCommand", true)) {
            useXCommand = false;
            LOG.debug("Oozie CoordinatorEngine is not using XCommands.");
        } else {
            LOG.debug("Oozie CoordinatorEngine is using XCommands.");
        }
    }

    public CoordinatorEngine(String user, String authToken) {
        this();
        this.user = ParamChecker.notEmpty(user, "user");
        this.authToken = ParamChecker.notEmpty(authToken, "authToken");
    }

    @Override
    public String getDefinition(String jobId) throws BaseEngineException {
        CoordinatorJobBean job = this.getCoordJobWithNoActionInfo(jobId);
        return job.getOrigJobXml();
    }

    private CoordinatorJobBean getCoordJobWithNoActionInfo(String jobId) throws BaseEngineException {
        try {
            if (useXCommand) {
                return (CoordinatorJobBean)new CoordJobXCommand(jobId).call();
            }
            return (CoordinatorJobBean)new CoordJobCommand(jobId).call();
        }
        catch (CommandException ex) {
            throw new BaseEngineException(ex);
        }
    }

    public CoordinatorActionBean getCoordAction(String actionId) throws BaseEngineException {
        try {
            if (useXCommand) {
                return (CoordinatorActionBean)new CoordActionInfoXCommand(actionId).call();
            }
            return (CoordinatorActionBean)new CoordActionInfoCommand(actionId).call();
        }
        catch (CommandException ex) {
            throw new BaseEngineException(ex);
        }
    }

    @Override
    public CoordinatorJobBean getCoordJob(String jobId) throws BaseEngineException {
        try {
            if (useXCommand) {
                return (CoordinatorJobBean)new CoordJobXCommand(jobId).call();
            }
            return (CoordinatorJobBean)new CoordJobCommand(jobId).call();
        }
        catch (CommandException ex) {
            throw new BaseEngineException(ex);
        }
    }

    @Override
    public CoordinatorJobBean getCoordJob(String jobId, int start, int length) throws BaseEngineException {
        try {
            if (useXCommand) {
                return (CoordinatorJobBean)new CoordJobXCommand(jobId, start, length).call();
            }
            return (CoordinatorJobBean)new CoordJobCommand(jobId, start, length).call();
        }
        catch (CommandException ex) {
            throw new BaseEngineException(ex);
        }
    }

    @Override
    public String getJobIdForExternalId(String externalId) throws CoordinatorEngineException {
        return null;
    }

    @Override
    public void kill(String jobId) throws CoordinatorEngineException {
        try {
            if (useXCommand) {
                new CoordKillXCommand(jobId).call();
            } else {
                new CoordKillCommand(jobId).call();
            }
            LOG.info("User " + this.user + " killed the Coordinator job " + jobId);
        }
        catch (CommandException e) {
            throw new CoordinatorEngineException(e);
        }
    }

    @Override
    public void change(String jobId, String changeValue) throws CoordinatorEngineException {
        try {
            if (useXCommand) {
                new CoordChangeXCommand(jobId, changeValue).call();
            } else {
                new CoordChangeCommand(jobId, changeValue).call();
            }
            LOG.info("User " + this.user + " changed the Coordinator job " + jobId + " to " + changeValue);
        }
        catch (CommandException e) {
            throw new CoordinatorEngineException(e);
        }
    }

    @Override
    @Deprecated
    public void reRun(String jobId, Configuration conf) throws BaseEngineException {
        throw new BaseEngineException(new XException(ErrorCode.E0301, new Object[0]));
    }

    public CoordinatorActionInfo reRun(String jobId, String rerunType, String scope, boolean refresh, boolean noCleanup) throws BaseEngineException {
        try {
            if (useXCommand) {
                return (CoordinatorActionInfo)new CoordRerunXCommand(jobId, rerunType, scope, refresh, noCleanup).call();
            }
            return (CoordinatorActionInfo)new CoordRerunCommand(jobId, rerunType, scope, refresh, noCleanup).call();
        }
        catch (CommandException ex) {
            throw new BaseEngineException(ex);
        }
    }

    @Override
    public void resume(String jobId) throws CoordinatorEngineException {
        try {
            if (useXCommand) {
                new CoordResumeXCommand(jobId).call();
            } else {
                new CoordResumeCommand(jobId).call();
            }
        }
        catch (CommandException e) {
            throw new CoordinatorEngineException(e);
        }
    }

    @Override
    @Deprecated
    public void start(String jobId) throws BaseEngineException {
        throw new BaseEngineException(new XException(ErrorCode.E0301, new Object[0]));
    }

    @Override
    public void streamLog(String jobId, Writer writer) throws IOException, BaseEngineException {
        XLogStreamer.Filter filter = new XLogStreamer.Filter();
        filter.setParameter("JOB", jobId);
        CoordinatorJobBean job = this.getCoordJobWithNoActionInfo(jobId);
        Services.get().get(XLogService.class).streamLog(filter, job.getCreatedTime(), new Date(), writer);
    }

    public void streamLog(String jobId, String logRetrievalScope, String logRetrievalType, Writer writer) throws IOException, BaseEngineException, CommandException {
        XLogStreamer.Filter filter = new XLogStreamer.Filter();
        filter.setParameter("JOB", jobId);
        if (logRetrievalScope != null && logRetrievalType != null) {
            if (logRetrievalType.equals("action")) {
                String[] list;
                HashSet<String> actions = new HashSet<String>();
                for (String s : list = logRetrievalScope.split(",")) {
                    if ((s = s.trim()).contains("-")) {
                        int end;
                        String[] range = s.split("-");
                        if (range.length != 2) {
                            throw new CommandException(ErrorCode.E0302, "format is wrong for action's range '" + s + "'");
                        }
                        try {
                            int start = Integer.parseInt(range[0].trim());
                            end = Integer.parseInt(range[1].trim());
                            if (start > end) {
                                throw new CommandException(ErrorCode.E0302, "format is wrong for action's range '" + s + "'");
                            }
                        }
                        catch (NumberFormatException ne) {
                            throw new CommandException(ErrorCode.E0302, ne);
                        }
                        for (int i = start; i <= end; ++i) {
                            actions.add(jobId + "@" + i);
                        }
                        continue;
                    }
                    try {
                        Integer.parseInt(s);
                    }
                    catch (NumberFormatException ne) {
                        throw new CommandException(ErrorCode.E0302, "format is wrong for action id'" + s + "'. Integer only.");
                    }
                    actions.add(jobId + "@" + s);
                }
                Iterator actionsIterator = actions.iterator();
                StringBuilder orSeparatedActions = new StringBuilder("");
                boolean orRequired = false;
                while (actionsIterator.hasNext()) {
                    if (orRequired) {
                        orSeparatedActions.append("|");
                    }
                    orSeparatedActions.append(((String)actionsIterator.next()).toString());
                    orRequired = true;
                }
                if (actions.size() > 1 && orRequired) {
                    orSeparatedActions.insert(0, "(");
                    orSeparatedActions.append(")");
                }
                filter.setParameter("ACTION", orSeparatedActions.toString());
            }
            if (logRetrievalType.equalsIgnoreCase("date")) {
                List<CoordinatorActionBean> actionsList = null;
                try {
                    actionsList = CoordActionsInDateRange.getCoordActionsFromDates(jobId, logRetrievalScope);
                }
                catch (XException xe) {
                    throw new CommandException(ErrorCode.E0302, "Error in date range for coordinator actions", xe);
                }
                StringBuilder orSeparatedActions = new StringBuilder("");
                boolean orRequired = false;
                for (CoordinatorActionBean coordAction : actionsList) {
                    if (orRequired) {
                        orSeparatedActions.append("|");
                    }
                    orSeparatedActions.append(coordAction.getId());
                    orRequired = true;
                }
                if (actionsList.size() > 1 && orRequired) {
                    orSeparatedActions.insert(0, "(");
                    orSeparatedActions.append(")");
                }
                filter.setParameter("ACTION", orSeparatedActions.toString());
            }
        }
        CoordinatorJobBean job = this.getCoordJobWithNoActionInfo(jobId);
        Services.get().get(XLogService.class).streamLog(filter, job.getCreatedTime(), new Date(), writer);
    }

    @Override
    public String submitJob(Configuration conf, boolean startJob) throws CoordinatorEngineException {
        try {
            String jobId;
            if (useXCommand) {
                CoordSubmitXCommand submit = new CoordSubmitXCommand(conf, this.getAuthToken());
                jobId = (String)submit.call();
            } else {
                CoordSubmitCommand submit = new CoordSubmitCommand(conf, this.getAuthToken());
                jobId = (String)submit.call();
            }
            return jobId;
        }
        catch (CommandException ex) {
            throw new CoordinatorEngineException(ex);
        }
    }

    @Override
    public String dryrunSubmit(Configuration conf, boolean startJob) throws CoordinatorEngineException {
        try {
            String jobId;
            if (useXCommand) {
                CoordSubmitXCommand submit = new CoordSubmitXCommand(true, conf, this.getAuthToken());
                jobId = (String)submit.call();
            } else {
                CoordSubmitCommand submit = new CoordSubmitCommand(true, conf, this.getAuthToken());
                jobId = (String)submit.call();
            }
            return jobId;
        }
        catch (CommandException ex) {
            throw new CoordinatorEngineException(ex);
        }
    }

    @Override
    public void suspend(String jobId) throws CoordinatorEngineException {
        try {
            if (useXCommand) {
                new CoordSuspendXCommand(jobId).call();
            } else {
                new CoordSuspendCommand(jobId).call();
            }
        }
        catch (CommandException e) {
            throw new CoordinatorEngineException(e);
        }
    }

    @Override
    public WorkflowJob getJob(String jobId) throws BaseEngineException {
        throw new BaseEngineException(new XException(ErrorCode.E0301, new Object[0]));
    }

    @Override
    public WorkflowJob getJob(String jobId, int start, int length) throws BaseEngineException {
        throw new BaseEngineException(new XException(ErrorCode.E0301, new Object[0]));
    }

    public CoordinatorJobInfo getCoordJobs(String filterStr, int start, int len) throws CoordinatorEngineException {
        Map<String, List<String>> filter = this.parseFilter(filterStr);
        try {
            if (useXCommand) {
                return (CoordinatorJobInfo)new CoordJobsXCommand(filter, start, len).call();
            }
            return (CoordinatorJobInfo)new CoordJobsCommand(filter, start, len).call();
        }
        catch (CommandException ex) {
            throw new CoordinatorEngineException(ex);
        }
    }

    private Map<String, List<String>> parseFilter(String filter) throws CoordinatorEngineException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (filter != null) {
            StringTokenizer st = new StringTokenizer(filter, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.contains("=")) {
                    ArrayList<String> list;
                    String[] pair = token.split("=");
                    if (pair.length != 2) {
                        throw new CoordinatorEngineException(ErrorCode.E0420, filter, "elements must be name=value pairs");
                    }
                    if (!FILTER_NAMES.contains(pair[0])) {
                        throw new CoordinatorEngineException(ErrorCode.E0420, filter, XLog.format("invalid name [{0}]", pair[0]));
                    }
                    if (pair[0].equals("status")) {
                        try {
                            Job.Status.valueOf((String)pair[1]);
                        }
                        catch (IllegalArgumentException ex) {
                            throw new CoordinatorEngineException(ErrorCode.E0420, filter, XLog.format("invalid status [{0}]", pair[1]));
                        }
                    }
                    if ((list = (ArrayList<String>)map.get(pair[0])) == null) {
                        list = new ArrayList<String>();
                        map.put(pair[0], list);
                    }
                    list.add(pair[1]);
                    continue;
                }
                throw new CoordinatorEngineException(ErrorCode.E0420, filter, "elements must be name=value pairs");
            }
        }
        return map;
    }

    static {
        FILTER_NAMES.add("user");
        FILTER_NAMES.add("name");
        FILTER_NAMES.add("group");
        FILTER_NAMES.add("status");
        FILTER_NAMES.add("id");
        FILTER_NAMES.add("frequency");
    }
}

