/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.spark.driver;

import com.google.common.base.Enums;
import com.google.common.base.Strings;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.engine.api.reporting.LogLevel;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.pan.CommandLineOption;

public class CLI {
    private static final Class<?> PKG = CLI.class;
    private static final String SPARK = "spark";
    private static final String Y_UPPER = "Y";
    private static final String CMD_LINE_OPT_KTR_FILE = "ktrFile";
    private static final String CMD_LINE_OPT_ENGINE_ID = "engineId";
    private static final String CMD_LINE_OPT_LOG_LEVEL = "logLevel";
    private static final String CMD_LINE_OPT_RUN_IN_DRIVER = "runInDriver";
    private static final String CMD_LINE_OPT_KEEP_ALIVE = "keepAlive";
    private static final String KTR_FILE = "CLI.KtrFile";
    private static final String PLUGIN_ID = "CLI.PluginId";
    private static final String LOG_LEVEL = "CLI.LogLevel";
    private static final String RUN_IN_DRIVER = "CLI.RunInDriver";
    private static final String KEEP_PRC_RUNNING = "CLI.KeepProcessRunning";
    private final StringBuilder ktrFile = new StringBuilder();
    private final StringBuilder engine = new StringBuilder();
    private final StringBuilder logLevel = new StringBuilder();
    private final StringBuilder keepAlive = new StringBuilder();
    private final StringBuilder runInDriver = new StringBuilder();
    private final CommandLineOption[] options = new CommandLineOption[]{new CommandLineOption("ktrFile", BaseMessages.getString(PKG, (String)"CLI.KtrFile", (String[])new String[0]), this.ktrFile), new CommandLineOption("engineId", BaseMessages.getString(PKG, (String)"CLI.PluginId", (String[])new String[0]), this.engine), new CommandLineOption("logLevel", BaseMessages.getString(PKG, (String)"CLI.LogLevel", (String[])new String[0]), this.logLevel), new CommandLineOption("runInDriver", BaseMessages.getString(PKG, (String)"CLI.RunInDriver", (String[])new String[0]), this.runInDriver, true, false), new CommandLineOption("keepAlive", BaseMessages.getString(PKG, (String)"CLI.KeepProcessRunning", (String[])new String[0]), this.keepAlive, true, true)};

    public void printUsage() {
        CommandLineOption.printUsage((CommandLineOption[])this.options);
    }

    public boolean parse(List<String> args) {
        this.reset();
        return CommandLineOption.parseArguments(args, (CommandLineOption[])this.options, (LogChannelInterface)new LogChannel((Object)this));
    }

    private void reset() {
        Stream.of(this.ktrFile, this.engine, this.logLevel, this.runInDriver, this.keepAlive).forEach(builder -> builder.setLength(0));
    }

    public Optional<String> getKtrPath() {
        return Optional.of(this.ktrFile.toString()).map(Strings::emptyToNull);
    }

    public Optional<File> getKtrFile() {
        return this.getKtrPath().map(File::new).filter(File::isFile);
    }

    public String getEngine() {
        return Optional.of(this.engine.toString()).map(Strings::emptyToNull).orElse(SPARK);
    }

    public LogLevel getLogLevel() {
        return (LogLevel)Enums.getIfPresent(LogLevel.class, (String)Strings.nullToEmpty((String)this.logLevel.toString())).or((Object)LogLevel.BASIC);
    }

    public boolean keepAlive() {
        return this.getBoolean(this.keepAlive.toString());
    }

    public boolean runInDriver() {
        return this.getBoolean(this.runInDriver.toString());
    }

    private boolean getBoolean(String value) {
        return Optional.of(value).filter(Predicate.isEqual(Y_UPPER)).isPresent();
    }
}

