/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.spark.driver;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.engine.api.Engine;
import org.pentaho.di.engine.api.remote.ExecutionFetchRequest;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.pdi.spark.driver.EngineLoader;
import org.pentaho.pdi.spark.driver.RequestHandler;
import org.pentaho.pdi.spark.driver.SparkContextClientEndpoint;
import org.pentaho.pdi.spark.driver.SparkWebSocketMain;
import org.pentaho.pdi.spark.driver.UserGroupInformationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkContextDriver {
    private static final Class<?> PKG = SparkContextDriver.class;
    private static final Logger LOG = LoggerFactory.getLogger(SparkContextDriver.class);
    private static final String DRV_IDLE_TOUT_EXP = "SparkContextDriver.IdleTimeExpiredClosing";
    private static final String DRV_LIV_TOUT_EXP = "SparkContextDriver.LivingTimeExpired";
    private static final String DRV_SESS_NOT_REUSED = "SparkContextDriver.SessionNotReused";
    private static final String DRV_IDLE_TOUT_EXPIRED = "SparkContextDriver.IdleTimeExpired";
    private static final String WAIT_ACTV_JOBS_FINSH = "SparkContextDriver.WaitingActiveJobs";
    private static final String WBSCK_DRV_CLT_ENDED = "SparkContextDriver.DriverStarted";
    private static final String WBSCK_DRV_CLT_STARTED = "SparkContextDriver.StartingDriver";
    private static final String SHUTDOWN = "SparkContextDriver.ShuttingDown";
    private static final String FLD_CLS_KETTLE_ENV = "SparkContextDriver.FailedClosingEnvironment";
    private static final String CLS_KETTLE_SPARK_SESS = "SparkContextDriver.ClosingEnvironment";
    private static final String DRV_FINALIZED = "SparkContextDriver.DriverFinalized";
    private static final String ERROR_LOG = "SparkContextDriver.UnexpectedError";
    private static final String ENDED_JOB_QUEUE_SUB = "SparkContextDriver.EndedJob";
    private static final String STARTING_JOB_QUEUE_SUB = "SparkContextDriver.StartingJob";
    private static final String CTX_READY = "SparkContextDriver.ContextReady";
    private static final String STRT_CTV_INIT = "SparkContextDriver.StartingContextInit";
    private static final String WITH_SPARK_CTXT_REUSE = "SparkContextDriver.DriverWithSparkContextReuse";
    private static final String WITHOUT_SPARK_CTXT_REUSE = "SparkContextDriver.DriverWithoutSparkContextReuse";
    private static final long SESSION_MONITOR_SLEEP_TIME = 5000L;
    private static final long WAIT_FOR_FIRST_REQUEST = 30000L;
    private final SparkWebSocketMain.ArgHandler argHandler;
    private Principal principal;
    private Supplier<Engine> engineSupplier = null;
    private boolean contextReady = false;
    private boolean reuseDriverSession = false;
    private final Map<String, RequestHandler> activeJobs;
    private String userId = null;
    private volatile boolean running = false;
    private SparkContextClientEndpoint sparkContextClientEndpoint = null;
    private final CountDownLatch shutdownLock;
    private final CountDownLatch firstRequestReceive;
    private CountDownLatch activeJobsLock = null;
    private Timer idleTimer = null;
    private Timer sessionMonitor = null;

    SparkContextDriver(SparkWebSocketMain.ArgHandler args) {
        this.argHandler = args;
        this.shutdownLock = new CountDownLatch(1);
        this.firstRequestReceive = new CountDownLatch(1);
        this.activeJobs = new ConcurrentHashMap<String, RequestHandler>();
    }

    private UserGroupInformation initUserGroupInformation() {
        try {
            return UserGroupInformationHelper.getUserGroupInformation(this.getProxyingUser(), this.getProxyKeyTab(), this.getActingPrincipal(), this.isDisableProxyUser());
        }
        catch (IOException e) {
            LOG.error(BaseMessages.getString(PKG, (String)ERROR_LOG, (String[])new String[0]), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void initEngineContext(UserGroupInformation ugi) {
        try {
            ugi.doAs(() -> {
                LOG.info(BaseMessages.getString(PKG, (String)STRT_CTV_INIT, (String[])new String[0]));
                long ti = System.nanoTime();
                this.engineSupplier = EngineLoader::load;
                this.engineSupplier.get();
                new JavaSparkContext(SparkContext.getOrCreate());
                LOG.info(BaseMessages.getString(PKG, (String)CTX_READY, (Object[])new Object[]{System.nanoTime() - ti}));
                this.contextReady = true;
                return null;
            });
        }
        catch (IOException | InterruptedException e) {
            LOG.error(BaseMessages.getString(PKG, (String)ERROR_LOG, (String[])new String[0]), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void submitJobQueue() {
        LOG.info(BaseMessages.getString(PKG, (String)STARTING_JOB_QUEUE_SUB, (String[])new String[0]));
        this.sparkContextClientEndpoint.submitRequestInQueue();
        LOG.info(BaseMessages.getString(PKG, (String)ENDED_JOB_QUEUE_SUB, (String[])new String[0]));
    }

    private void sendFirstRequestToServer() {
        try {
            this.sparkContextClientEndpoint.sendMessage(new ExecutionFetchRequest(this.argHandler.requestId));
        }
        catch (Exception e) {
            LOG.error(BaseMessages.getString(PKG, (String)ERROR_LOG, (String[])new String[0]), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private synchronized void shutdown() {
        if (!this.running) {
            return;
        }
        this.running = false;
        try {
            this.sparkContextClientEndpoint.close(BaseMessages.getString(PKG, (String)DRV_FINALIZED, (String[])new String[0]));
        }
        catch (Exception e) {
            LOG.error(BaseMessages.getString(PKG, (String)ERROR_LOG, (String[])new String[0]), (Throwable)e);
        }
        if (this.engineSupplier != null) {
            this.engineSupplier.get().shutdown();
        }
        if (this.idleTimer != null) {
            this.idleTimer.cancel();
        }
        if (this.sessionMonitor != null) {
            this.sessionMonitor.cancel();
        }
        LOG.debug(BaseMessages.getString(PKG, (String)CLS_KETTLE_SPARK_SESS, (String[])new String[0]));
        try {
            KettleEnvironment.shutdown();
        }
        catch (Exception e) {
            LOG.warn(BaseMessages.getString(PKG, (String)FLD_CLS_KETTLE_ENV, (String[])new String[0]), (Throwable)e);
        }
        LOG.debug(BaseMessages.getString(PKG, (String)SHUTDOWN, (String[])new String[0]));
        System.exit(0);
    }

    protected Engine getEngine() {
        return this.engineSupplier.get();
    }

    void run() throws Exception {
        this.running = true;
        try {
            LOG.info(BaseMessages.getString(PKG, (String)WBSCK_DRV_CLT_STARTED, (String[])new String[0]));
            this.sparkContextClientEndpoint = new SparkContextClientEndpoint(this.argHandler, this);
            this.sendFirstRequestToServer();
            LOG.info(BaseMessages.getString(PKG, (String)WBSCK_DRV_CLT_ENDED, (String[])new String[0]));
            if (!this.firstRequestReceive.await(30000L, TimeUnit.MILLISECONDS)) {
                this.shutdown();
            }
            LOG.info(BaseMessages.getString(PKG, (String)(this.reuseDriverSession ? WITH_SPARK_CTXT_REUSE : WITHOUT_SPARK_CTXT_REUSE), (String[])new String[0]));
            UserGroupInformation ugi = this.initUserGroupInformation();
            this.sparkContextClientEndpoint.setUserGroupInformation(ugi);
            this.initEngineContext(ugi);
            this.submitJobQueue();
            this.startSessionMonitor();
            boolean driverLivingTimeExpired = false;
            if (this.reuseDriverSession) {
                this.startIdleMonitor();
                driverLivingTimeExpired = !this.shutdownLock.await(this.argHandler.maxDriverLivingTime, TimeUnit.MILLISECONDS);
            } else {
                this.shutdownLock.await();
            }
            if (driverLivingTimeExpired) {
                LOG.warn(BaseMessages.getString(PKG, (String)DRV_IDLE_TOUT_EXP, (Object[])new Object[]{this.argHandler.maxDriverLivingTime}));
            }
            this.sparkContextClientEndpoint.sendDriverSessionClosed(this.userId, !this.reuseDriverSession ? BaseMessages.getString(PKG, (String)DRV_SESS_NOT_REUSED, (String[])new String[0]) : (driverLivingTimeExpired ? BaseMessages.getString(PKG, (String)DRV_LIV_TOUT_EXP, (String[])new String[0]) : BaseMessages.getString(PKG, (String)DRV_IDLE_TOUT_EXPIRED, (String[])new String[0])));
            if (this.activeJobs.size() > 0) {
                LOG.warn(BaseMessages.getString(PKG, (String)WAIT_ACTV_JOBS_FINSH, (String[])new String[0]));
                this.activeJobsLock = new CountDownLatch(1);
                this.activeJobsLock.await();
            }
        }
        finally {
            this.shutdown();
        }
    }

    private void startIdleMonitor() {
        if (this.activeJobs.size() <= 0) {
            this.idleTimer = new Timer();
            this.idleTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    LOG.warn(BaseMessages.getString((Class)PKG, (String)SparkContextDriver.DRV_IDLE_TOUT_EXP, (Object[])new Object[]{((SparkContextDriver)SparkContextDriver.this).argHandler.maxDriverIdleTime}));
                    SparkContextDriver.this.shutdownLock.countDown();
                }
            }, this.argHandler.maxDriverIdleTime);
        }
    }

    private void startSessionMonitor() {
        this.sessionMonitor = new Timer();
        this.sessionMonitor.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    SparkContextDriver.this.sparkContextClientEndpoint.sessionValid();
                }
                catch (RuntimeException e) {
                    SparkContextDriver.this.shutdown();
                }
            }
        }, 0L, 5000L);
    }

    public void newExecuteRequest(RequestHandler requestMsg) {
        this.activeJobs.put(requestMsg.getRequestId(), requestMsg);
        if (this.idleTimer != null) {
            this.idleTimer.cancel();
        }
    }

    public void finishedExecutingRequest(String requestId) {
        this.activeJobs.remove(requestId);
        if (this.activeJobs.size() <= 0) {
            this.startIdleMonitor();
            if (this.activeJobsLock != null) {
                this.activeJobsLock.countDown();
            }
        }
    }

    public void unlockShutDown() {
        this.shutdownLock.countDown();
    }

    public void setDriverProperties(Principal principal, boolean reuseDriverSession) {
        this.principal = principal;
        this.reuseDriverSession = reuseDriverSession;
    }

    public void firstRequestReceived() {
        this.firstRequestReceive.countDown();
    }

    public void setUserId(String userId) {
        if (this.userId == null) {
            this.userId = userId;
        }
    }

    public boolean isContextReady() {
        return this.contextReady;
    }

    public String getProxyingUser() {
        return this.argHandler.proxyingUser;
    }

    public String getProxyKeyTab() {
        return this.argHandler.proxyKeytab;
    }

    public String getDaemonURL() {
        return this.argHandler.daemonURL;
    }

    public String getDriverSecurityKeyTab() {
        return this.argHandler.driverSecurityKeytab;
    }

    public boolean isDisableProxyUser() {
        return this.argHandler.disableProxyUser;
    }

    public String getDriverSecurityPrincipal() {
        return this.argHandler.driverSecurityPrincipal;
    }

    public int getMaxRequestThread() {
        return this.argHandler.maxRequestThreads > 0 ? this.argHandler.maxRequestThreads : 0;
    }

    public RequestHandler getRequestHandler(String requestId) {
        return this.activeJobs.get(requestId);
    }

    public Principal getActingPrincipal() {
        return this.principal;
    }
}

