/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.spark.driver;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.pdi.spark.driver.SparkContextDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkWebSocketMain {
    private static Class<?> PKG = SparkWebSocketMain.class;
    private static final Logger LOG = LoggerFactory.getLogger(SparkWebSocketMain.class);
    private static final String ARGS_STR = "ArgHandler{driverSecurityPrincipal=%s, driverSecurityKeytab=%s, requestId='%s', daemonURL='%s', proxyingUser=%s, proxyKeytab=%s, disableProxyUser=%s, driverMaxLivingTimeout=%s, driverMaxIdleTimeout=%s, maxRequestThreads=%s, driverWebsocketMaxMessageBufferSize=%s}";
    private static final String EXP_ARG_FORM = "SparkContextBootstrapper.ExpectingArgumentsOfKeyForm";
    private static final String EXP_ARG_NUMBER = "SparkContextBootstrapper.ExpectingArguments";
    private static final String MISSING_FILES = "SparkContextBootstrapper.MissingFiles";
    private static final String KRB_PRINCIPAL = "kerberosPrincipal";
    private static final String KEYYAB_PRINCIPAL = "keytabLocation";
    private static final String DRV_SEC_PRINC = "driver.security.principal";
    private static final String DRV_SEC_KYTAB = "driver.security.keytabLocation";
    private static final String DSB_PRX_USER = "disableProxyUser";
    private static final String DRV_MAX_LIV_TOUT = "driverMaxLivingTimeout";
    private static final String DRV_MAX_IDLE_TOUT = "driverMaxIdleTimeout";
    private static final String MAX_REQ_THREADS = "maxRequestThreads";
    private static final String DRV_MAX_MSG_BUFFER_SIZE = "driverWebsocketMaxMessageBufferSize";
    private static final String EQUAL = "=";
    private static final String NULL = "null";
    static final long DFT_DRV_MAX_LIV_TOUT = 3600000L;
    static final long DFT_DRV_MAX_IDLE_TOUT = 900000L;
    static final int DFT_MAX_REQ_THREADS = 0;

    private SparkWebSocketMain() {
    }

    public static void main(String[] params) throws Exception {
        ArgHandler args = new ArgHandler(params);
        LOG.debug(args.toString());
        SparkContextDriver sparkContextDriver = new SparkContextDriver(args);
        sparkContextDriver.run();
    }

    protected static class ArgHandler {
        final String driverSecurityPrincipal;
        final String driverSecurityKeytab;
        final String requestId;
        final String daemonURL;
        final String proxyingUser;
        final String proxyKeytab;
        final long maxDriverLivingTime;
        final long maxDriverIdleTime;
        final int maxRequestThreads;
        final boolean disableProxyUser;
        final int driverWebsocketMaxMessageBufferSize;
        static final int NUM_ARGS = 11;

        ArgHandler(String[] args) throws FileNotFoundException {
            this.checkArgs(args);
            this.requestId = args[0];
            this.daemonURL = args[1];
            Map<String, String> mappedParams = Arrays.stream(Arrays.copyOfRange(args, 2, 11)).collect(Collectors.toMap(this.getKey(), this.getVal()));
            this.proxyingUser = mappedParams.get(SparkWebSocketMain.KRB_PRINCIPAL);
            this.proxyKeytab = mappedParams.get(SparkWebSocketMain.KEYYAB_PRINCIPAL);
            this.driverSecurityPrincipal = mappedParams.get(SparkWebSocketMain.DRV_SEC_PRINC);
            this.driverSecurityKeytab = mappedParams.get(SparkWebSocketMain.DRV_SEC_KYTAB);
            this.disableProxyUser = Boolean.valueOf(mappedParams.get(SparkWebSocketMain.DSB_PRX_USER));
            this.maxDriverLivingTime = StringUtils.isNotBlank((String)mappedParams.get(SparkWebSocketMain.DRV_MAX_LIV_TOUT)) ? Long.valueOf(mappedParams.get(SparkWebSocketMain.DRV_MAX_LIV_TOUT)) : 3600000L;
            this.maxDriverIdleTime = StringUtils.isNotBlank((String)mappedParams.get(SparkWebSocketMain.DRV_MAX_IDLE_TOUT)) ? Long.valueOf(mappedParams.get(SparkWebSocketMain.DRV_MAX_IDLE_TOUT)) : 900000L;
            this.maxRequestThreads = StringUtils.isNotBlank((String)mappedParams.get(SparkWebSocketMain.MAX_REQ_THREADS)) ? Integer.valueOf(mappedParams.get(SparkWebSocketMain.MAX_REQ_THREADS)) : 0;
            this.driverWebsocketMaxMessageBufferSize = Integer.valueOf(mappedParams.get(SparkWebSocketMain.DRV_MAX_MSG_BUFFER_SIZE));
            this.checkFilesExistIfSpecified(this.proxyKeytab, this.driverSecurityKeytab);
        }

        private void checkFilesExistIfSpecified(String ... filenames) throws FileNotFoundException {
            List missingFiles = Arrays.stream(filenames).filter(((Predicate<String>)Strings::isNullOrEmpty).negate()).map(File::new).filter(((Predicate<File>)File::exists).negate()).collect(Collectors.toList());
            if (!missingFiles.isEmpty()) {
                throw new FileNotFoundException(BaseMessages.getString((Class)PKG, (String)SparkWebSocketMain.MISSING_FILES, (String[])new String[]{Arrays.toString(missingFiles.toArray())}));
            }
        }

        private void checkArgs(String[] args) {
            Preconditions.checkArgument((args != null && args.length == 11 ? 1 : 0) != 0, (Object)BaseMessages.getString((Class)PKG, (String)SparkWebSocketMain.EXP_ARG_NUMBER, (Object[])new Object[]{11}));
            Arrays.stream(Arrays.copyOfRange(args, 2, 11)).forEach(arg -> {
                String[] parts = arg.split(SparkWebSocketMain.EQUAL);
                Preconditions.checkArgument((parts.length == 1 || parts.length == 2 ? 1 : 0) != 0, (Object)BaseMessages.getString((Class)PKG, (String)SparkWebSocketMain.EXP_ARG_FORM, (String[])new String[0]));
            });
        }

        private Function<String, String> getKey() {
            return el -> el.split(SparkWebSocketMain.EQUAL)[0];
        }

        private Function<String, String> getVal() {
            return val -> {
                String[] parts = val.split(SparkWebSocketMain.EQUAL);
                return parts.length == 2 && !parts[1].equals(SparkWebSocketMain.NULL) ? parts[1] : "";
            };
        }

        public String toString() {
            return String.format(SparkWebSocketMain.ARGS_STR, this.driverSecurityPrincipal, this.driverSecurityKeytab, this.requestId, this.daemonURL, this.proxyingUser, this.proxyKeytab, Boolean.toString(this.disableProxyUser), this.maxDriverLivingTime, this.maxDriverIdleTime, this.maxRequestThreads, this.driverWebsocketMaxMessageBufferSize);
        }
    }
}

