/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.spark.driver;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.engine.api.Engine;
import org.pentaho.di.engine.api.model.LogicalModelElement;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.api.reporting.Metrics;
import org.pentaho.di.engine.api.reporting.Status;
import org.pentaho.di.engine.model.ActingPrincipal;
import org.pentaho.di.engine.spark.SystemManager;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.ael.adapters.TransMetaConverter;
import org.pentaho.pdi.spark.driver.CLI;

public class StandaloneSparkMain {
    private static Class<?> PKG = StandaloneSparkMain.class;
    private static SystemManager systemManager = SystemManager.getInstance();
    private static final String RUN_IN_DRIVER = "RunInDriver";
    private static final String MASTER_LOCAL = "local[*]";
    private static final String ANONYMOUS = "anonymous";
    private static final String PRINT_PATTERN = "%-32s|%10s%10s%10s%10s%n";
    private static final String STEP_ID = "Step ID";
    private static final String IN = "in";
    private static final String OUT = "out";
    private static final String DROPPED = "dropped";
    private static final String IN_FLIGHT = "inFlight";
    private static final String EVENT_PATTERN = "{0} {1}: {2}";
    private static final String USING_ENGINE = "StandaloneSparkMain.UsingEngine";
    private static final String COMPLETED = "StandaloneSparkMain.Completed";
    private static final String KTR_NOT_SPECIFIED = "StandaloneSparkMain.KtrNotSpecified";

    public static void main(String[] args) {
        CLI cli = new CLI();
        if (args.length == 0) {
            cli.printUsage();
            System.exit(2);
        } else if (cli.parse(Lists.newArrayList((Object[])args))) {
            SparkConf sparkConf = new SparkConf();
            if (cli.runInDriver()) {
                sparkConf.setAppName(RUN_IN_DRIVER).setMaster(MASTER_LOCAL);
            }
            SparkContext sparkContext = SparkContext.getOrCreate((SparkConf)sparkConf);
            CompletableFuture<Void> execute = StandaloneSparkMain.execute(cli);
            if (!cli.keepAlive()) {
                execute.whenComplete((success, error) -> {
                    Optional.ofNullable(error).ifPresent(Throwable::printStackTrace);
                    KettleEnvironment.shutdown();
                    sparkContext.stop();
                    System.exit(error == null ? 0 : 1);
                });
            }
        } else {
            System.exit(2);
        }
    }

    private static CompletableFuture<Void> execute(CLI cli) {
        String engineId = cli.getEngine();
        StandaloneSparkMain.println(BaseMessages.getString(PKG, (String)USING_ENGINE, (String[])new String[]{engineId}));
        return ((CompletableFuture)((CompletableFuture)systemManager.loadEngine(engineId).thenCombine(StandaloneSparkMain.getTransformation(cli), Engine::prepare)).thenCompose(context -> {
            context.setActingPrincipal((Principal)new ActingPrincipal(ANONYMOUS));
            context.setLoggingLogLevel(cli.getLogLevel());
            context.subscribeAll(Transformation.class, Status.class, StandaloneSparkMain::printEvent);
            context.subscribeAll(Operation.class, Status.class, StandaloneSparkMain::printEvent);
            context.subscribeAll(Operation.class, Metrics.class, StandaloneSparkMain::printEvent);
            return context.execute();
        })).thenAccept(result -> {
            StandaloneSparkMain.println(BaseMessages.getString(PKG, (String)COMPLETED, (String[])new String[0]));
            System.out.format(PRINT_PATTERN, STEP_ID, IN, OUT, DROPPED, IN_FLIGHT);
            result.getDataEventReport().forEach((operation, metrics) -> System.out.format(PRINT_PATTERN, operation.getId(), metrics.getIn(), metrics.getOut(), metrics.getDropped(), metrics.getInFlight()));
        });
    }

    private static void printEvent(LogicalModelElement src, Object event) {
        StandaloneSparkMain.println(MessageFormat.format(EVENT_PATTERN, src.getClass().getSimpleName(), src.getId(), event));
    }

    private static CompletableFuture<Transformation> getTransformation(CLI cli) {
        return CompletableFuture.runAsync(() -> ((SystemManager)systemManager).initializeOnce()).thenApply(ready -> {
            String ktrPath = cli.getKtrPath().orElseThrow(() -> new IllegalArgumentException(BaseMessages.getString(PKG, (String)KTR_NOT_SPECIFIED, (String[])new String[0])));
            try {
                return TransMetaConverter.convert((TransMeta)new TransMeta(ktrPath));
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        });
    }

    private static void println(String message) {
        System.out.println(message);
    }
}

