/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.spark.driver;

import com.google.common.base.Strings;
import java.io.IOException;
import java.security.Principal;
import org.apache.hadoop.security.UserGroupInformation;
import org.pentaho.di.engine.model.ActingPrincipal;
import org.pentaho.di.i18n.BaseMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserGroupInformationHelper {
    private static Class<?> PKG = UserGroupInformationHelper.class;
    private static final Logger LOG = LoggerFactory.getLogger(PKG);
    private static final String EXECUTING_UGI = "UserGroupInformationHelper.ExecutingUGI";

    public static UserGroupInformation getUserGroupInformation(String kerbPrincipal, String kerbKeyTab, Principal actingPrinc, boolean disableProxyUser) throws IOException {
        UserGroupInformation ugi;
        if (!Strings.isNullOrEmpty((String)kerbPrincipal) && !Strings.isNullOrEmpty((String)kerbKeyTab)) {
            ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)kerbPrincipal, (String)kerbKeyTab);
            if (!disableProxyUser && !ActingPrincipal.ANONYMOUS.equals((Object)actingPrinc)) {
                ugi = UserGroupInformation.createProxyUser((String)actingPrinc.getName(), (UserGroupInformation)ugi);
            }
        } else {
            ugi = UserGroupInformation.getCurrentUser();
        }
        LOG.debug(BaseMessages.getString(PKG, (String)EXECUTING_UGI, (String[])new String[]{ugi.toString()}));
        return ugi;
    }
}

