/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.spark.driver.app.builder;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.pentaho.pdi.spark.driver.app.builder.AppBuilderContext;
import org.pentaho.pdi.spark.driver.app.builder.ZipBuilder;

public class ArchiveBuilderFileVisitor
extends SimpleFileVisitor<Path> {
    private static final String GLOB = "glob:";
    ArchiveOutputStream os;
    AppBuilderContext context;
    Set<Path> globExclusions;
    Set<Path> pluginExclusions;

    public ArchiveBuilderFileVisitor(AppBuilderContext context, ArchiveOutputStream os) {
        this.context = context;
        this.os = os;
        this.globExclusions = Sets.newHashSet();
        this.pluginExclusions = Sets.newHashSet();
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (this.shouldExcludeDir(dir, GLOB, this.context.getExclusions())) {
            this.globExclusions.add(dir);
            return FileVisitResult.SKIP_SUBTREE;
        }
        if (this.shouldExcludeDir(dir, "glob:**/data-integration/plugins/", this.context.getPluginExclusions())) {
            this.pluginExclusions.add(dir);
            return FileVisitResult.SKIP_SUBTREE;
        }
        return FileVisitResult.CONTINUE;
    }

    private boolean shouldExcludeDir(Path dir, String patternPrefix, Set<String> exclusions) {
        for (String pattern : exclusions) {
            PathMatcher matcher = FileSystems.getDefault().getPathMatcher(patternPrefix + pattern);
            if (!matcher.matches(dir)) continue;
            return true;
        }
        return false;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (this.isFileExcluded(file)) {
            return FileVisitResult.CONTINUE;
        }
        ZipArchiveEntry entry = new ZipArchiveEntry(ZipBuilder.normalizePathForZip(file));
        entry.setUnixMode(this.getUnixMode(file));
        this.os.putArchiveEntry((ArchiveEntry)entry);
        Files.copy(file, (OutputStream)this.os);
        this.os.closeArchiveEntry();
        return FileVisitResult.CONTINUE;
    }

    int getUnixMode(Path f) {
        if (f.toFile().canExecute()) {
            return 493;
        }
        return 436;
    }

    boolean isFileExcluded(Path file) {
        for (String pattern : this.context.getExclusions()) {
            PathMatcher matcher = FileSystems.getDefault().getPathMatcher(GLOB + pattern);
            if (!matcher.matches(file)) continue;
            this.globExclusions.add(file);
            return true;
        }
        return false;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        return super.postVisitDirectory(dir, exc);
    }

    public Set<Path> getGlobExclusions() {
        return ImmutableSet.copyOf(this.globExclusions);
    }

    public Set<Path> getPluginExclusions() {
        return ImmutableSet.copyOf(this.pluginExclusions);
    }
}

