/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.spark.driver.app.builder;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.pdi.spark.driver.app.builder.AppBuilderContext;
import org.pentaho.pdi.spark.driver.app.builder.ArchiveBuilderFileVisitor;

public class ZipBuilder {
    private static final Class<?> PKG = ZipBuilder.class;
    private static final String ERROR_OUTPUT_FILE_ALREADY_EXISTS = "ERROR.OutputFileAlreadyExists";
    private static final String ERROR_FAILED_CREATING_URI = "ERROR.FailedCreatingURI";
    private static final String ERROR_FAILED_BUILD_ZIP = "ERROR.FailedToBuildZip";
    private static final String ERROR_PATH_CANT_BE_BULL = "Error.PathCantBeNull";
    private static final String ZIP = "zip";
    private static final String JAR = "jar";
    private static final String CREATE = "create";
    private static final String USE_TEMP_FILE = "useTempFile";
    private static final String DATA_INTEGRATION = "data-integration";
    private static final char SLASH = '/';
    private Map<String, Object> env = ImmutableMap.of((Object)"create", (Object)Boolean.toString(true), (Object)"useTempFile", (Object)Boolean.TRUE);
    private URI uri;
    private AppBuilderContext context;
    private File outputFile;
    private ArchiveBuilderFileVisitor visitor;
    private Map<File, String> extraFiles = Maps.newHashMap();

    public ZipBuilder(AppBuilderContext context) {
        this.context = context;
        this.outputFile = new File(context.getOutputLocation(), context.getAssemblyName());
    }

    public void compress() throws IOException {
        try {
            Files.deleteIfExists(this.outputFile.toPath());
        }
        catch (IOException e) {
            throw new IOException(BaseMessages.getString(PKG, (String)ERROR_OUTPUT_FILE_ALREADY_EXISTS, (String[])new String[]{this.outputFile.getAbsolutePath()}), e);
        }
        try {
            this.uri = new URI(JAR, this.outputFile.toURI().toString(), null);
        }
        catch (URISyntaxException e) {
            throw new IOException(BaseMessages.getString(PKG, (String)ERROR_FAILED_CREATING_URI, (String[])new String[]{this.outputFile.toURI().toString()}), e);
        }
        try (FileOutputStream fos = new FileOutputStream(this.outputFile);
             ArchiveOutputStream aos = new ArchiveStreamFactory().createArchiveOutputStream(this.getArchiveName(), (OutputStream)fos);){
            this.visitor = new ArchiveBuilderFileVisitor(this.context, aos);
            Files.walkFileTree(Paths.get(this.context.getPdiLocation().toURI()), this.visitor);
            if (this.extraFiles.size() > 0) {
                this.extraFiles.forEach((key, value) -> {
                    if (value.indexOf(47) == 0) {
                        value = value.substring(1);
                    }
                    ZipArchiveEntry extra = new ZipArchiveEntry(value);
                    if (key.canExecute()) {
                        extra.setUnixMode(493);
                    } else {
                        extra.setUnixMode(436);
                    }
                    try {
                        aos.putArchiveEntry((ArchiveEntry)extra);
                        Files.copy(key.toPath(), (OutputStream)aos);
                        aos.closeArchiveEntry();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }
        }
        catch (ArchiveException e) {
            throw new IOException(BaseMessages.getString(PKG, (String)ERROR_FAILED_BUILD_ZIP, (String[])new String[]{this.outputFile.getAbsolutePath()}), e);
        }
    }

    public void addExtraFile(File file, String locationInZip) {
        if (file != null && file.exists() && file.isFile()) {
            this.extraFiles.put(file, locationInZip);
        }
    }

    public Set<Path> getExcludedPlugins() {
        if (this.visitor != null && this.visitor.getPluginExclusions() != null) {
            return this.visitor.getPluginExclusions();
        }
        return Collections.emptySet();
    }

    public Map<File, String> getExtraFiles() {
        return ImmutableMap.copyOf(this.extraFiles);
    }

    public static String normalizePathForZip(Path path) {
        Objects.requireNonNull(path, BaseMessages.getString(PKG, (String)ERROR_PATH_CANT_BE_BULL, (String[])new String[0]));
        String filePath = path.toString();
        int index = filePath.indexOf(DATA_INTEGRATION);
        if (index >= 0) {
            return filePath.substring(index);
        }
        return filePath;
    }

    @VisibleForTesting
    String getArchiveName() {
        return ZIP;
    }
}

