/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon.emr.ui;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.eclipse.swt.widgets.Text;
import org.pentaho.amazon.AbstractAmazonJobEntry;
import org.pentaho.amazon.AbstractAmazonJobExecutorController;
import org.pentaho.amazon.emr.job.AmazonElasticMapReduceJobExecutor;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.database.dialog.tags.ExtTextbox;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;

public class AmazonElasticMapReduceJobExecutorController
extends AbstractAmazonJobExecutorController {
    private static final Class<?> PKG = AmazonElasticMapReduceJobExecutor.class;
    public static final String JAR_URL = "jarUrl";
    public static final String XUL_JAR_URL = "jar-url";
    private AmazonElasticMapReduceJobExecutor jobEntry;
    private String jarUrl = "";

    public AmazonElasticMapReduceJobExecutorController(XulDomContainer container, AbstractAmazonJobEntry jobEntry, BindingFactory bindingFactory) {
        super(container, jobEntry, bindingFactory);
        this.jobEntry = (AmazonElasticMapReduceJobExecutor)jobEntry;
        this.initializeEmrSettingsGroupMenuFields();
    }

    @Override
    protected void initializeTextFields() {
        super.initializeTextFields();
        ExtTextbox tempBox = (ExtTextbox)this.container.getDocumentRoot().getElementById(XUL_JAR_URL);
        tempBox.setVariableSpace(this.getVariableSpace());
    }

    @Override
    protected void createBindings() {
        super.createBindings();
        this.bindingFactory.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.bindingFactory.createBinding(XUL_JAR_URL, "value", (Object)this, JAR_URL, new BindingConvertor[0]);
        this.initializeTextFields();
    }

    @Override
    public String getDialogElementId() {
        return "amazon-emr-job-entry-dialog";
    }

    @Override
    protected void syncModel() {
        super.syncModel();
        ExtTextbox tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_JAR_URL);
        this.jarUrl = ((Text)tempBox.getTextControl()).getText();
    }

    @Override
    public String getJarUrl() {
        return this.jarUrl;
    }

    @Override
    public void setJarUrl(String jarUrl) {
        String previousVal = this.jarUrl;
        String newVal = jarUrl;
        this.jarUrl = jarUrl;
        this.firePropertyChange(JAR_URL, previousVal, newVal);
    }

    @Override
    protected void configureJobEntry() {
        super.configureJobEntry();
        this.jobEntry.setJarUrl(this.jarUrl);
    }

    @Override
    protected String buildValidationErrorMessages() {
        String validationErrors = super.buildValidationErrorMessages();
        if (StringUtil.isEmpty((String)this.jarUrl)) {
            validationErrors = validationErrors + BaseMessages.getString(PKG, (String)"AmazonElasticMapReduceJobExecutor.JarURL.Error", (String[])new String[0]) + "\n";
        }
        return validationErrors;
    }

    @Override
    public void init() throws XulException, InvocationTargetException {
        this.createBindings();
        super.init();
        if (this.jobEntry != null) {
            this.setJarUrl(this.jobEntry.getJarUrl());
        }
    }

    public void browseJar() throws KettleException, FileSystemException {
        String[] fileFilters = new String[]{"*.jar;*.zip"};
        String[] fileFilterNames = new String[]{"Java Archives (jar)"};
        FileSystemOptions opts = this.getFileSystemOptions();
        FileObject selectedFile = this.browse(fileFilters, fileFilterNames, this.getVariableSpace().environmentSubstitute(this.jarUrl), opts, 0, true);
        if (selectedFile != null) {
            this.setJarUrl(selectedFile.getName().getURI());
        }
    }

    @Override
    public AbstractAmazonJobEntry getJobEntry() {
        return this.jobEntry;
    }

    @Override
    public void setJobEntry(AbstractAmazonJobEntry jobEntry) {
        this.jobEntry = (AmazonElasticMapReduceJobExecutor)jobEntry;
    }
}

