/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.quotas.QuotaObserverChore;
import org.apache.hadoop.hbase.quotas.QuotaSnapshotStore;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;

public class TableQuotaSnapshotStore
implements QuotaSnapshotStore<TableName> {
    private final Connection conn;
    private final QuotaObserverChore chore;
    private final Map<HRegionInfo, Long> regionUsage;

    public TableQuotaSnapshotStore(Connection conn, QuotaObserverChore chore, Map<HRegionInfo, Long> regionUsage) {
        this.conn = Objects.requireNonNull(conn);
        this.chore = Objects.requireNonNull(chore);
        this.regionUsage = Objects.requireNonNull(regionUsage);
    }

    @Override
    public QuotaProtos.SpaceQuota getSpaceQuota(TableName subject) throws IOException {
        QuotaProtos.Quotas quotas = this.getQuotaForTable(subject);
        if (null != quotas && quotas.hasSpace()) {
            return quotas.getSpace();
        }
        return null;
    }

    QuotaProtos.Quotas getQuotaForTable(TableName table) throws IOException {
        return QuotaTableUtil.getTableQuota((Connection)this.conn, (TableName)table);
    }

    @Override
    public SpaceQuotaSnapshot getCurrentState(TableName table) {
        return this.chore.getTableQuotaViolation(table);
    }

    @Override
    public SpaceQuotaSnapshot getTargetState(TableName table, QuotaProtos.SpaceQuota spaceQuota) {
        long sizeLimitInBytes = spaceQuota.getSoftLimit();
        long sum = 0L;
        for (Map.Entry<HRegionInfo, Long> entry : this.filterBySubject(table)) {
            sum += entry.getValue().longValue();
        }
        SpaceQuotaSnapshot.SpaceQuotaStatus status = sum <= sizeLimitInBytes ? SpaceQuotaSnapshot.SpaceQuotaStatus.notInViolation() : new SpaceQuotaSnapshot.SpaceQuotaStatus(ProtobufUtil.toViolationPolicy((QuotaProtos.SpaceViolationPolicy)spaceQuota.getViolationPolicy()));
        return new SpaceQuotaSnapshot(status, sum, sizeLimitInBytes);
    }

    @Override
    public Iterable<Map.Entry<HRegionInfo, Long>> filterBySubject(final TableName table) {
        return Iterables.filter(this.regionUsage.entrySet(), (Predicate)new Predicate<Map.Entry<HRegionInfo, Long>>(){

            public boolean apply(Map.Entry<HRegionInfo, Long> input) {
                return table.equals((Object)input.getKey().getTable());
            }
        });
    }

    @Override
    public void setCurrentState(TableName table, SpaceQuotaSnapshot snapshot) {
        this.chore.setTableQuotaViolation(table, snapshot);
    }
}

