/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.regionserver.MetricsTable;
import org.apache.hadoop.hbase.regionserver.MetricsUserAggregate;

@InterfaceStability.Evolving
@InterfaceAudience.Private
public class MetricsRegionServer {
    private final MetricsRegionServerSource serverSource;
    private final MetricsRegionServerWrapper regionServerWrapper;
    private final MetricsTable metricsTable;
    private final MetricsUserAggregate userAggregate;

    public MetricsRegionServer(Configuration conf, MetricsRegionServerWrapper regionServerWrapper, MetricsTable metricsTable) {
        this(conf, regionServerWrapper, ((MetricsRegionServerSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class)).createServer(regionServerWrapper), metricsTable);
    }

    MetricsRegionServer(Configuration conf, MetricsRegionServerWrapper regionServerWrapper, MetricsRegionServerSource serverSource, MetricsTable metricsTable) {
        this.regionServerWrapper = regionServerWrapper;
        this.serverSource = serverSource;
        this.userAggregate = new MetricsUserAggregate(conf);
        this.metricsTable = metricsTable;
    }

    public MetricsRegionServerSource getMetricsSource() {
        return this.serverSource;
    }

    @VisibleForTesting
    public MetricsUserAggregate getMetricsUserAggregate() {
        return this.userAggregate;
    }

    public MetricsRegionServerWrapper getRegionServerWrapper() {
        return this.regionServerWrapper;
    }

    public void updatePut(long t) {
        if (t > 1000L) {
            this.serverSource.incrSlowPut();
        }
        this.serverSource.updatePut(t);
        this.userAggregate.updatePut(t);
    }

    public void updateDelete(long t) {
        if (t > 1000L) {
            this.serverSource.incrSlowDelete();
        }
        this.serverSource.updateDelete(t);
        this.userAggregate.updateDelete(t);
    }

    public void updateGet(long t) {
        if (t > 1000L) {
            this.serverSource.incrSlowGet();
        }
        this.serverSource.updateGet(t);
        this.userAggregate.updateGet(t);
    }

    public void updateIncrement(long t) {
        if (t > 1000L) {
            this.serverSource.incrSlowIncrement();
        }
        this.serverSource.updateIncrement(t);
        this.userAggregate.updateIncrement(t);
    }

    public void updateAppend(long t) {
        if (t > 1000L) {
            this.serverSource.incrSlowAppend();
        }
        this.serverSource.updateAppend(t);
        this.userAggregate.updateAppend(t);
    }

    public void updateReplay(long t) {
        this.serverSource.updateReplay(t);
        this.userAggregate.updateReplay(t);
    }

    public void updateScanSize(long scanSize) {
        this.serverSource.updateScanSize(scanSize);
    }

    public void updateScanTime(long t) {
        this.serverSource.updateScanTime(t);
        this.userAggregate.updateScanTime(t);
    }

    public void updateSplitTime(long t) {
        this.serverSource.updateSplitTime(t);
    }

    public void incrSplitRequest() {
        this.serverSource.incrSplitRequest();
    }

    public void incrSplitSuccess() {
        this.serverSource.incrSplitSuccess();
    }

    public void updateFlush(String table, long t, long memstoreSize, long fileSize) {
        this.serverSource.updateFlushTime(t);
        this.serverSource.updateFlushMemstoreSize(memstoreSize);
        this.serverSource.updateFlushOutputSize(fileSize);
        if (table != null) {
            this.metricsTable.updateFlushTime(table, memstoreSize);
            this.metricsTable.updateFlushMemstoreSize(table, memstoreSize);
            this.metricsTable.updateFlushOutputSize(table, fileSize);
        }
    }

    public void updateCompaction(String table, boolean isMajor, long t, int inputFileCount, int outputFileCount, long inputBytes, long outputBytes) {
        this.serverSource.updateCompactionTime(isMajor, t);
        this.serverSource.updateCompactionInputFileCount(isMajor, (long)inputFileCount);
        this.serverSource.updateCompactionOutputFileCount(isMajor, (long)outputFileCount);
        this.serverSource.updateCompactionInputSize(isMajor, inputBytes);
        this.serverSource.updateCompactionOutputSize(isMajor, outputBytes);
        if (table != null) {
            this.metricsTable.updateCompactionTime(table, isMajor, t);
            this.metricsTable.updateCompactionInputFileCount(table, isMajor, inputFileCount);
            this.metricsTable.updateCompactionOutputFileCount(table, isMajor, outputFileCount);
            this.metricsTable.updateCompactionInputSize(table, isMajor, inputBytes);
            this.metricsTable.updateCompactionOutputSize(table, isMajor, outputBytes);
        }
    }
}

