/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchException;
import org.elasticsearch.search.SearchShardTarget;

public class ShardSearchFailure
implements ShardOperationFailedException {
    private static final String REASON_FIELD = "reason";
    private static final String NODE_FIELD = "node";
    private static final String INDEX_FIELD = "index";
    private static final String SHARD_FIELD = "shard";
    public static final ShardSearchFailure[] EMPTY_ARRAY = new ShardSearchFailure[0];
    private SearchShardTarget shardTarget;
    private String reason;
    private RestStatus status;
    private Throwable cause;

    private ShardSearchFailure() {
    }

    public ShardSearchFailure(Exception e) {
        this(e, null);
    }

    public ShardSearchFailure(Exception e, @Nullable SearchShardTarget shardTarget) {
        Throwable actual = ExceptionsHelper.unwrapCause(e);
        if (actual instanceof SearchException) {
            this.shardTarget = ((SearchException)actual).shard();
        } else if (shardTarget != null) {
            this.shardTarget = shardTarget;
        }
        this.status = ExceptionsHelper.status(actual);
        this.reason = ExceptionsHelper.detailedMessage(e);
        this.cause = actual;
    }

    public ShardSearchFailure(String reason, SearchShardTarget shardTarget) {
        this(reason, shardTarget, RestStatus.INTERNAL_SERVER_ERROR);
    }

    private ShardSearchFailure(String reason, SearchShardTarget shardTarget, RestStatus status) {
        this.shardTarget = shardTarget;
        this.reason = reason;
        this.status = status;
    }

    @Nullable
    public SearchShardTarget shard() {
        return this.shardTarget;
    }

    @Override
    public RestStatus status() {
        return this.status;
    }

    @Override
    public String index() {
        if (this.shardTarget != null) {
            return this.shardTarget.getFullyQualifiedIndexName();
        }
        return null;
    }

    @Override
    public int shardId() {
        if (this.shardTarget != null) {
            return this.shardTarget.getShardId().id();
        }
        return -1;
    }

    @Override
    public String reason() {
        return this.reason;
    }

    public String toString() {
        return "shard [" + (this.shardTarget == null ? "_na" : this.shardTarget) + "], reason [" + this.reason + "], cause [" + (this.cause == null ? "_na" : ExceptionsHelper.stackTrace(this.cause)) + "]";
    }

    public static ShardSearchFailure readShardSearchFailure(StreamInput in) throws IOException {
        ShardSearchFailure shardSearchFailure = new ShardSearchFailure();
        shardSearchFailure.readFrom(in);
        return shardSearchFailure;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.shardTarget = new SearchShardTarget(in);
        }
        this.reason = in.readString();
        this.status = RestStatus.readFrom(in);
        this.cause = in.readException();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.shardTarget == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.shardTarget.writeTo(out);
        }
        out.writeString(this.reason);
        RestStatus.writeTo(out, this.status);
        out.writeException(this.cause);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(SHARD_FIELD, this.shardId());
        builder.field(INDEX_FIELD, this.index());
        if (this.shardTarget != null) {
            builder.field(NODE_FIELD, this.shardTarget.getNodeId());
        }
        if (this.cause != null) {
            builder.field(REASON_FIELD);
            builder.startObject();
            ElasticsearchException.generateThrowableXContent(builder, params, this.cause);
            builder.endObject();
        }
        return builder;
    }

    public static ShardSearchFailure fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), () -> ((XContentParser)parser).getTokenLocation());
        String currentFieldName = null;
        int shardId = -1;
        String indexName = null;
        String clusterAlias = null;
        String nodeId = null;
        ElasticsearchException exception = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (SHARD_FIELD.equals(currentFieldName)) {
                    shardId = parser.intValue();
                    continue;
                }
                if (INDEX_FIELD.equals(currentFieldName)) {
                    indexName = parser.text();
                    int indexOf = indexName.indexOf(58);
                    if (indexOf <= 0) continue;
                    clusterAlias = indexName.substring(0, indexOf);
                    indexName = indexName.substring(indexOf + 1);
                    continue;
                }
                if (NODE_FIELD.equals(currentFieldName)) {
                    nodeId = parser.text();
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (REASON_FIELD.equals(currentFieldName)) {
                    exception = ElasticsearchException.fromXContent(parser);
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            parser.skipChildren();
        }
        SearchShardTarget searchShardTarget = null;
        if (nodeId != null) {
            searchShardTarget = new SearchShardTarget(nodeId, new ShardId(new Index(indexName, "_na_"), shardId), clusterAlias, OriginalIndices.NONE);
        }
        return new ShardSearchFailure(exception, searchShardTarget);
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }
}

