/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.FilterScript;
import org.elasticsearch.script.IngestScript;
import org.elasticsearch.script.ScoreScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptedMetricAggContexts;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.script.SimilarityScript;
import org.elasticsearch.script.SimilarityWeightScript;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.search.aggregations.pipeline.movfn.MovingFunctionScript;

public class ScriptModule {
    public static final Map<String, ScriptContext<?>> CORE_CONTEXTS = Stream.of(SearchScript.CONTEXT, SearchScript.AGGS_CONTEXT, ScoreScript.CONTEXT, SearchScript.SCRIPT_SORT_CONTEXT, SearchScript.TERMS_SET_QUERY_CONTEXT, ExecutableScript.CONTEXT, ExecutableScript.AGGS_CONTEXT, ExecutableScript.UPDATE_CONTEXT, IngestScript.CONTEXT, FilterScript.CONTEXT, SimilarityScript.CONTEXT, SimilarityWeightScript.CONTEXT, TemplateScript.CONTEXT, MovingFunctionScript.CONTEXT, ScriptedMetricAggContexts.InitScript.CONTEXT, ScriptedMetricAggContexts.MapScript.CONTEXT, ScriptedMetricAggContexts.CombineScript.CONTEXT, ScriptedMetricAggContexts.ReduceScript.CONTEXT).collect(Collectors.toMap(c -> c.name, Function.identity()));
    public static final boolean EXCEPTION_FOR_MISSING_VALUE = Booleans.parseBoolean((String)System.getProperty("es.scripting.exception_for_missing_value", "false"));
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(ScriptModule.class));
    private final ScriptService scriptService;

    public ScriptModule(Settings settings, List<ScriptPlugin> scriptPlugins) {
        HashMap<String, ScriptEngine> engines = new HashMap<String, ScriptEngine>();
        HashMap contexts = new HashMap(CORE_CONTEXTS);
        for (ScriptPlugin plugin : scriptPlugins) {
            for (ScriptContext context : plugin.getContexts()) {
                ScriptContext oldContext = contexts.put(context.name, context);
                if (oldContext == null) continue;
                throw new IllegalArgumentException("Context name [" + context.name + "] defined twice");
            }
        }
        for (ScriptPlugin plugin : scriptPlugins) {
            ScriptEngine existing;
            ScriptEngine engine = plugin.getScriptEngine(settings, contexts.values());
            if (engine == null || (existing = engines.put(engine.getType(), engine)) == null) continue;
            throw new IllegalArgumentException("scripting language [" + engine.getType() + "] defined for engine [" + existing.getClass().getName() + "] and [" + engine.getClass().getName());
        }
        if (!EXCEPTION_FOR_MISSING_VALUE) {
            DEPRECATION_LOGGER.deprecated("Script: returning default values for missing document values is deprecated. Set system property '-Des.scripting.exception_for_missing_value=true' to make behaviour compatible with future major versions.", new Object[0]);
        }
        this.scriptService = new ScriptService(settings, Collections.unmodifiableMap(engines), Collections.unmodifiableMap(contexts));
    }

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    public void registerClusterSettingsListeners(ClusterSettings clusterSettings) {
        this.scriptService.registerClusterSettingsListeners(clusterSettings);
    }
}

