/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.filecache.ClientDistributedCacheManager;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.HDataType;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.JobCreationException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.DistinctCombiner;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.JobControlCompiler;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PhyPlanSetter;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigBigDecimalRawComparator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigBigIntegerRawComparator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigBooleanRawComparator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigBytesRawComparator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigCombiner;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigDateTimeRawComparator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigDoubleRawComparator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigFloatRawComparator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigIntRawComparator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigLongRawComparator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigOutputFormat;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSecondaryKeyComparator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigTextRawComparator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigTupleSortComparator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigWritableComparators;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.partitioners.SecondaryKeyPartitioner;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.EndOfAllInputSetter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.shims.HadoopShims;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezEdgeDescriptor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPOPackageAnnotator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POLocalRearrangeTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POShuffleTezLoad;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POStoreTez;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.PartitionerDefinedVertexManager;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.PigGraceShuffleVertexManager;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.PigInputFormatTez;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.PigOutputFormatTez;
import org.apache.pig.backend.hadoop.executionengine.tez.util.MRToTezHelper;
import org.apache.pig.backend.hadoop.executionengine.tez.util.SecurityHelper;
import org.apache.pig.backend.hadoop.executionengine.tez.util.TezCompilerUtil;
import org.apache.pig.backend.hadoop.executionengine.tez.util.TezUDFContextSeparator;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.io.NullablePartitionWritable;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.UDFContextSeparator;
import org.apache.pig.tools.pigstats.tez.TezScriptState;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.DataSinkDescriptor;
import org.apache.tez.dag.api.DataSourceDescriptor;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.GroupInputEdge;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.InputInitializerDescriptor;
import org.apache.tez.dag.api.OutputCommitterDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.VertexGroup;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.VertexManagerPluginDescriptor;
import org.apache.tez.dag.library.vertexmanager.ShuffleVertexManager;
import org.apache.tez.mapreduce.combine.MRCombiner;
import org.apache.tez.mapreduce.committer.MROutputCommitter;
import org.apache.tez.mapreduce.common.MRInputSplitDistributor;
import org.apache.tez.mapreduce.hadoop.InputSplitInfo;
import org.apache.tez.mapreduce.hadoop.InputSplitInfoMem;
import org.apache.tez.mapreduce.hadoop.MRHelpers;
import org.apache.tez.mapreduce.input.MRInput;
import org.apache.tez.mapreduce.output.MROutput;
import org.apache.tez.mapreduce.partition.MRPartitioner;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.library.input.ConcatenatedMergedKeyValueInput;
import org.apache.tez.runtime.library.input.OrderedGroupedKVInput;
import org.apache.tez.runtime.library.input.OrderedGroupedMergedKVInput;
import org.apache.tez.runtime.library.input.UnorderedKVInput;

public class TezDagBuilder
extends TezOpPlanVisitor {
    private static final Log log = LogFactory.getLog(TezDagBuilder.class);
    private static long SHUFFLE_BYTES_PER_REDUCER_GROUPBY_DEFAULT = 0x18000000L;
    private static long SHUFFLE_BYTES_PER_REDUCER_DEFAULT = 0x10000000L;
    private DAG dag;
    private Map<String, LocalResource> localResources;
    private PigContext pc;
    private Configuration globalConf;
    private Configuration pigContextConf;
    private Configuration shuffleVertexManagerBaseConf;
    private FileSystem fs;
    private long intermediateTaskInputSize;
    private Set<String> inputSplitInDiskVertices;
    private TezUDFContextSeparator udfContextSeparator;
    private String serializedTezPlan;
    private String serializedPigContext;
    private String serializedUDFImportList;
    private Resource mapTaskResource;
    private Resource reduceTaskResource;
    private Map<String, String> mapTaskEnv = new HashMap<String, String>();
    private Map<String, String> reduceTaskEnv = new HashMap<String, String>();
    private String mapTaskLaunchCmdOpts;
    private String reduceTaskLaunchCmdOpts;

    public TezDagBuilder(PigContext pc, TezOperPlan plan, DAG dag, Map<String, LocalResource> localResources) {
        super(plan, (PlanWalker<TezOperator, TezOperPlan>)new DependencyOrderWalker<TezOperator, TezOperPlan>(plan));
        this.pc = pc;
        this.localResources = localResources;
        this.dag = dag;
        this.inputSplitInDiskVertices = new HashSet<String>();
        try {
            this.initialize(pc);
            this.udfContextSeparator = new TezUDFContextSeparator(plan, (PlanWalker<TezOperator, TezOperPlan>)new DependencyOrderWalker<TezOperator, TezOperPlan>(plan));
            this.udfContextSeparator.visit();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void initialize(PigContext pc) throws IOException {
        int reduceVCores;
        int mapVCores;
        int reduceMemoryMB;
        int mapMemoryMB;
        this.globalConf = ConfigurationUtil.toConfiguration(pc.getProperties(), true);
        this.pigContextConf = ConfigurationUtil.toConfiguration(pc.getProperties(), false);
        MRToTezHelper.processMRSettings(this.pigContextConf, this.globalConf);
        this.shuffleVertexManagerBaseConf = new Configuration(false);
        for (Map.Entry entry : this.pigContextConf) {
            if (!((String)entry.getKey()).startsWith("tez.shuffle-vertex-manager")) continue;
            this.shuffleVertexManagerBaseConf.set((String)entry.getKey(), (String)entry.getValue());
        }
        SecurityHelper.populateTokenCache(this.globalConf, this.dag.getCredentials());
        ClientDistributedCacheManager.determineTimestampsAndCacheVisibilities((Configuration)this.globalConf);
        ClientDistributedCacheManager.getDelegationTokens((Configuration)this.globalConf, (Credentials)this.dag.getCredentials());
        MRApps.setupDistributedCache((Configuration)this.globalConf, this.localResources);
        this.dag.addTaskLocalFiles(this.localResources);
        if (this.globalConf.get("tez.task.resource.memory.mb") != null) {
            reduceMemoryMB = mapMemoryMB = this.globalConf.getInt("tez.task.resource.memory.mb", 1024);
        } else {
            mapMemoryMB = this.globalConf.getInt("mapreduce.map.memory.mb", 1024);
            reduceMemoryMB = this.globalConf.getInt("mapreduce.reduce.memory.mb", 1024);
        }
        if (this.globalConf.get("tez.task.resource.cpu.vcores") != null) {
            reduceVCores = mapVCores = this.globalConf.getInt("tez.task.resource.cpu.vcores", 1);
        } else {
            mapVCores = this.globalConf.getInt("mapreduce.map.cpu.vcores", 1);
            reduceVCores = this.globalConf.getInt("mapreduce.reduce.cpu.vcores", 1);
        }
        this.mapTaskResource = Resource.newInstance((int)mapMemoryMB, (int)mapVCores);
        this.reduceTaskResource = Resource.newInstance((int)reduceMemoryMB, (int)reduceVCores);
        if (this.globalConf.get("tez.task.launch.cmd-opts") == null) {
            MRHelpers.updateEnvBasedOnMRTaskEnv((Configuration)this.globalConf, this.mapTaskEnv, (boolean)true);
            MRHelpers.updateEnvBasedOnMRTaskEnv((Configuration)this.globalConf, this.reduceTaskEnv, (boolean)false);
        }
        if (this.globalConf.get("tez.task.launch.cmd-opts") != null) {
            this.reduceTaskLaunchCmdOpts = this.mapTaskLaunchCmdOpts = this.globalConf.get("tez.task.launch.cmd-opts");
        } else {
            this.mapTaskLaunchCmdOpts = MRHelpers.getJavaOptsForMRMapper((Configuration)this.globalConf);
            this.reduceTaskLaunchCmdOpts = MRHelpers.getJavaOptsForMRReducer((Configuration)this.globalConf);
        }
        try {
            this.fs = FileSystem.get((Configuration)this.globalConf);
            this.intermediateTaskInputSize = HadoopShims.getDefaultBlockSize(this.fs, FileLocalizer.getTemporaryResourcePath(pc));
        }
        catch (Exception e) {
            log.warn((Object)"Unable to get the block size for temporary directory, defaulting to 128MB", (Throwable)e);
            this.intermediateTaskInputSize = 0x8000000L;
        }
        this.intermediateTaskInputSize = Math.max(this.intermediateTaskInputSize, 0x8000000L);
        this.intermediateTaskInputSize = Math.min(this.intermediateTaskInputSize, this.globalConf.getLong("pig.exec.reducers.bytes.per.reducer", 1000000000L));
        this.serializedPigContext = ObjectSerializer.serialize(pc);
        this.serializedUDFImportList = ObjectSerializer.serialize(PigContext.getPackageImportList());
    }

    private String getSerializedTezPlan() throws IOException {
        if (this.serializedTezPlan == null) {
            this.serializedTezPlan = ObjectSerializer.serialize(this.getPlan());
        }
        return this.serializedTezPlan;
    }

    public void avoidContainerReuseIfInputSplitInDisk() throws IOException {
        if (!this.inputSplitInDiskVertices.isEmpty()) {
            Path jobSplitFile = new Path(FileLocalizer.getTemporaryPath(this.pc), "job.split");
            FSDataOutputStream out = this.fs.create(jobSplitFile);
            out.close();
            log.info((Object)("Creating empty job.split in " + jobSplitFile));
            FileStatus splitFileStatus = this.fs.getFileStatus(jobSplitFile);
            LocalResource localResource = LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromPath((Path)jobSplitFile), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)splitFileStatus.getLen(), (long)splitFileStatus.getModificationTime());
            for (Vertex vertex : this.dag.getVertices()) {
                if (this.inputSplitInDiskVertices.contains(vertex.getName())) continue;
                if (vertex.getTaskLocalFiles().containsKey("job.split")) {
                    throw new RuntimeException("LocalResources already contains a resource named job.split");
                }
                vertex.getTaskLocalFiles().put("job.split", localResource);
            }
        }
    }

    @Override
    public void visitTezOp(TezOperator tezOp) throws VisitorException {
        TezOperPlan tezPlan = (TezOperPlan)this.getPlan();
        List<TezOperator> predecessors = tezPlan.getPredecessors(tezOp);
        Vertex to = null;
        try {
            if (!tezOp.isVertexGroup()) {
                to = this.newVertex(tezOp);
                this.dag.addVertex(to);
            }
        }
        catch (Exception e) {
            throw new VisitorException("Cannot create vertex for " + tezOp.name(), e);
        }
        if (predecessors != null) {
            Vertex[] groupMembers = new Vertex[predecessors.size()];
            for (int i = 0; i < predecessors.size(); ++i) {
                TezOperator pred = predecessors.get(i);
                try {
                    VertexGroup from;
                    if (pred.isVertexGroup()) {
                        from = pred.getVertexGroupInfo().getVertexGroup();
                        GroupInputEdge edge = this.newGroupInputEdge((TezOperator)((TezOperPlan)this.getPlan()).getOperator(pred.getVertexGroupMembers().get(0)), tezOp, from, to);
                        this.dag.addEdge(edge);
                        continue;
                    }
                    from = this.dag.getVertex(pred.getOperatorKey().toString());
                    if (tezOp.isVertexGroup()) {
                        groupMembers[i] = from;
                        continue;
                    }
                    EdgeProperty prop = this.newEdge(pred, tezOp, false);
                    Edge edge = Edge.create((Vertex)from, (Vertex)to, (EdgeProperty)prop);
                    this.dag.addEdge(edge);
                    continue;
                }
                catch (IOException e) {
                    throw new VisitorException("Cannot create edge from " + pred.name() + " to " + tezOp.name(), e);
                }
            }
            if (tezOp.isVertexGroup()) {
                String groupName = tezOp.getOperatorKey().toString();
                VertexGroup vertexGroup = this.dag.createVertexGroup(groupName, groupMembers);
                tezOp.getVertexGroupInfo().setVertexGroup(vertexGroup);
                POStore store = tezOp.getVertexGroupInfo().getStore();
                if (store != null) {
                    String outputKey = store.getOperatorKey().toString();
                    if (store instanceof POStoreTez) {
                        outputKey = ((POStoreTez)store).getOutputKey();
                    }
                    vertexGroup.addDataSink(outputKey, DataSinkDescriptor.create((OutputDescriptor)tezOp.getVertexGroupInfo().getStoreOutputDescriptor(), (OutputCommitterDescriptor)OutputCommitterDescriptor.create((String)MROutputCommitter.class.getName()), (Credentials)this.dag.getCredentials()));
                }
            }
        }
    }

    private GroupInputEdge newGroupInputEdge(TezOperator fromOp, TezOperator toOp, VertexGroup from, Vertex to) throws IOException {
        EdgeProperty edgeProperty = this.newEdge(fromOp, toOp, true);
        String groupInputClass = ConcatenatedMergedKeyValueInput.class.getName();
        if (edgeProperty.getDataMovementType().equals((Object)EdgeProperty.DataMovementType.SCATTER_GATHER) && edgeProperty.getEdgeDestination().getClassName().equals(OrderedGroupedKVInput.class.getName())) {
            groupInputClass = OrderedGroupedMergedKVInput.class.getName();
        }
        return GroupInputEdge.create((VertexGroup)from, (Vertex)to, (EdgeProperty)edgeProperty, (InputDescriptor)((InputDescriptor)InputDescriptor.create((String)groupInputClass).setUserPayload(edgeProperty.getEdgeDestination().getUserPayload())));
    }

    private EdgeProperty newEdge(TezOperator from, TezOperator to, boolean isMergedInput) throws IOException {
        TezEdgeDescriptor edge = to.inEdges.get(from.getOperatorKey());
        PhysicalPlan combinePlan = edge.combinePlan;
        InputDescriptor in = InputDescriptor.create((String)edge.inputClassName);
        OutputDescriptor out = OutputDescriptor.create((String)edge.outputClassName);
        Configuration conf = new Configuration(this.pigContextConf);
        if (edge.needsDistinctCombiner()) {
            conf.set("tez.runtime.combiner.class", MRCombiner.class.getName());
            conf.set("mapreduce.job.combine.class", DistinctCombiner.Combine.class.getName());
            log.info((Object)("Setting distinct combiner class between " + from.getOperatorKey() + " and " + to.getOperatorKey()));
        } else if (!combinePlan.isEmpty()) {
            this.udfContextSeparator.serializeUDFContextForEdge(conf, from, to, UDFContextSeparator.UDFType.USERFUNC);
            this.addCombiner(combinePlan, to, conf, isMergedInput);
        }
        LinkedList<POLocalRearrangeTez> lrs = PlanHelper.getPhysicalOperators(from.plan, POLocalRearrangeTez.class);
        for (POLocalRearrangeTez lr : lrs) {
            if (!lr.getOutputKey().equals(to.getOperatorKey().toString())) continue;
            byte keyType = lr.getKeyType();
            this.setIntermediateOutputKeyValue(keyType, conf, to, lr.isConnectedToPackage(), isMergedInput);
            conf.set("pig.reduce.key.type", Byte.toString(lr.getMainKeyType()));
            break;
        }
        conf.setIfUnset("tez.runtime.partitioner.class", MRPartitioner.class.getName());
        if (edge.getIntermediateOutputKeyClass() != null) {
            conf.set("tez.runtime.key.class", edge.getIntermediateOutputKeyClass());
        }
        if (edge.getIntermediateOutputValueClass() != null) {
            conf.set("tez.runtime.value.class", edge.getIntermediateOutputValueClass());
        }
        if (edge.getIntermediateOutputKeyComparatorClass() != null) {
            conf.set("tez.runtime.key.comparator.class", edge.getIntermediateOutputKeyComparatorClass());
        }
        conf.setBoolean("mapred.mapper.new-api", true);
        conf.setBoolean("mapred.reducer.new-api", true);
        conf.setBoolean("pig.exectype.mode.local", this.pc.getExecType().isLocal());
        conf.set("pig.log4j.properties", ObjectSerializer.serialize(this.pc.getLog4jProperties()));
        conf.set("udf.import.list", this.serializedUDFImportList);
        if (to.isGlobalSort() || to.isLimitAfterSort()) {
            conf.set("pig.sortOrder", ObjectSerializer.serialize((Serializable)to.getSortOrder()));
        }
        if (edge.isUseSecondaryKey()) {
            conf.set("pig.secondarySortOrder", ObjectSerializer.serialize((Serializable)edge.getSecondarySortOrder()));
            conf.set("mapreduce.job.partitioner.class", SecondaryKeyPartitioner.class.getName());
            conf.set("tez.runtime.key.comparator.class", PigSecondaryKeyComparator.class.getName());
            conf.set("tez.runtime.key.class", NullableTuple.class.getName());
            this.setGroupingComparator(conf, JobControlCompiler.PigSecondaryKeyGroupComparator.class.getName());
        }
        if (edge.partitionerClass != null) {
            conf.set("mapreduce.job.partitioner.class", edge.partitionerClass.getName());
        }
        UserPayload payLoad = TezUtils.createUserPayloadFromConf((Configuration)conf);
        out.setUserPayload(payLoad);
        if (!combinePlan.isEmpty()) {
            boolean noCombineInReducer = false;
            String reducerNoCombiner = this.globalConf.get("pig.exec.nocombiner.reducer");
            noCombineInReducer = reducerNoCombiner == null || reducerNoCombiner.equals("auto") ? TezCompilerUtil.bagDataTypeInCombinePlan(combinePlan) : Boolean.parseBoolean(reducerNoCombiner);
            if (noCombineInReducer) {
                log.info((Object)("Turning off combiner in reducer vertex " + to.getOperatorKey() + " for edge from " + from.getOperatorKey()));
                conf.unset("tez.runtime.combiner.class");
                conf.unset("mapreduce.job.combine.class");
                conf.unset("pig.combinePlan");
                conf.unset("pig.combine.package");
                conf.unset("pig.map.keytype");
                payLoad = TezUtils.createUserPayloadFromConf((Configuration)conf);
            }
        }
        in.setUserPayload(payLoad);
        if (edge.dataMovementType != EdgeProperty.DataMovementType.BROADCAST && to.getEstimatedParallelism() != -1 && to.getVertexParallelism() == -1 && (to.isGlobalSort() || to.isSkewedJoin())) {
            return EdgeProperty.create((EdgeManagerPluginDescriptor)null, (EdgeProperty.DataSourceType)edge.dataSourceType, (EdgeProperty.SchedulingType)edge.schedulingType, (OutputDescriptor)out, (InputDescriptor)in);
        }
        if (to.isUseGraceParallelism()) {
            return EdgeProperty.create((EdgeManagerPluginDescriptor)null, (EdgeProperty.DataSourceType)edge.dataSourceType, (EdgeProperty.SchedulingType)edge.schedulingType, (OutputDescriptor)out, (InputDescriptor)in);
        }
        return EdgeProperty.create((EdgeProperty.DataMovementType)edge.dataMovementType, (EdgeProperty.DataSourceType)edge.dataSourceType, (EdgeProperty.SchedulingType)edge.schedulingType, (OutputDescriptor)out, (InputDescriptor)in);
    }

    private void addCombiner(PhysicalPlan combinePlan, TezOperator pkgTezOp, Configuration conf, boolean isMergedInput) throws IOException {
        POPackage combPack = (POPackage)combinePlan.getRoots().get(0);
        POLocalRearrange combRearrange = (POLocalRearrange)combinePlan.getLeaves().get(0);
        this.setIntermediateOutputKeyValue(combRearrange.getKeyType(), conf, pkgTezOp, true, isMergedInput);
        TezPOPackageAnnotator.LoRearrangeDiscoverer lrDiscoverer = new TezPOPackageAnnotator.LoRearrangeDiscoverer(combinePlan, null, pkgTezOp, combPack);
        lrDiscoverer.visit();
        combinePlan.remove(combPack);
        conf.set("tez.runtime.combiner.class", MRCombiner.class.getName());
        conf.set("mapreduce.job.combine.class", PigCombiner.Combine.class.getName());
        conf.set("pig.combinePlan", ObjectSerializer.serialize(combinePlan));
        conf.set("pig.combine.package", ObjectSerializer.serialize(combPack));
        conf.set("pig.map.keytype", ObjectSerializer.serialize((Serializable)new byte[]{combRearrange.getKeyType()}));
    }

    /*
     * WARNING - void declaration
     */
    private Vertex newVertex(TezOperator tezOp) throws IOException, ClassNotFoundException, InterruptedException {
        void var18_29;
        List roots;
        ProcessorDescriptor procDesc = ProcessorDescriptor.create((String)tezOp.getProcessorName());
        JobConf payloadConf = new JobConf(this.pigContextConf);
        payloadConf.setCredentials(this.dag.getCredentials());
        Job job = new Job((Configuration)payloadConf);
        payloadConf = (JobConf)job.getConfiguration();
        payloadConf.setBoolean("mapred.mapper.new-api", true);
        payloadConf.setBoolean("mapred.reducer.new-api", true);
        payloadConf.setClass("mapreduce.inputformat.class", PigInputFormatTez.class, InputFormat.class);
        this.setOutputFormat(job);
        payloadConf.set("udf.import.list", this.serializedUDFImportList);
        payloadConf.set("exectype", "TEZ");
        payloadConf.setBoolean("pig.exectype.mode.local", this.pc.getExecType().isLocal());
        payloadConf.set("pig.log4j.properties", ObjectSerializer.serialize(this.pc.getLog4jProperties()));
        LinkedList<POStore> stores = this.processStores(tezOp, (Configuration)payloadConf, job);
        Configuration inputPayLoad = null;
        Configuration outputPayLoad = null;
        if (!stores.isEmpty()) {
            outputPayLoad = new Configuration((Configuration)payloadConf);
            outputPayLoad.set("pig.map.stores", ObjectSerializer.serialize(new ArrayList()));
        }
        if (!tezOp.getLoaderInfo().getLoads().isEmpty()) {
            payloadConf.set("pig.inputs", ObjectSerializer.serialize(tezOp.getLoaderInfo().getInp()));
            payloadConf.set("pig.inpSignatures", ObjectSerializer.serialize(tezOp.getLoaderInfo().getInpSignatureLists()));
            payloadConf.set("pig.inpLimits", ObjectSerializer.serialize(tezOp.getLoaderInfo().getInpLimits()));
            inputPayLoad = new Configuration((Configuration)payloadConf);
        }
        if (tezOp.getSampleOperator() != null) {
            payloadConf.set("pig.sampleVertex", tezOp.getSampleOperator().getOperatorKey().toString());
        }
        if (tezOp.getSortOperator() != null) {
            payloadConf.set("pig.sortVertex", tezOp.getSortOperator().getOperatorKey().toString());
            if (tezOp.getSortOperator().getEstimatedParallelism() != -1 && tezOp.getSortOperator().isIntermediateReducer().booleanValue()) {
                payloadConf.setLong("pig.exec.reducers.bytes.per.reducer", this.intermediateTaskInputSize);
            }
        }
        new PhyPlanSetter(tezOp.plan).visit();
        EndOfAllInputSetter.EndOfAllInputChecker checker = new EndOfAllInputSetter.EndOfAllInputChecker(tezOp.plan);
        checker.visit();
        if (checker.isEndOfAllInputPresent()) {
            payloadConf.set("pig.invoke.close.in.map", "true");
        }
        if ((roots = tezOp.plan.getRoots()).size() == 1 && roots.get(0) instanceof POPackage) {
            POPackage pack = (POPackage)roots.get(0);
            List<POPackage> succsList = tezOp.plan.getSuccessors(pack);
            if (succsList != null) {
                succsList = new ArrayList<POPackage>(succsList);
            }
            byte keyType = pack.getPkgr().getKeyType();
            tezOp.plan.remove(pack);
            payloadConf.set("pig.reduce.package", ObjectSerializer.serialize(pack));
            POShuffleTezLoad newPack = new POShuffleTezLoad(pack);
            if (tezOp.isSkewedJoin()) {
                newPack.setSkewedJoins(true);
            }
            tezOp.plan.add(newPack);
            boolean isMergedInput = false;
            TreeMap<Integer, String> localRearrangeMap = new TreeMap<Integer, String>();
            Operator from = null;
            for (TezOperator tezOperator : ((TezOperPlan)this.mPlan).getPredecessors(tezOp)) {
                void var18_20;
                if (tezOp.getSampleOperator() != null && tezOp.getSampleOperator() == tezOperator) continue;
                String inputKey = tezOperator.getOperatorKey().toString();
                boolean isVertexGroup = false;
                if (tezOperator.isVertexGroup()) {
                    isVertexGroup = true;
                    TezOperator tezOperator2 = (TezOperator)((TezOperPlan)this.mPlan).getOperator(tezOperator.getVertexGroupMembers().get(0));
                }
                LinkedList<POLocalRearrangeTez> lrs = PlanHelper.getPhysicalOperators(var18_20.plan, POLocalRearrangeTez.class);
                for (POLocalRearrangeTez lr : lrs) {
                    if (!lr.isConnectedToPackage() || !lr.getOutputKey().equals(tezOp.getOperatorKey().toString())) continue;
                    localRearrangeMap.put(Integer.valueOf(lr.getIndex()), inputKey);
                    if (isVertexGroup) {
                        isMergedInput = true;
                    }
                    from = var18_20;
                }
            }
            for (Map.Entry entry : localRearrangeMap.entrySet()) {
                newPack.addInputKey((String)entry.getValue());
            }
            if (succsList != null) {
                for (PhysicalOperator physicalOperator : succsList) {
                    tezOp.plan.connect(newPack, physicalOperator);
                }
            }
            this.selectKeyComparator(keyType, (Configuration)payloadConf, tezOp, isMergedInput);
            if (tezOp.isUseSecondaryKey()) {
                TezEdgeDescriptor edge = tezOp.inEdges.get(from.getOperatorKey());
                payloadConf.set("pig.secondarySortOrder", ObjectSerializer.serialize((Serializable)edge.getSecondarySortOrder()));
            }
        }
        new PhyPlanSetter(tezOp.plan).visit();
        payloadConf.set("pig.exec.tez.plan", ObjectSerializer.serialize(tezOp.plan));
        this.udfContextSeparator.serializeUDFContext((Configuration)payloadConf, tezOp);
        if (!this.pc.inIllustrator) {
            for (POStore store : stores) {
                store.setInputs(null);
                store.setParentPlan(null);
            }
            payloadConf.set("pig.map.stores", ObjectSerializer.serialize(new ArrayList()));
            payloadConf.set("pig.reduce.stores", ObjectSerializer.serialize(stores));
        }
        if (tezOp.isNeedEstimateParallelism()) {
            payloadConf.setBoolean("pig.exec.estimate.parallelism", true);
            log.info((Object)("Estimate quantile for sample aggregation vertex " + tezOp.getOperatorKey().toString()));
        }
        payloadConf.setInt("pig.info.reducers.default.parallel", this.pc.defaultParallel);
        payloadConf.setInt("pig.info.reducers.requested.parallel", tezOp.getRequestedParallelism());
        payloadConf.setInt("pig.info.reducers.estimated.parallel", tezOp.getEstimatedParallelism());
        TezScriptState ss = TezScriptState.get();
        ss.addVertexSettingsToConf(this.dag.getName(), tezOp, (Configuration)payloadConf);
        UserPayload userPayload = TezUtils.createUserPayloadFromConf((Configuration)payloadConf);
        TezScriptState.TezDAGScriptInfo dagScriptInfo = TezScriptState.get().getDAGScriptInfo(this.dag.getName());
        String alias = dagScriptInfo.getAlias(tezOp);
        String aliasLocation = dagScriptInfo.getAliasLocation(tezOp);
        String features = dagScriptInfo.getPigFeatures(tezOp);
        String vertexInfo = aliasLocation + " (" + features + ")";
        ((ProcessorDescriptor)procDesc.setUserPayload(userPayload)).setHistoryText(TezUtils.convertToHistoryText((String)vertexInfo, (Configuration)payloadConf));
        String vmPluginName = null;
        Object var18_27 = null;
        boolean containScatterGather = false;
        boolean containCustomPartitioner = false;
        for (TezEdgeDescriptor edge : tezOp.inEdges.values()) {
            if (edge.dataMovementType == EdgeProperty.DataMovementType.SCATTER_GATHER) {
                containScatterGather = true;
            }
            if (edge.partitionerClass == null) continue;
            containCustomPartitioner = true;
        }
        if (containScatterGather) {
            vmPluginName = ShuffleVertexManager.class.getName();
            Configuration configuration = new Configuration(this.shuffleVertexManagerBaseConf);
        }
        if (tezOp.getEstimatedParallelism() != -1) {
            if (tezOp.isGlobalSort() || tezOp.isSkewedJoin()) {
                if (tezOp.getVertexParallelism() == -1 && (tezOp.isGlobalSort() && ((TezOperPlan)this.getPlan()).getPredecessors(tezOp).size() == 1 || tezOp.isSkewedJoin() && ((TezOperPlan)this.getPlan()).getPredecessors(tezOp).size() == 2)) {
                    vmPluginName = PartitionerDefinedVertexManager.class.getName();
                    log.info((Object)("Set VertexManagerPlugin to PartitionerDefinedParallelismVertexManager for vertex " + tezOp.getOperatorKey().toString()));
                }
            } else if (containScatterGather && !containCustomPartitioner) {
                long bytesPerReducer = this.intermediateTaskInputSize;
                if (stores.size() > 0) {
                    bytesPerReducer = this.pigContextConf.get("pig.exec.reducers.bytes.per.reducer") != null ? this.pigContextConf.getLong("pig.exec.reducers.bytes.per.reducer", 1000000000L) : (tezOp.isGroupBy() ? SHUFFLE_BYTES_PER_REDUCER_GROUPBY_DEFAULT : SHUFFLE_BYTES_PER_REDUCER_DEFAULT);
                }
                if (payloadConf.getBoolean("pig.tez.grace.parallelism", true) && !TezOperPlan.getGrandParentsForGraceParallelism((TezOperPlan)this.getPlan(), tezOp).isEmpty() && tezOp.getCrossKeys() == null) {
                    vmPluginName = PigGraceShuffleVertexManager.class.getName();
                    tezOp.setUseGraceParallelism(true);
                    var18_29.set("pig.tez.plan", this.getSerializedTezPlan());
                    var18_29.set("pig.pigContext", this.serializedPigContext);
                    var18_29.setLong("pig.exec.reducers.bytes.per.reducer", bytesPerReducer);
                }
                var18_29.setBoolean("tez.shuffle-vertex-manager.enable.auto-parallel", true);
                var18_29.setLong("tez.shuffle-vertex-manager.desired-task-input-size", bytesPerReducer);
                log.info((Object)("Set auto parallelism for vertex " + tezOp.getOperatorKey().toString()));
            }
        }
        if (tezOp.isLimit() && (vmPluginName == null || vmPluginName.equals(PigGraceShuffleVertexManager.class.getName()) || vmPluginName.equals(ShuffleVertexManager.class.getName())) && tezOp.inEdges.values().iterator().next().inputClassName.equals(UnorderedKVInput.class.getName())) {
            Configuration configuration = var18_29 == null ? new Configuration(this.pigContextConf) : var18_29;
            configuration.set("tez.shuffle-vertex-manager.min-src-fraction", "0.00001");
            configuration.set("tez.shuffle-vertex-manager.max-src-fraction", "0.00001");
            log.info((Object)("Set tez.shuffle-vertex-manager.min-src-fraction to 0.00001 for limit vertex " + tezOp.getOperatorKey().toString()));
        }
        int parallel = tezOp.getVertexParallelism();
        if (tezOp.isUseGraceParallelism()) {
            parallel = -1;
        }
        Resource resource = tezOp.isUseMRMapSettings() ? this.mapTaskResource : this.reduceTaskResource;
        Vertex vertex = Vertex.create((String)tezOp.getOperatorKey().toString(), (ProcessorDescriptor)procDesc, (int)parallel, (Resource)resource);
        if (tezOp.isUseMRMapSettings()) {
            vertex.setTaskLaunchCmdOpts(this.mapTaskLaunchCmdOpts);
            vertex.setTaskEnvironment(this.mapTaskEnv);
        } else {
            vertex.setTaskLaunchCmdOpts(this.reduceTaskLaunchCmdOpts);
            vertex.setTaskEnvironment(this.reduceTaskEnv);
        }
        MRToTezHelper.setVertexConfig(vertex, tezOp.isUseMRMapSettings(), this.globalConf);
        log.info((Object)("For vertex - " + tezOp.getOperatorKey().toString() + ": parallelism=" + tezOp.getVertexParallelism() + ", memory=" + vertex.getTaskResource().getMemory() + ", java opts=" + vertex.getTaskLaunchCmdOpts()));
        log.info((Object)("Processing aliases: " + alias));
        log.info((Object)("Detailed locations: " + aliasLocation));
        log.info((Object)("Pig features in the vertex: " + features));
        for (POLoad ld : tezOp.getLoaderInfo().getLoads()) {
            MRRuntimeProtos.MRInputUserPayloadProto.Builder userPayLoadBuilder = MRRuntimeProtos.MRInputUserPayloadProto.newBuilder();
            InputSplitInfo inputSplitInfo = tezOp.getLoaderInfo().getInputSplitInfo();
            HashMap<String, LocalResource> additionalLocalResources = null;
            int spillThreshold = payloadConf.getInt("pig.tez.input.splits.mem.threshold", 0x2000000);
            if (inputSplitInfo instanceof InputSplitInfoMem) {
                MRRuntimeProtos.MRSplitsProto splitsProto = inputSplitInfo.getSplitsProto();
                int splitsSerializedSize = splitsProto.getSerializedSize();
                if (splitsSerializedSize > spillThreshold) {
                    inputPayLoad.setBoolean("mapreduce.tez.splits.via.events", false);
                    Path inputSplitsDir = FileLocalizer.getTemporaryPath(this.pc);
                    log.info((Object)("Writing input splits to " + inputSplitsDir + " for vertex " + vertex.getName() + " as the serialized size in memory is " + splitsSerializedSize + ". Configured " + "pig.tez.input.splits.mem.threshold" + " is " + spillThreshold));
                    inputSplitInfo = MRToTezHelper.writeInputSplitInfoToDisk((InputSplitInfoMem)inputSplitInfo, inputSplitsDir, payloadConf, this.fs);
                    additionalLocalResources = new HashMap<String, LocalResource>();
                    MRToTezHelper.updateLocalResourcesForInputSplits(this.fs, inputSplitInfo, additionalLocalResources);
                    this.inputSplitInDiskVertices.add(vertex.getName());
                } else {
                    userPayLoadBuilder.setSplits(splitsProto);
                }
                tezOp.getLoaderInfo().setInputSplitInfo(null);
            }
            this.udfContextSeparator.serializeUDFContext(inputPayLoad, tezOp, UDFContextSeparator.UDFType.LOADFUNC);
            userPayLoadBuilder.setConfigurationBytes(TezUtils.createByteStringFromConf((Configuration)inputPayLoad));
            vertex.setLocationHint(VertexLocationHint.create((List)inputSplitInfo.getTaskLocationHints()));
            vertex.addDataSource(ld.getOperatorKey().toString(), DataSourceDescriptor.create((InputDescriptor)((InputDescriptor)InputDescriptor.create((String)MRInput.class.getName()).setUserPayload(UserPayload.create((ByteBuffer)userPayLoadBuilder.build().toByteString().asReadOnlyByteBuffer()))), (InputInitializerDescriptor)InputInitializerDescriptor.create((String)MRInputSplitDistributor.class.getName()), (int)inputSplitInfo.getNumTasks(), (Credentials)this.dag.getCredentials(), null, additionalLocalResources));
        }
        HashSet<String> uniqueStoreOutputs = new HashSet<String>();
        for (POStore store : stores) {
            OperatorKey vertexGroupKey;
            ArrayList<POStore> singleStore = new ArrayList<POStore>();
            singleStore.add(store);
            Configuration outPayLoad = new Configuration(outputPayLoad);
            this.udfContextSeparator.serializeUDFContext(outPayLoad, tezOp, store);
            outPayLoad.set("pig.reduce.stores", ObjectSerializer.serialize(singleStore));
            OutputDescriptor storeOutDescriptor = (OutputDescriptor)OutputDescriptor.create((String)MROutput.class.getName()).setUserPayload(TezUtils.createUserPayloadFromConf((Configuration)outPayLoad));
            if (tezOp.getVertexGroupStores() != null && (vertexGroupKey = tezOp.getVertexGroupStores().get(store.getOperatorKey())) != null) {
                ((TezOperator)((TezOperPlan)this.getPlan()).getOperator(vertexGroupKey)).getVertexGroupInfo().setStoreOutputDescriptor(storeOutDescriptor);
                continue;
            }
            String outputKey = ((POStoreTez)store).getOutputKey();
            if (uniqueStoreOutputs.contains(outputKey)) continue;
            vertex.addDataSink(outputKey.toString(), DataSinkDescriptor.create((OutputDescriptor)storeOutDescriptor, (OutputCommitterDescriptor)OutputCommitterDescriptor.create((String)MROutputCommitter.class.getName()), (Credentials)this.dag.getCredentials()));
            uniqueStoreOutputs.add(outputKey);
        }
        if (stores.size() > 0) {
            new PigOutputFormat().checkOutputSpecs((JobContext)job);
        }
        if (vmPluginName != null) {
            void var18_31;
            VertexManagerPluginDescriptor vmPluginDescriptor = VertexManagerPluginDescriptor.create((String)vmPluginName);
            if (var18_31 != null) {
                vmPluginDescriptor.setUserPayload(TezUtils.createUserPayloadFromConf((Configuration)var18_31));
            }
            vertex.setVertexManagerPlugin(vmPluginDescriptor);
        }
        UDFContext.getUDFContext().addJobConf(null);
        return vertex;
    }

    private LinkedList<POStore> processStores(TezOperator tezOp, Configuration payloadConf, Job job) throws VisitorException, IOException {
        LinkedList<POStore> stores = PlanHelper.getPhysicalOperators(tezOp.plan, POStore.class);
        if (stores.size() > 0) {
            ArrayList<POStore> storeLocations = new ArrayList<POStore>();
            for (POStore st : stores) {
                storeLocations.add(st);
                StoreFuncInterface sFunc = st.getStoreFunc();
                sFunc.setStoreLocation(st.getSFile().getFileName(), job);
            }
            Path tmpLocation = null;
            if (stores.size() == 1) {
                POStore st;
                st = stores.get(0);
                String outputPathString = st.getSFile().getFileName();
                if (!outputPathString.contains("://") || outputPathString.startsWith("hdfs://")) {
                    payloadConf.set("pig.streaming.log.dir", new Path(outputPathString, "_logs").toString());
                } else {
                    String tmpLocationStr = FileLocalizer.getTemporaryPath(this.pc).toString();
                    tmpLocation = new Path(tmpLocationStr);
                    payloadConf.set("pig.streaming.log.dir", new Path(tmpLocation, "_logs").toString());
                }
                payloadConf.set("pig.streaming.task.output.dir", outputPathString);
                if (tezOp.plan.getLeaves().get(0) instanceof POSplit) {
                    st.setMultiStore(true);
                }
            } else {
                log.info((Object)"Setting up multi store job");
                String tmpLocationStr = FileLocalizer.getTemporaryPath(this.pc).toString();
                tmpLocation = new Path(tmpLocationStr);
                boolean disableCounter = payloadConf.getBoolean("pig.disable.counter", false);
                if (disableCounter) {
                    log.info((Object)"Disable Pig custom output counters");
                }
                int idx = 0;
                for (POStore sto : storeLocations) {
                    sto.setDisableCounter(disableCounter);
                    sto.setMultiStore(true);
                    sto.setIndex(idx++);
                }
                payloadConf.set("pig.streaming.log.dir", new Path(tmpLocation, "_logs").toString());
                payloadConf.set("pig.streaming.task.output.dir", tmpLocation.toString());
            }
        }
        return stores;
    }

    private void setIntermediateOutputKeyValue(byte keyType, Configuration conf, TezOperator tezOp, boolean isConnectedToPackage, boolean isMergedInput) throws JobCreationException, ExecException {
        if (tezOp != null && tezOp.isUseSecondaryKey() && isConnectedToPackage) {
            conf.set("tez.runtime.key.class", NullableTuple.class.getName());
        } else if (tezOp != null && tezOp.isSkewedJoin() && isConnectedToPackage) {
            conf.set("tez.runtime.key.class", NullablePartitionWritable.class.getName());
        } else {
            Class<?> keyClass = HDataType.getWritableComparableTypes(keyType).getClass();
            conf.set("tez.runtime.key.class", keyClass.getName());
        }
        conf.set("tez.runtime.value.class", NullableTuple.class.getName());
        conf.set("tez.runtime.partitioner.class", MRPartitioner.class.getName());
        this.selectKeyComparator(keyType, conf, tezOp, isMergedInput);
    }

    private static Class<? extends WritableComparator> getRawBytesComparator(byte keyType) throws JobCreationException {
        switch (keyType) {
            case 5: {
                return PigWritableComparators.PigBooleanRawBytesComparator.class;
            }
            case 10: {
                return PigWritableComparators.PigIntRawBytesComparator.class;
            }
            case 65: {
                return PigWritableComparators.PigBigIntegerRawBytesComparator.class;
            }
            case 70: {
                return PigWritableComparators.PigBigDecimalRawBytesComparator.class;
            }
            case 15: {
                return PigWritableComparators.PigLongRawBytesComparator.class;
            }
            case 20: {
                return PigWritableComparators.PigFloatRawBytesComparator.class;
            }
            case 25: {
                return PigWritableComparators.PigDoubleRawBytesComparator.class;
            }
            case 30: {
                return PigWritableComparators.PigDateTimeRawBytesComparator.class;
            }
            case 55: {
                return PigWritableComparators.PigTextRawBytesComparator.class;
            }
            case 50: {
                return PigWritableComparators.PigBytesRawBytesComparator.class;
            }
            case 100: {
                int errCode = 1068;
                String msg = "Using Map as key not supported.";
                throw new JobCreationException(msg, errCode, 2);
            }
            case 110: {
                return PigWritableComparators.PigTupleSortBytesComparator.class;
            }
            case 120: {
                int errCode = 1068;
                String msg = "Using Bag as key not supported.";
                throw new JobCreationException(msg, errCode, 2);
            }
        }
        int errCode = 2036;
        String msg = "Unhandled key type " + DataType.findTypeName(keyType);
        throw new JobCreationException(msg, errCode, 4);
    }

    private static Class<? extends WritableComparator> getRawComparator(byte keyType) throws JobCreationException {
        switch (keyType) {
            case 5: {
                return PigBooleanRawComparator.class;
            }
            case 10: {
                return PigIntRawComparator.class;
            }
            case 65: {
                return PigBigIntegerRawComparator.class;
            }
            case 70: {
                return PigBigDecimalRawComparator.class;
            }
            case 15: {
                return PigLongRawComparator.class;
            }
            case 20: {
                return PigFloatRawComparator.class;
            }
            case 25: {
                return PigDoubleRawComparator.class;
            }
            case 30: {
                return PigDateTimeRawComparator.class;
            }
            case 55: {
                return PigTextRawComparator.class;
            }
            case 50: {
                return PigBytesRawComparator.class;
            }
            case 100: {
                int errCode = 1068;
                String msg = "Using Map as key not supported.";
                throw new JobCreationException(msg, errCode, 2);
            }
            case 110: {
                return PigTupleSortComparator.class;
            }
            case 120: {
                int errCode = 1068;
                String msg = "Using Bag as key not supported.";
                throw new JobCreationException(msg, errCode, 2);
            }
        }
        int errCode = 2036;
        String msg = "Unhandled key type " + DataType.findTypeName(keyType);
        throw new JobCreationException(msg, errCode, 4);
    }

    private static Class<? extends WritableComparator> getRawBytesComparatorForSkewedJoin(byte keyType) throws JobCreationException {
        switch (keyType) {
            case 5: {
                return PigWritableComparators.PigBooleanRawBytesPartitionComparator.class;
            }
            case 10: {
                return PigWritableComparators.PigIntRawBytesPartitionComparator.class;
            }
            case 65: {
                return PigWritableComparators.PigBigIntegerRawBytesPartitionComparator.class;
            }
            case 70: {
                return PigWritableComparators.PigBigDecimalRawBytesPartitionComparator.class;
            }
            case 15: {
                return PigWritableComparators.PigLongRawBytesPartitionComparator.class;
            }
            case 20: {
                return PigWritableComparators.PigFloatRawBytesPartitionComparator.class;
            }
            case 25: {
                return PigWritableComparators.PigDoubleRawBytesPartitionComparator.class;
            }
            case 30: {
                return PigWritableComparators.PigDateTimeRawBytesPartitionComparator.class;
            }
            case 55: {
                return PigWritableComparators.PigTextRawBytesPartitionComparator.class;
            }
            case 50: {
                return PigWritableComparators.PigBytesRawBytesPartitionComparator.class;
            }
            case 100: {
                int errCode = 1068;
                String msg = "Using Map as key not supported.";
                throw new JobCreationException(msg, errCode, 2);
            }
            case 110: {
                return PigWritableComparators.PigTupleSortBytesPartitionComparator.class;
            }
            case 120: {
                int errCode = 1068;
                String msg = "Using Bag as key not supported.";
                throw new JobCreationException(msg, errCode, 2);
            }
        }
        int errCode = 2036;
        String msg = "Unhandled key type " + DataType.findTypeName(keyType);
        throw new JobCreationException(msg, errCode, 4);
    }

    private static Class<? extends WritableComparator> getRawComparatorForSkewedJoin(byte keyType) throws JobCreationException {
        switch (keyType) {
            case 5: {
                return PigWritableComparators.PigBooleanRawPartitionComparator.class;
            }
            case 10: {
                return PigWritableComparators.PigIntRawPartitionComparator.class;
            }
            case 65: {
                return PigWritableComparators.PigBigIntegerRawPartitionComparator.class;
            }
            case 70: {
                return PigWritableComparators.PigBigDecimalRawPartitionComparator.class;
            }
            case 15: {
                return PigWritableComparators.PigLongRawPartitionComparator.class;
            }
            case 20: {
                return PigWritableComparators.PigFloatRawPartitionComparator.class;
            }
            case 25: {
                return PigWritableComparators.PigDoubleRawPartitionComparator.class;
            }
            case 30: {
                return PigWritableComparators.PigDateTimeRawPartitionComparator.class;
            }
            case 55: {
                return PigWritableComparators.PigTextRawPartitionComparator.class;
            }
            case 50: {
                return PigWritableComparators.PigBytesRawPartitionComparator.class;
            }
            case 100: {
                int errCode = 1068;
                String msg = "Using Map as key not supported.";
                throw new JobCreationException(msg, errCode, 2);
            }
            case 110: {
                return PigWritableComparators.PigTupleSortPartitionComparator.class;
            }
            case 120: {
                int errCode = 1068;
                String msg = "Using Bag as key not supported.";
                throw new JobCreationException(msg, errCode, 2);
            }
        }
        int errCode = 2036;
        String msg = "Unhandled key type " + DataType.findTypeName(keyType);
        throw new JobCreationException(msg, errCode, 4);
    }

    void selectKeyComparator(byte keyType, Configuration conf, TezOperator tezOp, boolean isMergedInput) throws JobCreationException {
        if (tezOp == null) {
            return;
        }
        if (tezOp.isUseSecondaryKey()) {
            conf.set("tez.runtime.key.comparator.class", PigSecondaryKeyComparator.class.getName());
            this.setGroupingComparator(conf, JobControlCompiler.PigSecondaryKeyGroupComparator.class.getName());
        } else if (!isMergedInput && (tezOp.isGroupBy() || tezOp.isDistinct())) {
            conf.setClass("tez.runtime.key.comparator.class", TezDagBuilder.getRawBytesComparator(keyType), RawComparator.class);
        } else if (tezOp.isSkewedJoin()) {
            conf.setClass("tez.runtime.key.comparator.class", TezDagBuilder.getRawComparatorForSkewedJoin(keyType), RawComparator.class);
        } else {
            conf.setClass("tez.runtime.key.comparator.class", TezDagBuilder.getRawComparator(keyType), RawComparator.class);
        }
    }

    private boolean hasOrderby(TezOperator tezOp) {
        List<TezOperator> succs;
        boolean hasOrderBy;
        boolean bl = hasOrderBy = tezOp.isGlobalSort() || tezOp.isLimitAfterSort();
        if (!hasOrderBy && (succs = ((TezOperPlan)this.getPlan()).getSuccessors(tezOp)) != null && succs.size() == 1 && succs.get(0).isGlobalSort()) {
            hasOrderBy = true;
        }
        return hasOrderBy;
    }

    private void setGroupingComparator(Configuration conf, String comparatorClass) {
        conf.set("tez.runtime.group.comparator.class", comparatorClass);
        conf.set("tez.runtime.key.secondary.comparator.class", comparatorClass);
    }

    private void setOutputFormat(Job job) {
        if ("true".equalsIgnoreCase(job.getConfiguration().get("pig.output.lazy"))) {
            try {
                Class clazz = PigContext.resolveClassName("org.apache.hadoop.mapreduce.lib.output.LazyOutputFormat");
                Method method = clazz.getMethod("setOutputFormatClass", Job.class, Class.class);
                method.invoke(null, job, PigOutputFormatTez.class);
            }
            catch (Exception e) {
                job.setOutputFormatClass(PigOutputFormatTez.class);
                log.warn((Object)"pig.output.lazy is set but LazyOutputFormat couldn't be loaded. Default PigOutputFormat will be used");
            }
        } else {
            job.setOutputFormatClass(PigOutputFormatTez.class);
        }
    }
}

