/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.openflashchart.factory;

import java.text.MessageFormat;
import java.text.NumberFormat;
import ofc4j.model.elements.ScatterChart;
import org.dom4j.Node;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.plugin.action.openflashchart.factory.AbstractChartFactory;

public class DotChartFactory
extends AbstractChartFactory {
    private static final String DOT_WIDTH_NODE_LOC = "dot-width";
    private static final String DOT_LABEL_CONTENT_NODE_LOC = "dot-label-content";
    private Integer dotwidth;

    @Override
    public void validateData() {
        super.validateData();
        if (this.getColumnCount() < 2) {
            throw new RuntimeException(Messages.getInstance().getErrorString("DotChartFactory.ERROR_0001_XY_COLUMN_COUNT"));
        }
    }

    @Override
    protected void createElements() {
        for (int row = 0; row < this.getRowCount(); ++row) {
            Node temp;
            ScatterChart e = null;
            String text = this.getRowHeader(row);
            ScatterChart sc = new ScatterChart("");
            sc.setColour(this.getColor(row));
            Number x = (Number)this.getValueAt(row, 0);
            Number y = (Number)this.getValueAt(row, 1);
            if (this.dotwidth != null) {
                sc.setDotSize(this.dotwidth);
            }
            if (DotChartFactory.getValue(temp = this.chartNode.selectSingleNode(DOT_LABEL_CONTENT_NODE_LOC)) != null) {
                sc.setTooltip(MessageFormat.format(DotChartFactory.getValue(temp), text, NumberFormat.getInstance().format(x), NumberFormat.getInstance().format(y)));
            } else {
                sc.setTooltip(MessageFormat.format("{0}: {1}, {2}", text, NumberFormat.getInstance().format(x), NumberFormat.getInstance().format(y)));
            }
            sc.addPoint((Number)x.doubleValue(), (Number)y.doubleValue());
            if (this.alpha != null) {
                sc.setAlpha(this.alpha);
            }
            e = sc;
            e.setText(text);
            this.elements.add(e);
        }
    }

    @Override
    protected void setupStyles() {
        super.setupStyles();
        Node temp = this.chartNode.selectSingleNode(DOT_WIDTH_NODE_LOC);
        if (DotChartFactory.getValue(temp) != null) {
            this.dotwidth = Integer.parseInt(DotChartFactory.getValue(temp));
        }
    }
}

