/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model.table.columns;

import org.pentaho.reporting.engine.classic.core.layout.model.Border;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderLength;
import org.pentaho.reporting.engine.classic.core.util.LongList;

public class TableColumn {
    private Border border;
    private RenderLength definedWidth;
    private long effectiveSize;
    private LongList cachedSize;
    private boolean autoGenerated;
    private boolean validated;

    public TableColumn(Border border, RenderLength definedWidth, boolean autoGenerated) {
        if (border == null) {
            throw new NullPointerException();
        }
        if (definedWidth == null) {
            throw new NullPointerException();
        }
        this.definedWidth = definedWidth;
        this.border = border;
        this.autoGenerated = autoGenerated;
        this.cachedSize = new LongList(10);
    }

    public RenderLength getDefinedWidth() {
        return this.definedWidth;
    }

    public Border getBorder() {
        return this.border;
    }

    public long getEffectiveSize() {
        return this.effectiveSize;
    }

    public void setEffectiveSize(long effectiveSize) {
        this.effectiveSize = effectiveSize;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void setValidated(boolean validated) {
        this.validated = validated;
    }

    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public void setCachedSize(int colSpan, long size) {
        int idx = colSpan - 1;
        if (this.getCachedSize(colSpan) < size) {
            this.cachedSize.set(idx, size);
        }
    }

    public long getCachedSize(int colspan) {
        int idx = colspan - 1;
        if (idx < this.cachedSize.size()) {
            return this.cachedSize.get(idx);
        }
        return 0L;
    }

    public int getMaxColspan() {
        return this.cachedSize.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TableColumn");
        sb.append("{validated=").append(this.validated);
        sb.append(", autoGenerated=").append(this.autoGenerated);
        sb.append(", effectiveSize=").append(this.effectiveSize);
        sb.append(", definedWidth=").append(this.definedWidth);
        sb.append(", border=").append(this.border);
        sb.append(", cachedSize=").append(this.cachedSize);
        sb.append('}');
        return sb.toString();
    }
}

