/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.compat.CompatibilityMapperUtil;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.AbstractObjectDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectFactoryException;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ClassLoaderObjectDescription
extends AbstractObjectDescription {
    private static final Class[] EMPTY_PARAMS = new Class[0];

    public ClassLoaderObjectDescription() {
        super(Object.class);
        this.setParameterDefinition("class", String.class);
    }

    @Override
    public Object createObject() {
        try {
            String o = (String)this.getParameter("class");
            return ObjectUtilities.loadAndInstantiate((String)CompatibilityMapperUtil.mapClassName(o), this.getClass(), null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setParameterFromObject(Object o) throws ObjectFactoryException {
        if (o == null) {
            throw new ObjectFactoryException("The Object is null.");
        }
        try {
            Constructor<?> c = o.getClass().getConstructor(EMPTY_PARAMS);
            if (!Modifier.isPublic(c.getModifiers())) {
                throw new ObjectFactoryException("The given object has no public default constructor. [" + o.getClass() + ']');
            }
            this.setParameter("class", o.getClass().getName());
        }
        catch (Exception e) {
            throw new ObjectFactoryException("The given object has no default constructor. [" + o.getClass() + ']', e);
        }
    }
}

