/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.microsoft.azure.storage;

import java.io.IOException;
import java.net.SocketException;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.OperationContext;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageErrorCode;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageExtendedErrorInformation;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.StorageRequest;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.Utility;

public class StorageException
extends Exception {
    private static final long serialVersionUID = 7972747254288274928L;
    protected String errorCode;
    protected StorageExtendedErrorInformation extendedErrorInformation;
    private final int httpStatusCode;

    public static StorageException translateClientException(Exception cause) {
        return new StorageException("Client error", "A Client side exception occurred, please check the inner exception for details", 306, null, cause);
    }

    public static StorageException translateException(StorageRequest<?, ?, ?> request, Exception cause, OperationContext opContext) {
        StorageExtendedErrorInformation extendedError;
        if (request == null || request.getConnection() == null) {
            return StorageException.translateClientException(cause);
        }
        if (cause instanceof SocketException) {
            String message = cause == null ? "" : cause.getMessage();
            return new StorageException(StorageErrorCode.SERVICE_INTERNAL_ERROR.toString(), "An unknown failure occurred : ".concat(message), 500, null, cause);
        }
        StorageException translatedException = null;
        String responseMessage = null;
        int responseCode = 0;
        try {
            responseCode = request.getConnection().getResponseCode();
            responseMessage = request.getConnection().getResponseMessage();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (responseMessage == null) {
            responseMessage = "";
        }
        if ((translatedException = (extendedError = request.parseErrorDetails()) != null ? new StorageException(extendedError.getErrorCode(), responseMessage, responseCode, extendedError, cause) : StorageException.translateFromHttpStatus(responseCode, responseMessage, cause)) != null) {
            Utility.logHttpError(translatedException, opContext);
            return translatedException;
        }
        return new StorageException(StorageErrorCode.SERVICE_INTERNAL_ERROR.toString(), "The server encountered an unknown failure: ".concat(responseMessage), 500, null, cause);
    }

    protected static StorageException translateFromHttpStatus(int statusCode, String statusDescription, Exception inner) {
        String errorCode;
        switch (statusCode) {
            case 403: {
                errorCode = StorageErrorCode.ACCESS_DENIED.toString();
                break;
            }
            case 404: 
            case 410: {
                errorCode = StorageErrorCode.RESOURCE_NOT_FOUND.toString();
                break;
            }
            case 400: 
            case 416: {
                errorCode = StorageErrorCode.BAD_REQUEST.toString();
                break;
            }
            case 304: 
            case 412: {
                errorCode = StorageErrorCode.CONDITION_FAILED.toString();
                break;
            }
            case 409: {
                errorCode = StorageErrorCode.RESOURCE_ALREADY_EXISTS.toString();
                break;
            }
            case 503: {
                errorCode = StorageErrorCode.SERVER_BUSY.toString();
                break;
            }
            case 504: {
                errorCode = StorageErrorCode.SERVICE_TIMEOUT.toString();
                break;
            }
            case 500: {
                errorCode = StorageErrorCode.SERVICE_INTERNAL_ERROR.toString();
                break;
            }
            case 501: {
                errorCode = StorageErrorCode.NOT_IMPLEMENTED.toString();
                break;
            }
            case 502: {
                errorCode = StorageErrorCode.BAD_GATEWAY.toString();
                break;
            }
            case 505: {
                errorCode = StorageErrorCode.HTTP_VERSION_NOT_SUPPORTED.toString();
                break;
            }
            default: {
                errorCode = null;
            }
        }
        if (errorCode == null) {
            return null;
        }
        return new StorageException(errorCode, statusDescription, statusCode, null, inner);
    }

    public StorageException(String errorCode, String message, Exception innerException) {
        this(errorCode, message, 306, null, innerException);
    }

    public StorageException(String errorCode, String message, int statusCode, StorageExtendedErrorInformation extendedErrorInfo, Exception innerException) {
        super(message, innerException);
        this.errorCode = errorCode;
        this.httpStatusCode = statusCode;
        this.extendedErrorInformation = extendedErrorInfo;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public StorageExtendedErrorInformation getExtendedErrorInformation() {
        return this.extendedErrorInformation;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }
}

