/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repo.controller;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.apache.commons.lang.ClassUtils;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.util.ExecutorUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.AbstractRepository;
import org.pentaho.di.repository.ReconnectableRepository;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.database.dialog.DatabaseDialog;
import org.pentaho.di.ui.repo.IConnectedRepositoryInstance;
import org.pentaho.di.ui.repo.model.RepositoryModel;
import org.pentaho.di.ui.repo.timeout.RepositorySessionTimeoutHandler;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.util.HelpUtils;

public class RepositoryConnectController
implements IConnectedRepositoryInstance {
    public static final String DISPLAY_NAME = "displayName";
    public static final String DESCRIPTION = "description";
    public static final String IS_DEFAULT = "isDefault";
    public static final String URL = "url";
    public static final String DATABASE_CONNECTION = "databaseConnection";
    public static final String SHOW_HIDDEN_FOLDERS = "showHiddenFolders";
    public static final String LOCATION = "location";
    public static final String DO_NOT_MODIFY = "doNotModify";
    public static final String ORIGINAL_NAME = "originalName";
    public static final String DEFAULT_URL = "defaultUrl";
    public static final String ERROR_401 = "401";
    private static Class<?> PKG = RepositoryConnectController.class;
    private static LogChannelInterface log = KettleLogStore.getLogChannelInterfaceFactory().create(RepositoryConnectController.class);
    public static final String HELP_URL = Const.getDocUrl((String)BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.Help", (String[])new String[0]));
    private RepositoryMeta currentRepository;
    private RepositoryMeta connectedRepository;
    private RepositoriesMeta repositoriesMeta;
    private PluginRegistry pluginRegistry;
    private Supplier<Spoon> spoonSupplier;
    private List<RepositoryContollerListener> listeners = new ArrayList<RepositoryContollerListener>();
    private boolean relogin = false;
    private Shell parentShell;

    public RepositoryConnectController(PluginRegistry pluginRegistry, Supplier<Spoon> spoonSupplier, RepositoriesMeta repositoriesMeta) {
        this.pluginRegistry = pluginRegistry;
        this.spoonSupplier = spoonSupplier;
        this.repositoriesMeta = repositoriesMeta;
        try {
            repositoriesMeta.readData();
        }
        catch (KettleException ke) {
            log.logError("Unable to load repositories", (Throwable)ke);
        }
    }

    public RepositoryConnectController() {
        this(PluginRegistry.getInstance(), Spoon::getInstance, new RepositoriesMeta());
    }

    public void setParentShell(Shell shell) {
        this.parentShell = shell;
    }

    public Shell getParentShell() {
        return this.parentShell;
    }

    public boolean help() {
        this.spoonSupplier.get().getShell().getDisplay().asyncExec(() -> HelpUtils.openHelpDialog((Shell)this.parentShell, (String)BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.Tile", (String[])new String[0]), (String)HELP_URL, (String)BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.Header", (String[])new String[0])));
        return true;
    }

    public String createConnection() {
        CompletableFuture future = new CompletableFuture();
        this.spoonSupplier.get().getShell().getDisplay().asyncExec(() -> {
            DatabaseDialog databaseDialog = new DatabaseDialog(this.spoonSupplier.get().getShell(), new DatabaseMeta());
            databaseDialog.open();
            DatabaseMeta databaseMeta = databaseDialog.getDatabaseMeta();
            if (databaseMeta != null) {
                if (!this.isDatabaseWithNameExist(databaseMeta, true)) {
                    this.addDatabase(databaseMeta);
                    future.complete(databaseMeta.getName());
                } else {
                    DatabaseDialog.showDatabaseExistsDialog((Shell)this.spoonSupplier.get().getShell(), (DatabaseMeta)databaseMeta);
                }
            }
            future.complete("None");
        });
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put((Object)"name", future.get());
            return jsonObject.toJSONString();
        }
        catch (Exception e) {
            jsonObject.put((Object)"name", (Object)"None");
            return jsonObject.toJSONString();
        }
    }

    public String editDatabaseConnection(String database) {
        CompletableFuture future = new CompletableFuture();
        this.spoonSupplier.get().getShell().getDisplay().asyncExec(() -> {
            DatabaseMeta databaseMeta = this.getDatabase(database);
            String originalName = databaseMeta.getName();
            DatabaseDialog databaseDialog = new DatabaseDialog(this.spoonSupplier.get().getShell(), databaseMeta);
            databaseDialog.open();
            if (!this.isDatabaseWithNameExist(databaseMeta, false)) {
                this.save();
                future.complete(databaseMeta.getName());
            } else {
                DatabaseDialog.showDatabaseExistsDialog((Shell)this.spoonSupplier.get().getShell(), (DatabaseMeta)databaseMeta);
                databaseMeta.setName(originalName);
                databaseMeta.setDisplayName(originalName);
                future.complete(originalName);
            }
        });
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put((Object)"name", future.get());
            return jsonObject.toJSONString();
        }
        catch (Exception e) {
            jsonObject.put((Object)"name", (Object)"None");
            return jsonObject.toJSONString();
        }
    }

    public boolean deleteDatabaseConnection(String database) {
        CompletableFuture future = new CompletableFuture();
        this.spoonSupplier.get().getShell().getDisplay().asyncExec(() -> {
            this.removeDatabase(database);
            future.complete(true);
        });
        try {
            return (Boolean)future.get();
        }
        catch (Exception e) {
            return false;
        }
    }

    public String browse() {
        Spoon spoon = this.spoonSupplier.get();
        CompletableFuture name = new CompletableFuture();
        Runnable execute = () -> {
            DirectoryDialog directoryDialog = new DirectoryDialog(this.spoonSupplier.get().getShell());
            name.complete(directoryDialog.open());
        };
        if (spoon.getShell() != null) {
            spoon.getShell().getDisplay().asyncExec(execute);
        } else {
            execute.run();
        }
        try {
            return (String)name.get();
        }
        catch (Exception e) {
            return "/";
        }
    }

    public String getPlugins() {
        List plugins = this.pluginRegistry.getPlugins(RepositoryPluginType.class);
        JSONArray list = new JSONArray();
        for (PluginInterface pluginInterface : plugins) {
            if (pluginInterface.getIds()[0].equals("PentahoEnterpriseRepository")) continue;
            JSONObject repoJSON = new JSONObject();
            repoJSON.put((Object)"id", (Object)pluginInterface.getIds()[0]);
            repoJSON.put((Object)"name", (Object)pluginInterface.getName());
            repoJSON.put((Object)DESCRIPTION, (Object)pluginInterface.getDescription());
            list.add((Object)repoJSON);
        }
        return list.toString();
    }

    public boolean updateRepository(String id, Map<String, Object> items) {
        RepositoryMeta repositoryMeta = this.repositoriesMeta.findRepository((String)items.get(ORIGINAL_NAME));
        boolean isConnected = repositoryMeta == this.connectedRepository;
        repositoryMeta.populate(items, this.repositoriesMeta);
        this.save();
        if (isConnected) {
            Spoon spoon = this.spoonSupplier.get();
            Runnable execute = () -> {
                spoon.setRepositoryName(repositoryMeta.getName());
                this.fireListeners();
            };
            if (spoon.getShell() != null) {
                spoon.getShell().getDisplay().asyncExec(execute);
            } else {
                execute.run();
            }
        }
        try {
            Repository repository = (Repository)this.pluginRegistry.loadClass(RepositoryPluginType.class, repositoryMeta.getId(), Repository.class);
            repository.init(repositoryMeta);
            if (!this.testRepository(repository)) {
                return false;
            }
        }
        catch (KettleException e) {
            return false;
        }
        this.currentRepository = repositoryMeta;
        return true;
    }

    public RepositoryMeta createRepository(String id, Map<String, Object> items) {
        RepositoryMeta repositoryMeta;
        try {
            repositoryMeta = (RepositoryMeta)this.pluginRegistry.loadClass(RepositoryPluginType.class, id, RepositoryMeta.class);
            repositoryMeta.populate(items, this.repositoriesMeta);
            if (repositoryMeta.getName() != null) {
                Repository repository = (Repository)this.pluginRegistry.loadClass(RepositoryPluginType.class, repositoryMeta.getId(), Repository.class);
                repository.init(repositoryMeta);
                this.repositoriesMeta.addRepository(repositoryMeta);
                this.repositoriesMeta.writeData();
                this.currentRepository = repositoryMeta;
                if (!this.testRepository(repository)) {
                    return null;
                }
                ((AbstractRepository)repository).create();
            }
        }
        catch (KettleException ke) {
            log.logError("Unable to load repository type", (Throwable)ke);
            return null;
        }
        return repositoryMeta;
    }

    private boolean repositoryEquals(RepositoryMeta repo1, RepositoryMeta repo2) {
        return repo1.toJSONObject().equals((Object)repo2.toJSONObject());
    }

    public String getRepositories() {
        String connected = null;
        if (this.spoonSupplier.get() != null && this.spoonSupplier.get().rep != null) {
            connected = this.spoonSupplier.get().rep.getName();
        }
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        if (this.repositoriesMeta != null) {
            for (int i = 0; i < this.repositoriesMeta.nrRepositories(); ++i) {
                RepositoryMeta repositoryMeta = this.repositoriesMeta.getRepository(i);
                JSONObject repoJson = repositoryMeta.toJSONObject();
                if (connected != null && repositoryMeta.getName().equals(connected)) {
                    repoJson.put((Object)"connected", (Object)true);
                }
                list.add(repoJson);
            }
        }
        return ((Object)list).toString();
    }

    public String getRepository(String name) {
        RepositoryMeta repositoryMeta = this.repositoriesMeta.findRepository(name);
        if (repositoryMeta != null) {
            this.currentRepository = repositoryMeta;
            return repositoryMeta.toJSONObject().toString();
        }
        return "";
    }

    public DatabaseMeta getDatabase(String name) {
        return this.repositoriesMeta.searchDatabase(name);
    }

    public void removeDatabase(String name) {
        int index = this.repositoriesMeta.indexOfDatabase(this.repositoriesMeta.searchDatabase(name));
        if (index != -1) {
            this.repositoriesMeta.removeDatabase(index);
        }
        this.save();
    }

    public String getDatabases() {
        JSONArray list = new JSONArray();
        for (int i = 0; i < this.repositoriesMeta.nrDatabases(); ++i) {
            JSONObject databaseJSON = new JSONObject();
            databaseJSON.put((Object)"name", (Object)this.repositoriesMeta.getDatabase(i).getName());
            list.add((Object)databaseJSON);
        }
        return list.toString();
    }

    public void connectToRepository() throws KettleException {
        this.connectToRepository(this.currentRepository);
    }

    public void connectToRepository(RepositoryMeta repositoryMeta) throws KettleException {
        this.connectToRepository(repositoryMeta, null, null);
    }

    public void connectToRepository(String repositoryName, String username, String password) throws KettleException {
        RepositoryMeta repositoryMeta = this.repositoriesMeta.findRepository(repositoryName);
        if (repositoryMeta != null) {
            this.connectToRepository(repositoryMeta, username, password);
        }
    }

    public void connectToRepository(RepositoryMeta repositoryMeta, String username, String password) throws KettleException {
        Repository repository = this.loadRepositoryObject(repositoryMeta.getId());
        repository.init(repositoryMeta);
        this.repositoryConnect(repository, username, password);
        if (username != null) {
            this.getPropsUI().setLastRepositoryLogin(username);
        }
        Spoon spoon = this.spoonSupplier.get();
        Runnable execute = () -> {
            if (spoon.getRepository() != null) {
                spoon.closeRepository();
            } else {
                spoon.closeAllJobsAndTransformations(true);
            }
            spoon.setRepository(repository);
            this.setConnectedRepository(repositoryMeta);
            this.fireListeners();
        };
        if (spoon.getShell() != null) {
            spoon.getShell().getDisplay().asyncExec(execute);
        } else {
            execute.run();
        }
    }

    private Repository loadRepositoryObject(String id) throws KettleException {
        Repository repository = (Repository)this.pluginRegistry.loadClass(RepositoryPluginType.class, id, Repository.class);
        if (repository instanceof ReconnectableRepository) {
            repository = this.wrapWithRepositoryTimeoutHandler((ReconnectableRepository)repository);
        }
        return repository;
    }

    public void reconnectToRepository(String repositoryName, String username, String password) throws KettleException {
        RepositoryMeta repositoryMeta = this.repositoriesMeta.findRepository(repositoryName);
        if (repositoryMeta != null) {
            this.currentRepository = repositoryMeta;
            this.reconnectToRepository(username, password);
        }
    }

    public void reconnectToRepository(String username, String password) throws KettleException {
        Repository currentRepositoryInstance = this.getConnectedRepositoryInstance();
        this.reconnectToRepository(this.currentRepository, (ReconnectableRepository)currentRepositoryInstance, username, password);
    }

    private void reconnectToRepository(RepositoryMeta repositoryMeta, ReconnectableRepository repository, String username, String password) throws KettleException {
        if (username != null) {
            this.getPropsUI().setLastRepositoryLogin(username);
        }
        if (repository.isConnected()) {
            repository.disconnect();
        }
        repository.init(repositoryMeta);
        this.repositoryConnect((Repository)repository, username, password);
    }

    private void repositoryConnect(Repository repository, String username, String password) throws KettleException {
        ExecutorService executorService = ExecutorUtil.getExecutor();
        Future<KettleException> future = executorService.submit(() -> {
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(Trans.class.getClassLoader());
                repository.connect(username, password);
            }
            catch (KettleException e) {
                KettleException kettleException = e;
                return kettleException;
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
            return null;
        });
        try {
            KettleException exception = future.get();
            if (exception != null) {
                throw exception;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new KettleException();
        }
    }

    private boolean testRepository(Repository repository) {
        ExecutorService executorService = ExecutorUtil.getExecutor();
        Future<Boolean> future = executorService.submit(() -> {
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(Trans.class.getClassLoader());
                Boolean bl = ((AbstractRepository)repository).test();
                return bl;
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return false;
        }
    }

    public boolean deleteRepository(String name) {
        RepositoryMeta repositoryMeta = this.repositoriesMeta.findRepository(name);
        int index = this.repositoriesMeta.indexOfRepository(repositoryMeta);
        if (index != -1) {
            this.repositoriesMeta.removeRepository(index);
            this.save();
            Spoon spoon = this.spoonSupplier.get();
            Runnable execute = () -> {
                if (spoon.getRepositoryName() != null && spoon.getRepositoryName().equals(repositoryMeta.getName())) {
                    spoon.closeRepository();
                    this.setConnectedRepository(null);
                }
                this.fireListeners();
            };
            if (spoon.getShell() != null) {
                spoon.getShell().getDisplay().asyncExec(execute);
            } else {
                execute.run();
            }
        }
        return true;
    }

    public void addDatabase(DatabaseMeta databaseMeta) {
        if (databaseMeta != null) {
            this.repositoriesMeta.addDatabase(databaseMeta);
            this.save();
        }
    }

    public boolean setDefaultRepository(String name) {
        for (int i = 0; i < this.repositoriesMeta.nrRepositories(); ++i) {
            RepositoryMeta repositoryMeta = this.repositoriesMeta.getRepository(i);
            repositoryMeta.setDefault(Boolean.valueOf(repositoryMeta.getName().equals(name)));
        }
        try {
            this.repositoriesMeta.writeData();
        }
        catch (KettleException ke) {
            log.logError("Unable to set default repository", (Throwable)ke);
            return false;
        }
        return true;
    }

    public boolean clearDefaultRepository() {
        for (int i = 0; i < this.repositoriesMeta.nrRepositories(); ++i) {
            this.repositoriesMeta.getRepository(i).setDefault(Boolean.valueOf(false));
        }
        try {
            this.repositoriesMeta.writeData();
        }
        catch (KettleException ke) {
            log.logError("Unable to set default repository", (Throwable)ke);
            return false;
        }
        return true;
    }

    public String getCurrentUser() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"username", (Object)this.getPropsUI().getLastRepositoryLogin());
        return jsonObject.toJSONString();
    }

    public void setCurrentRepository(RepositoryMeta repositoryMeta) {
        this.currentRepository = repositoryMeta;
    }

    public RepositoryMeta getCurrentRepository() {
        return this.currentRepository;
    }

    public RepositoryMeta getConnectedRepository() {
        return this.connectedRepository;
    }

    public void setConnectedRepository(RepositoryMeta connectedRepository) {
        this.connectedRepository = connectedRepository;
    }

    public RepositoryMeta getDefaultRepositoryMeta() {
        for (int i = 0; i < this.repositoriesMeta.nrRepositories(); ++i) {
            RepositoryMeta repositoryMeta = this.repositoriesMeta.getRepository(i);
            if (!repositoryMeta.isDefault().booleanValue()) continue;
            return repositoryMeta;
        }
        return null;
    }

    public RepositoryMeta getRepositoryMetaByName(String name) {
        return this.repositoriesMeta.findRepository(name);
    }

    public boolean isConnected(String name) {
        if (this.spoonSupplier.get().rep != null) {
            return this.spoonSupplier.get().rep.getName().equals(name);
        }
        return false;
    }

    public boolean isConnected() {
        return this.spoonSupplier.get().rep != null;
    }

    @Override
    public Repository getConnectedRepositoryInstance() {
        return this.spoonSupplier.get().rep;
    }

    public void save() {
        try {
            this.repositoriesMeta.writeData();
        }
        catch (KettleException ke) {
            log.logError("Unable to write to repositories", (Throwable)ke);
        }
    }

    private Repository wrapWithRepositoryTimeoutHandler(ReconnectableRepository repository) {
        List repositoryIntrerfaces = ClassUtils.getAllInterfaces(repository.getClass());
        Class[] repositoryIntrerfacesArray = repositoryIntrerfaces.toArray(new Class[repositoryIntrerfaces.size()]);
        return (Repository)Proxy.newProxyInstance(repository.getClass().getClassLoader(), repositoryIntrerfacesArray, (InvocationHandler)new RepositorySessionTimeoutHandler(repository, this));
    }

    public boolean checkDuplicate(String name) {
        return this.repositoriesMeta.findRepository(name) != null;
    }

    public PropsUI getPropsUI() {
        return PropsUI.getInstance();
    }

    public void addListener(RepositoryContollerListener listener) {
        this.listeners.add(listener);
    }

    public void fireListeners() {
        for (RepositoryContollerListener listener : this.listeners) {
            listener.update();
        }
    }

    public boolean isRelogin() {
        return this.relogin;
    }

    public void setRelogin(boolean relogin) {
        this.relogin = relogin;
    }

    public Map<String, Object> modelToMap(RepositoryModel model) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(DISPLAY_NAME, model.getDisplayName());
        properties.put(DESCRIPTION, model.getDescription());
        properties.put(IS_DEFAULT, model.getIsDefault());
        properties.put(URL, model.getUrl());
        properties.put(DATABASE_CONNECTION, model.getDatabaseConnection());
        properties.put(SHOW_HIDDEN_FOLDERS, model.getShowHiddenFolders());
        properties.put(LOCATION, model.getLocation());
        properties.put(DO_NOT_MODIFY, model.getDoNotModify());
        properties.put(ORIGINAL_NAME, model.getOriginalName());
        return properties;
    }

    @VisibleForTesting
    boolean isDatabaseWithNameExist(DatabaseMeta databaseMeta, boolean isNew) {
        for (int i = 0; i < this.repositoriesMeta.nrDatabases(); ++i) {
            DatabaseMeta iterDatabase = this.repositoriesMeta.getDatabase(i);
            if (!iterDatabase.getName().trim().equalsIgnoreCase(databaseMeta.getName().trim()) || !isNew && databaseMeta == iterDatabase) continue;
            return true;
        }
        return false;
    }

    public static interface RepositoryContollerListener {
        public void update();
    }
}

