/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repo.dialog;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.ui.core.dialog.ThinDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.repo.controller.RepositoryConnectController;
import org.pentaho.platform.settings.ServerPort;
import org.pentaho.platform.settings.ServerPortRegistry;

public class RepositoryDialog
extends ThinDialog {
    private LogChannelInterface log = KettleLogStore.getLogChannelInterfaceFactory().create(RepositoryDialog.class);
    private static Class<?> PKG = RepositoryDialog.class;
    private static final int WIDTH = 630;
    private static final int HEIGHT = 630;
    private static final int OPTIONS = 67680;
    private static final String CREATION_TITLE = BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.NewRepo.Title", (String[])new String[0]);
    private static final String CREATION_WEB_CLIENT_PATH = "#/add";
    private static final String MANAGER_TITLE = BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.Manager.Title", (String[])new String[0]);
    private static final String LOGIN_TITLE = BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.Login.Title", (String[])new String[0]);
    private static final String LOGIN_WEB_CLIENT_PATH = "#/connect";
    private static final String OSGI_SERVICE_PORT = "OSGI_SERVICE_PORT";
    private static final Image LOGO = GUIResource.getInstance().getImageLogoSmall();
    private RepositoryConnectController controller;
    private Shell shell;
    private boolean result = false;

    public RepositoryDialog(Shell shell, RepositoryConnectController controller) {
        super(shell, 630, 630);
        this.controller = controller;
        this.shell = shell;
    }

    private boolean open() {
        return this.open(null);
    }

    private boolean open(RepositoryMeta repositoryMeta) {
        return this.open(repositoryMeta, false, null);
    }

    private boolean open(RepositoryMeta repositoryMeta, boolean relogin, String errorMessage) {
        new BrowserFunction(this.browser, "closeWindow"){

            public Object function(Object[] arguments) {
                RepositoryDialog.this.browser.dispose();
                RepositoryDialog.this.dialog.close();
                RepositoryDialog.this.dialog.dispose();
                return true;
            }
        };
        this.controller.setCurrentRepository(repositoryMeta);
        this.controller.setRelogin(relogin);
        this.controller.setParentShell(this.dialog);
        while (!this.dialog.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        return this.result;
    }

    public void openManager() {
        super.createDialog(MANAGER_TITLE, RepositoryDialog.getRepoURL(""), 67680, LOGO);
        this.open();
    }

    public void openCreation() {
        super.createDialog(CREATION_TITLE, RepositoryDialog.getRepoURL(CREATION_WEB_CLIENT_PATH), 67680, LOGO);
        this.open();
    }

    public boolean openRelogin(RepositoryMeta repositoryMeta, String errorMessage) {
        super.createDialog(LOGIN_TITLE, RepositoryDialog.getRepoURL(LOGIN_WEB_CLIENT_PATH) + "/" + repositoryMeta.getName(), 67680, LOGO);
        return this.open(repositoryMeta, true, errorMessage);
    }

    public boolean openLogin(RepositoryMeta repositoryMeta) {
        super.createDialog(LOGIN_TITLE, RepositoryDialog.getRepoURL(LOGIN_WEB_CLIENT_PATH) + "/" + repositoryMeta.getName(), 67680, LOGO);
        return this.open(repositoryMeta);
    }

    private void setResult(boolean result) {
        this.result = result;
    }

    private static Integer getOsgiServicePort() {
        ServerPort osgiServicePort = ServerPortRegistry.getPort((String)OSGI_SERVICE_PORT);
        if (osgiServicePort != null) {
            return osgiServicePort.getAssignedPort();
        }
        return null;
    }

    private static String getClientPath() {
        Properties properties = new Properties();
        try {
            InputStream inputStream = RepositoryDialog.class.getClassLoader().getResourceAsStream("project.properties");
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties.getProperty("CLIENT_PATH");
    }

    private static String getRepoURL(String path) {
        return "http://localhost:" + RepositoryDialog.getOsgiServicePort() + RepositoryDialog.getClientPath() + path;
    }
}

